/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg.db.cdt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.photran.internal.db.org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.photran.internal.db.org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.photran.internal.db.org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.photran.internal.db.org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.photran.internal.db.org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.photran.internal.db.org.eclipse.cdt.internal.core.pdom.db.IString;

public class InternalCDTDB {
    static final int FILENAME_BTREE_ROOT = 1028;
    static final int FORWARD_DEPENDENCY_BTREE_ROOT = 1032;
    static final int REVERSE_DEPENDENCY_BTREE_ROOT = 1036;
    static final int FORWARD_EDGE_BTREE_ROOT = 1040;
    static final int REVERSE_EDGE_BTREE_ROOT = 1044;
    static final int ANNOTATION_BTREE_ROOT = 1048;
    protected File file;
    protected Database db;
    public final Files files;
    public final Dependencies dependencies;
    public final Edges edges;
    public final Annotations annotations;

    public InternalCDTDB(File file) throws CoreException {
        this.file = file;
        this.db = new Database(file, new ChunkCache(), 0, false);
        this.db.setExclusiveLock();
        this.files = new Files();
        this.dependencies = new Dependencies();
        this.edges = new Edges();
        this.annotations = new Annotations();
    }

    public File getFile() {
        return this.file;
    }

    public void flush() throws CoreException {
        this.db.flush();
    }

    public void close() throws CoreException {
        this.db.close();
        this.db = null;
    }

    public void clear() throws CoreException {
        this.db.clear(0);
    }

    private static int lexicographicallyCompare(int[] tuple1, int[] tuple2) {
        int length = Math.min(tuple1.length, tuple2.length);
        int i = 0;
        while (i < length) {
            if (tuple1[i] < tuple2[i]) {
                return -1;
            }
            if (tuple1[i] > tuple2[i]) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public class Annotations {
        protected static final int FILE_FIELD = 0;
        protected static final int OFFSET_FIELD = 4;
        protected static final int LENGTH_FIELD = 8;
        protected static final int ANNOTATION_TYPE_FIELD = 12;
        protected static final int ANNOTATION_PTR_FIELD = 16;
        protected static final int ANNOTATION_LENGTH_FIELD = 20;
        public static final int RECORD_SIZE = 24;
        protected BTree annotationBTree;

        public Annotations() {
            this.annotationBTree = new BTree(InternalCDTDB.this.db, 1048, new IBTreeComparator(){

                public int compare(int record1, int record2) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Annotations.this.getRecordAsTuple(record1), Annotations.this.getRecordAsTuple(record2));
                }
            });
        }

        public int getFileRecordPtr(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 0);
        }

        public void setFileRecordPtr(int dependencyRecord, int fileRecord) throws CoreException {
            InternalCDTDB.this.db.putInt(dependencyRecord + 0, fileRecord);
        }

        public int getOffset(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 4);
        }

        public void setOffset(int dependencyRecord, int value) throws CoreException {
            InternalCDTDB.this.db.putInt(dependencyRecord + 4, value);
        }

        public int getLength(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 8);
        }

        public void setLength(int dependencyRecord, int value) throws CoreException {
            InternalCDTDB.this.db.putInt(dependencyRecord + 8, value);
        }

        public int getAnnotationType(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 12);
        }

        public void setAnnotationType(int record, int value) throws CoreException {
            InternalCDTDB.this.db.putInt(record + 12, value);
        }

        public int getAnnotationPtr(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 16);
        }

        public int getAnnotationLength(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 20);
        }

        public InputStream getAnnotation(int record) throws CoreException {
            return new InputStream(record){
                private int annotationRecord;
                private int length;
                private int i;
                {
                    this.annotationRecord = Annotations.this.getAnnotationPtr(n);
                    this.length = Annotations.this.getAnnotationLength(n);
                    this.i = 0;
                }

                @Override
                public int read() throws IOException {
                    try {
                        if (this.i < this.length) {
                            return ((Annotations)Annotations.this).InternalCDTDB.this.db.getByte(this.annotationRecord + this.i++) & 0xFF;
                        }
                        return -1;
                    }
                    catch (CoreException e) {
                        throw new IOException("Internal error reading serialized object from database: " + e.getMessage());
                    }
                }
            };
        }

        public void setAnnotation(int record, byte[] annotation) throws CoreException {
            int annotationPtr = InternalCDTDB.this.db.malloc(annotation.length);
            int i = 0;
            while (i < annotation.length) {
                InternalCDTDB.this.db.putByte(annotationPtr + i, annotation[i]);
                ++i;
            }
            InternalCDTDB.this.db.putInt(record + 16, annotationPtr);
            InternalCDTDB.this.db.putInt(record + 20, annotation.length);
        }

        protected int[] getRecordAsTuple(int record) throws CoreException {
            return new int[]{this.getFileRecordPtr(record), this.getOffset(record), this.getLength(record), this.getAnnotationType(record)};
        }

        protected int createNewRecord(int file, int offset, int length, int annotationType, byte[] annotation) throws CoreException {
            int record = InternalCDTDB.this.db.malloc(24);
            this.setFileRecordPtr(record, file);
            this.setOffset(record, offset);
            this.setLength(record, length);
            this.setAnnotationType(record, annotationType);
            this.setAnnotation(record, annotation);
            this.annotationBTree.insert(record);
            return record;
        }

        public int findRecordFor(String filename, int offset, int length, int annotationType) throws CoreException {
            int fromFileRecordPtr = InternalCDTDB.this.files.findRecordFor(filename);
            if (fromFileRecordPtr < 0) {
                return -1;
            }
            return this.findRecordFor(fromFileRecordPtr, offset, length, annotationType);
        }

        private int findRecordFor(int fileRecordPtr, int offset, int length, int annotationType) throws CoreException {
            final int[] tuple2 = new int[]{fileRecordPtr, offset, length, annotationType};
            FindVisitor visitor = new FindVisitor(InternalCDTDB.this){

                public int compare(int record1) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Annotations.this.getRecordAsTuple(record1), tuple2);
                }
            };
            this.annotationBTree.accept((IBTreeVisitor)visitor);
            return visitor.getRecord();
        }

        public int set(String fromFilename, int fromOffset, int fromLength, int edgeType, byte[] annotation) throws CoreException {
            this.delete(fromFilename, fromOffset, fromLength, edgeType);
            return this.createNewRecord(InternalCDTDB.this.files.ensure(fromFilename), fromOffset, fromLength, edgeType, annotation);
        }

        public void delete(String fromFilename, int fromOffset, int fromLength, int edgeType) throws CoreException {
            int record = this.findRecordFor(fromFilename, fromOffset, fromLength, edgeType);
            if (record < 0) {
                return;
            }
            InternalCDTDB.this.db.free(this.getAnnotationPtr(record));
            this.annotationBTree.delete(record);
            InternalCDTDB.this.db.free(record);
        }

        public void deleteAllAnnotationsFor(String fromFilename) throws CoreException {
            IntVector records = this.findAllAnnotationRecordsFor(fromFilename);
            int i = 0;
            int size = records.size();
            while (i < size) {
                int record = records.get(i);
                InternalCDTDB.this.db.free(this.getAnnotationPtr(record));
                this.annotationBTree.delete(record);
                InternalCDTDB.this.db.free(record);
                ++i;
            }
        }

        public IntVector findAllAnnotationRecordsFor(String fromFilename) throws CoreException {
            return this.findAllAnnotationRecords(new int[]{InternalCDTDB.this.files.findRecordFor(fromFilename)});
        }

        public IntVector findAllAnnotationRecordsFor(String fromFilename, int offset, int length) throws CoreException {
            return this.findAllAnnotationRecords(new int[]{InternalCDTDB.this.files.findRecordFor(fromFilename), offset, length});
        }

        protected IntVector findAllAnnotationRecords(final int[] tuple2) throws CoreException {
            if (tuple2[0] < 0) {
                return new IntVector();
            }
            final IntVector records = new IntVector();
            this.annotationBTree.accept(new IBTreeVisitor(){

                public int compare(int record1) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Annotations.this.getRecordAsTuple(record1), tuple2);
                }

                public boolean visit(int record) throws CoreException {
                    records.add(record);
                    return true;
                }
            });
            return records;
        }

        public boolean hasAnnotations(String filename) throws CoreException {
            final int[] tuple2 = new int[]{InternalCDTDB.this.files.findRecordFor(filename)};
            if (tuple2[0] < 0) {
                return false;
            }
            FindVisitor v = new FindVisitor(InternalCDTDB.this){

                public int compare(int record1) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Annotations.this.getRecordAsTuple(record1), tuple2);
                }
            };
            this.annotationBTree.accept((IBTreeVisitor)v);
            return v.foundRecord();
        }

        public String toString() {
            final StringBuilder sb = new StringBuilder();
            try {
                this.annotationBTree.accept(new IBTreeVisitor(){

                    public int compare(int record) throws CoreException {
                        return 0;
                    }

                    public boolean visit(int record) throws CoreException {
                        sb.append("Annotation of type ");
                        sb.append(Annotations.this.getAnnotationType(record));
                        sb.append(" on ");
                        sb.append(((Annotations)Annotations.this).InternalCDTDB.this.files.getFilename(Annotations.this.getFileRecordPtr(record)).getChars());
                        sb.append(", offset ");
                        sb.append(Annotations.this.getOffset(record));
                        sb.append(", length ");
                        sb.append(Annotations.this.getLength(record));
                        sb.append(" (");
                        sb.append(record);
                        sb.append(")\n");
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                sb.append((Object)e);
            }
            return sb.toString();
        }
    }

    public class Dependencies {
        protected static final int DEPENDENT_FILE_FIELD = 0;
        protected static final int DEPENDS_ON_FILE_FIELD = 4;
        public static final int RECORD_SIZE = 8;
        protected BTree forwardDependencyBTree;
        protected BTree reverseDependencyBTree;

        public Dependencies() {
            this.forwardDependencyBTree = new BTree(InternalCDTDB.this.db, 1032, new IBTreeComparator(){

                public int compare(int record1, int record2) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Dependencies.this.getRecordAsTuple(record1), Dependencies.this.getRecordAsTuple(record2));
                }
            });
            this.reverseDependencyBTree = new BTree(InternalCDTDB.this.db, 1036, new IBTreeComparator(){

                public int compare(int record1, int record2) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Dependencies.this.getReverseRecordAsTuple(record1), Dependencies.this.getReverseRecordAsTuple(record2));
                }
            });
        }

        public int getDependentFileRecordPtr(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 0);
        }

        public void setDependentFileRecordPtr(int dependencyRecord, int fileRecord) throws CoreException {
            InternalCDTDB.this.db.putInt(dependencyRecord + 0, fileRecord);
        }

        public int getDependsOnFileRecordPtr(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 4);
        }

        public void setDependsOnFileRecordPtr(int dependencyRecord, int fileRecord) throws CoreException {
            InternalCDTDB.this.db.putInt(dependencyRecord + 4, fileRecord);
        }

        protected int[] getRecordAsTuple(int record) throws CoreException {
            return new int[]{this.getDependentFileRecordPtr(record), this.getDependsOnFileRecordPtr(record)};
        }

        protected int[] getReverseRecordAsTuple(int record) throws CoreException {
            return new int[]{this.getDependsOnFileRecordPtr(record), this.getDependentFileRecordPtr(record)};
        }

        protected int createNewRecord(int dependentFile, int dependsOnFile) throws CoreException {
            int record = InternalCDTDB.this.db.malloc(8);
            this.setDependentFileRecordPtr(record, dependentFile);
            this.setDependsOnFileRecordPtr(record, dependsOnFile);
            this.forwardDependencyBTree.insert(record);
            this.reverseDependencyBTree.insert(record);
            return record;
        }

        private int findRecordFor(String filename1, String filename2) throws CoreException {
            int fromFileRecordPtr = InternalCDTDB.this.files.findRecordFor(filename1);
            if (fromFileRecordPtr < 0) {
                return -1;
            }
            int toFileRecordPtr = InternalCDTDB.this.files.findRecordFor(filename2);
            if (toFileRecordPtr < 0) {
                return -1;
            }
            return this.findRecordFor(fromFileRecordPtr, toFileRecordPtr);
        }

        private int findRecordFor(int fromFileRecordPtr, int toFileRecordPtr) throws CoreException {
            final int[] tuple2 = new int[]{fromFileRecordPtr, toFileRecordPtr};
            FindVisitor visitor = new FindVisitor(InternalCDTDB.this){

                public int compare(int record1) throws CoreException {
                    int[] tuple1 = Dependencies.this.getRecordAsTuple(record1);
                    return InternalCDTDB.lexicographicallyCompare(tuple1, tuple2);
                }
            };
            this.forwardDependencyBTree.accept((IBTreeVisitor)visitor);
            return visitor.getRecord();
        }

        public int ensure(String filename1, String filename2) throws CoreException {
            int toFileRecordPtr;
            int fromFileRecordPtr = InternalCDTDB.this.files.ensure(filename1);
            int result = this.findRecordFor(fromFileRecordPtr, toFileRecordPtr = InternalCDTDB.this.files.ensure(filename2));
            return result < 0 ? this.createNewRecord(fromFileRecordPtr, toFileRecordPtr) : result;
        }

        public void delete(String filename1, String filename2) throws CoreException {
            int record = this.findRecordFor(filename1, filename2);
            if (record < 0) {
                return;
            }
            this.forwardDependencyBTree.delete(record);
            this.reverseDependencyBTree.delete(record);
            InternalCDTDB.this.db.free(record);
        }

        public void deleteAllOutgoingDependenciesFrom(String fromFilename) throws CoreException {
            IntVector records = this.findAllOutgoingDependencyRecordsFrom(fromFilename);
            int i = 0;
            int size = records.size();
            while (i < size) {
                int record = records.get(i);
                this.forwardDependencyBTree.delete(record);
                this.reverseDependencyBTree.delete(record);
                InternalCDTDB.this.db.free(record);
                ++i;
            }
        }

        public void deleteAllIncomingDependenciesTo(String toFilename) throws CoreException {
            IntVector records = this.findAllIncomingDependencyRecordsTo(toFilename);
            int i = 0;
            int size = records.size();
            while (i < size) {
                int record = records.get(i);
                this.forwardDependencyBTree.delete(record);
                this.reverseDependencyBTree.delete(record);
                InternalCDTDB.this.db.free(record);
                ++i;
            }
        }

        public boolean hasOutgoingDependencyRecords(String fromFilename) throws CoreException {
            int fromFileRecordPtr = InternalCDTDB.this.files.findRecordFor(fromFilename);
            if (fromFileRecordPtr == -1) {
                return false;
            }
            final int[] tuple2 = new int[]{fromFileRecordPtr};
            FindVisitor v = new FindVisitor(InternalCDTDB.this){

                public int compare(int record1) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Dependencies.this.getRecordAsTuple(record1), tuple2);
                }
            };
            this.forwardDependencyBTree.accept((IBTreeVisitor)v);
            return v.foundRecord();
        }

        public IntVector findAllOutgoingDependencyRecordsFrom(String fromFilename) throws CoreException {
            final IntVector records = new IntVector();
            int fromFileRecordPtr = InternalCDTDB.this.files.findRecordFor(fromFilename);
            if (fromFileRecordPtr == -1) {
                return records;
            }
            final int[] tuple2 = new int[]{fromFileRecordPtr};
            this.forwardDependencyBTree.accept(new IBTreeVisitor(){

                public int compare(int record1) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Dependencies.this.getRecordAsTuple(record1), tuple2);
                }

                public boolean visit(int record) throws CoreException {
                    records.add(record);
                    return true;
                }
            });
            return records;
        }

        public boolean hasIncomingDependencyRecords(String toFilename) throws CoreException {
            int toFileRecordPtr = InternalCDTDB.this.files.findRecordFor(toFilename);
            if (toFileRecordPtr == -1) {
                return false;
            }
            final int[] tuple2 = new int[]{toFileRecordPtr};
            FindVisitor v = new FindVisitor(InternalCDTDB.this){

                public int compare(int record1) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Dependencies.this.getReverseRecordAsTuple(record1), tuple2);
                }
            };
            this.reverseDependencyBTree.accept((IBTreeVisitor)v);
            return v.foundRecord();
        }

        public IntVector findAllIncomingDependencyRecordsTo(String toFilename) throws CoreException {
            final IntVector records = new IntVector();
            int toFileRecordPtr = InternalCDTDB.this.files.findRecordFor(toFilename);
            if (toFileRecordPtr == -1) {
                return records;
            }
            final int[] tuple2 = new int[]{toFileRecordPtr};
            this.reverseDependencyBTree.accept(new IBTreeVisitor(){

                public int compare(int record1) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Dependencies.this.getReverseRecordAsTuple(record1), tuple2);
                }

                public boolean visit(int record) throws CoreException {
                    records.add(record);
                    return true;
                }
            });
            return records;
        }

        public Iterable<String> listAllFilenamesWithDependents() throws CoreException {
            final TreeSet<String> result = new TreeSet<String>();
            this.reverseDependencyBTree.accept(new IBTreeVisitor(){

                public int compare(int record) throws CoreException {
                    return 0;
                }

                public boolean visit(int record) throws CoreException {
                    result.add(((Dependencies)Dependencies.this).InternalCDTDB.this.files.getFilename(Dependencies.this.getDependsOnFileRecordPtr(record)).getString());
                    return true;
                }
            });
            return result;
        }

        public Iterable<String> listAllDependentFilenames() throws CoreException {
            final TreeSet<String> result = new TreeSet<String>();
            this.forwardDependencyBTree.accept(new IBTreeVisitor(){

                public int compare(int record) throws CoreException {
                    return 0;
                }

                public boolean visit(int record) throws CoreException {
                    result.add(((Dependencies)Dependencies.this).InternalCDTDB.this.files.getFilename(Dependencies.this.getDependentFileRecordPtr(record)).getString());
                    return true;
                }
            });
            return result;
        }

        public String toString() {
            final StringBuilder sb = new StringBuilder();
            try {
                this.forwardDependencyBTree.accept(new IBTreeVisitor(){

                    public int compare(int record) throws CoreException {
                        return 0;
                    }

                    public boolean visit(int record) throws CoreException {
                        sb.append(((Dependencies)Dependencies.this).InternalCDTDB.this.files.getFilename(Dependencies.this.getDependentFileRecordPtr(record)).getChars());
                        sb.append(" depends on ");
                        sb.append(((Dependencies)Dependencies.this).InternalCDTDB.this.files.getFilename(Dependencies.this.getDependsOnFileRecordPtr(record)).getChars());
                        sb.append(" (");
                        sb.append(record);
                        sb.append(")\n");
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                sb.append((Object)e);
            }
            return sb.toString();
        }
    }

    public class Edges {
        protected static final int FROM_FILE_FIELD = 0;
        protected static final int FROM_OFFSET_FIELD = 4;
        protected static final int FROM_LENGTH_FIELD = 8;
        protected static final int TO_FILE_FIELD = 12;
        protected static final int TO_OFFSET_FIELD = 16;
        protected static final int TO_LENGTH_FIELD = 20;
        protected static final int EDGE_TYPE_FIELD = 24;
        public static final int RECORD_SIZE = 28;
        protected BTree forwardEdgeBTree;
        protected BTree reverseEdgeBTree;

        public Edges() {
            this.forwardEdgeBTree = new BTree(InternalCDTDB.this.db, 1040, new IBTreeComparator(){

                public int compare(int record1, int record2) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Edges.this.getRecordAsTuple(record1), Edges.this.getRecordAsTuple(record2));
                }
            });
            this.reverseEdgeBTree = new BTree(InternalCDTDB.this.db, 1044, new IBTreeComparator(){

                public int compare(int record1, int record2) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Edges.this.getReverseRecordAsTuple(record1), Edges.this.getReverseRecordAsTuple(record2));
                }
            });
        }

        public int getFromFileRecordPtr(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 0);
        }

        public void setFromFileRecordPtr(int dependencyRecord, int fileRecord) throws CoreException {
            InternalCDTDB.this.db.putInt(dependencyRecord + 0, fileRecord);
        }

        public int getFromOffset(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 4);
        }

        public void setFromOffset(int dependencyRecord, int value) throws CoreException {
            InternalCDTDB.this.db.putInt(dependencyRecord + 4, value);
        }

        public int getFromLength(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 8);
        }

        public void setFromLength(int dependencyRecord, int value) throws CoreException {
            InternalCDTDB.this.db.putInt(dependencyRecord + 8, value);
        }

        public int getToFileRecordPtr(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 12);
        }

        public void setToFileRecordPtr(int dependencyRecord, int fileRecord) throws CoreException {
            InternalCDTDB.this.db.putInt(dependencyRecord + 12, fileRecord);
        }

        public int getToOffset(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 16);
        }

        public void setToOffset(int record, int value) throws CoreException {
            InternalCDTDB.this.db.putInt(record + 16, value);
        }

        public int getToLength(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 20);
        }

        public void setToLength(int record, int value) throws CoreException {
            InternalCDTDB.this.db.putInt(record + 20, value);
        }

        public int getEdgeType(int record) throws CoreException {
            return InternalCDTDB.this.db.getInt(record + 24);
        }

        public void setEdgeType(int record, int value) throws CoreException {
            InternalCDTDB.this.db.putInt(record + 24, value);
        }

        protected int[] getRecordAsTuple(int record) throws CoreException {
            return new int[]{this.getFromFileRecordPtr(record), this.getFromOffset(record), this.getFromLength(record), this.getEdgeType(record), this.getToFileRecordPtr(record), this.getToOffset(record), this.getToLength(record)};
        }

        protected int[] getReverseRecordAsTuple(int record) throws CoreException {
            return new int[]{this.getToFileRecordPtr(record), this.getToOffset(record), this.getToLength(record), this.getEdgeType(record), this.getFromFileRecordPtr(record), this.getFromOffset(record), this.getFromLength(record)};
        }

        protected int createNewRecord(int fromFile, int fromOffset, int fromLength, int toFile, int toOffset, int toLength, int edgeType) throws CoreException {
            int record = InternalCDTDB.this.db.malloc(28);
            this.setFromFileRecordPtr(record, fromFile);
            this.setFromOffset(record, fromOffset);
            this.setFromLength(record, fromLength);
            this.setToFileRecordPtr(record, toFile);
            this.setToOffset(record, toOffset);
            this.setToLength(record, toLength);
            this.setEdgeType(record, edgeType);
            this.forwardEdgeBTree.insert(record);
            this.reverseEdgeBTree.insert(record);
            return record;
        }

        private int findRecordFor(String fromFilename, int fromOffset, int fromLength, String toFilename, int toOffset, int toLength, int edgeType) throws CoreException {
            int fromFileRecordPtr = InternalCDTDB.this.files.findRecordFor(fromFilename);
            if (fromFileRecordPtr < 0) {
                return -1;
            }
            int toFileRecordPtr = InternalCDTDB.this.files.findRecordFor(toFilename);
            if (toFileRecordPtr < 0) {
                return -1;
            }
            return this.findRecordFor(fromFileRecordPtr, fromOffset, fromLength, toFileRecordPtr, toOffset, toLength, edgeType);
        }

        private int findRecordFor(int fromFileRecordPtr, int fromOffset, int fromLength, int toFileRecordPtr, int toOffset, int toLength, int edgeType) throws CoreException {
            final int[] tuple2 = new int[]{fromFileRecordPtr, fromOffset, fromLength, edgeType, toFileRecordPtr, toOffset, toLength};
            FindVisitor visitor = new FindVisitor(InternalCDTDB.this){

                public int compare(int record1) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Edges.this.getRecordAsTuple(record1), tuple2);
                }
            };
            this.forwardEdgeBTree.accept((IBTreeVisitor)visitor);
            return visitor.getRecord();
        }

        public int ensure(String fromFilename, int fromOffset, int fromLength, String toFilename, int toOffset, int toLength, int edgeType) throws CoreException {
            int toFileRecordPtr;
            int fromFileRecordPtr = InternalCDTDB.this.files.ensure(fromFilename);
            int result = this.findRecordFor(fromFileRecordPtr, fromOffset, fromLength, toFileRecordPtr = InternalCDTDB.this.files.ensure(toFilename), toOffset, toLength, edgeType);
            return result < 0 ? this.createNewRecord(fromFileRecordPtr, fromOffset, fromLength, toFileRecordPtr, toOffset, toLength, edgeType) : result;
        }

        public void delete(String fromFilename, int fromOffset, int fromLength, String toFilename, int toOffset, int toLength, int edgeType) throws CoreException {
            int record = this.findRecordFor(fromFilename, fromOffset, fromLength, toFilename, toOffset, toLength, edgeType);
            if (record < 0) {
                return;
            }
            this.forwardEdgeBTree.delete(record);
            this.reverseEdgeBTree.delete(record);
            InternalCDTDB.this.db.free(record);
        }

        public void deleteAllOutgoingEdgesFrom(String fromFilename) throws CoreException {
            IntVector records = this.findAllOutgoingEdgeRecordsFrom(fromFilename);
            int i = 0;
            int size = records.size();
            while (i < size) {
                int record = records.get(i);
                this.forwardEdgeBTree.delete(record);
                this.reverseEdgeBTree.delete(record);
                InternalCDTDB.this.db.free(record);
                ++i;
            }
        }

        public void deleteAllIncomingEdgesTo(String toFilename) throws CoreException {
            IntVector records = this.findAllIncomingEdgeRecordsTo(toFilename);
            int i = 0;
            int size = records.size();
            while (i < size) {
                int record = records.get(i);
                this.forwardEdgeBTree.delete(record);
                this.reverseEdgeBTree.delete(record);
                InternalCDTDB.this.db.free(record);
                ++i;
            }
        }

        public IntVector findAllOutgoingEdgeRecordsFrom(String fromFilename) throws CoreException {
            return this.findAllOutgoingEdgeRecords(new int[]{InternalCDTDB.this.files.findRecordFor(fromFilename)});
        }

        public IntVector findAllOutgoingEdgeRecordsFrom(String fromFilename, int offset, int length) throws CoreException {
            return this.findAllOutgoingEdgeRecords(new int[]{InternalCDTDB.this.files.findRecordFor(fromFilename), offset, length});
        }

        public IntVector findAllOutgoingEdgeRecordsFrom(String fromFilename, int offset, int length, int edgeType) throws CoreException {
            return this.findAllOutgoingEdgeRecords(new int[]{InternalCDTDB.this.files.findRecordFor(fromFilename), offset, length, edgeType});
        }

        protected IntVector findAllOutgoingEdgeRecords(final int[] tuple2) throws CoreException {
            if (tuple2[0] < 0) {
                return new IntVector();
            }
            final IntVector records = new IntVector();
            this.forwardEdgeBTree.accept(new IBTreeVisitor(){

                public int compare(int record1) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Edges.this.getRecordAsTuple(record1), tuple2);
                }

                public boolean visit(int record) throws CoreException {
                    records.add(record);
                    return true;
                }
            });
            return records;
        }

        public boolean hasOutgoingEdges(String filename) throws CoreException {
            final int[] tuple2 = new int[]{InternalCDTDB.this.files.findRecordFor(filename)};
            if (tuple2[0] < 0) {
                return false;
            }
            FindVisitor v = new FindVisitor(InternalCDTDB.this){

                public int compare(int record1) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Edges.this.getRecordAsTuple(record1), tuple2);
                }
            };
            this.forwardEdgeBTree.accept((IBTreeVisitor)v);
            return v.foundRecord();
        }

        public IntVector findAllIncomingEdgeRecordsTo(String fromFilename) throws CoreException {
            return this.findAllIncomingEdgeRecords(new int[]{InternalCDTDB.this.files.findRecordFor(fromFilename)});
        }

        public IntVector findAllIncomingEdgeRecordsTo(String fromFilename, int offset, int length) throws CoreException {
            return this.findAllIncomingEdgeRecords(new int[]{InternalCDTDB.this.files.findRecordFor(fromFilename), offset, length});
        }

        public IntVector findAllIncomingEdgeRecordsTo(String fromFilename, int offset, int length, int edgeType) throws CoreException {
            return this.findAllIncomingEdgeRecords(new int[]{InternalCDTDB.this.files.findRecordFor(fromFilename), offset, length, edgeType});
        }

        protected IntVector findAllIncomingEdgeRecords(final int[] tuple2) throws CoreException {
            if (tuple2[0] < 0) {
                return new IntVector();
            }
            final IntVector records = new IntVector();
            this.reverseEdgeBTree.accept(new IBTreeVisitor(){

                public int compare(int record1) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Edges.this.getReverseRecordAsTuple(record1), tuple2);
                }

                public boolean visit(int record) throws CoreException {
                    records.add(record);
                    return true;
                }
            });
            return records;
        }

        public boolean hasIncomingEdges(String filename) throws CoreException {
            final int[] tuple2 = new int[]{InternalCDTDB.this.files.findRecordFor(filename)};
            if (tuple2[0] < 0) {
                return false;
            }
            FindVisitor v = new FindVisitor(InternalCDTDB.this){

                public int compare(int record1) throws CoreException {
                    return InternalCDTDB.lexicographicallyCompare(Edges.this.getReverseRecordAsTuple(record1), tuple2);
                }
            };
            this.reverseEdgeBTree.accept((IBTreeVisitor)v);
            return v.foundRecord();
        }

        public String toString() {
            final StringBuilder sb = new StringBuilder();
            try {
                this.forwardEdgeBTree.accept(new IBTreeVisitor(){

                    public int compare(int record) throws CoreException {
                        return 0;
                    }

                    public boolean visit(int record) throws CoreException {
                        sb.append("Edge of type ");
                        sb.append(Edges.this.getEdgeType(record));
                        sb.append(" from ");
                        sb.append(((Edges)Edges.this).InternalCDTDB.this.files.getFilename(Edges.this.getFromFileRecordPtr(record)).getChars());
                        sb.append(", offset ");
                        sb.append(Edges.this.getFromOffset(record));
                        sb.append(", length ");
                        sb.append(Edges.this.getFromLength(record));
                        sb.append(" to ");
                        sb.append(((Edges)Edges.this).InternalCDTDB.this.files.getFilename(Edges.this.getToFileRecordPtr(record)).getChars());
                        sb.append(", offset ");
                        sb.append(Edges.this.getToOffset(record));
                        sb.append(", length ");
                        sb.append(Edges.this.getToLength(record));
                        sb.append(" (");
                        sb.append(record);
                        sb.append(")\n");
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                sb.append((Object)e);
            }
            return sb.toString();
        }
    }

    public class Files {
        protected static final int FILENAME_FIELD = 0;
        protected static final int MODIFICATION_STAMP_FIELD = 4;
        public static final int RECORD_SIZE = 8;
        protected BTree filenameBTree;

        public Files() {
            this.filenameBTree = new BTree(InternalCDTDB.this.db, 1028, new IBTreeComparator(){

                public int compare(int record1, int record2) throws CoreException {
                    return Files.this.getFilename(record1).compare(Files.this.getFilename(record2), true);
                }
            });
        }

        public IString getFilename(int record) throws CoreException {
            return InternalCDTDB.this.db.getString(InternalCDTDB.this.db.getInt(record + 0));
        }

        public void setFilename(int record, String filename) throws CoreException {
            InternalCDTDB.this.db.putInt(record + 0, InternalCDTDB.this.db.newString(filename).getRecord());
        }

        public long getModificationStamp(int record) throws CoreException {
            return InternalCDTDB.this.db.getLong(record + 4);
        }

        public void setModificationStamp(int record, long timestamp) throws CoreException {
            InternalCDTDB.this.db.putLong(record + 4, timestamp);
        }

        protected int createNewRecord(String filename) throws CoreException {
            int record = InternalCDTDB.this.db.malloc(8);
            this.setFilename(record, filename);
            this.setModificationStamp(record, Integer.MIN_VALUE);
            this.filenameBTree.insert(record);
            return record;
        }

        public int findRecordFor(final String filename) throws CoreException {
            FindVisitor visitor = new FindVisitor(InternalCDTDB.this){

                public int compare(int record) throws CoreException {
                    return Files.this.getFilename(record).compare(filename, true);
                }
            };
            this.filenameBTree.accept((IBTreeVisitor)visitor);
            return visitor.getRecord();
        }

        public IntVector findAllFileRecords() throws CoreException {
            final IntVector records = new IntVector();
            this.filenameBTree.accept(new IBTreeVisitor(){

                public int compare(int record) throws CoreException {
                    return 0;
                }

                public boolean visit(int record) throws CoreException {
                    records.add(record);
                    return true;
                }
            });
            return records;
        }

        public int ensure(String filename) throws CoreException {
            int record = this.findRecordFor(filename);
            return record < 0 ? this.createNewRecord(filename) : record;
        }

        public void delete(String filename) throws CoreException {
            int record = this.findRecordFor(filename);
            if (record < 0) {
                return;
            }
            this.filenameBTree.delete(record);
            InternalCDTDB.this.db.free(record);
        }

        public Iterable<String> getAllFilenames() throws CoreException {
            final TreeSet<String> result = new TreeSet<String>();
            this.filenameBTree.accept(new IBTreeVisitor(){

                public int compare(int record) throws CoreException {
                    return 0;
                }

                public boolean visit(int record) throws CoreException {
                    result.add(Files.this.getFilename(record).getString());
                    return true;
                }
            });
            return result;
        }

        public String toString() {
            final StringBuilder sb = new StringBuilder();
            try {
                this.filenameBTree.accept(new IBTreeVisitor(){

                    public int compare(int record) throws CoreException {
                        return 0;
                    }

                    public boolean visit(int record) throws CoreException {
                        sb.append(Files.this.getFilename(record).getChars());
                        sb.append(" (");
                        sb.append(record);
                        sb.append(")\n");
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                sb.append((Object)e);
            }
            return sb.toString();
        }
    }

    protected abstract class FindVisitor
    implements IBTreeVisitor {
        private int record = -1;

        protected FindVisitor() {
        }

        public boolean visit(int record) {
            this.record = record;
            return false;
        }

        public boolean foundRecord() {
            return this.record >= 0;
        }

        public int getRecord() {
            return this.record;
        }
    }

    public static class IntVector {
        private int[] array;
        private int size;

        public IntVector() {
            this(64);
        }

        public IntVector(int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Initial capacity must be a positive integer (not " + initialCapacity + ")");
            }
            this.array = new int[initialCapacity];
            this.size = 0;
        }

        public void ensureCapacity(int minCapacity) {
            if (minCapacity <= this.array.length) {
                return;
            }
            int newCapacity = Math.max(this.array.length * 3 / 2 + 1, minCapacity);
            int[] newStack = new int[newCapacity];
            System.arraycopy(this.array, 0, newStack, 0, this.size);
            this.array = newStack;
        }

        public void add(int value) {
            this.ensureCapacity(this.size + 1);
            this.array[this.size++] = value;
        }

        public int get(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.array[index];
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public void clear() {
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            int i = 0;
            while (i < this.size) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.array[i]);
                ++i;
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

