/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.IValidator;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractUpdateModel
implements IUpdateModel {
    protected final Job validateJob;
    protected boolean canSave;
    protected String name;
    protected ILaunchConfiguration configuration;
    protected IVariableMap rmMap;
    protected IVariableMap lcMap;
    protected IUpdateHandler handler;
    protected boolean refreshing;
    protected IValidator validator;
    protected String defaultValue;
    protected String[] booleanToString;
    protected Object mapValue;

    protected AbstractUpdateModel(String name, IUpdateHandler handler) {
        this.name = name;
        this.canSave = name != null && !"".equals(name);
        this.handler = handler;
        this.refreshing = false;
        this.validateJob = new ValidateJob();
    }

    protected Object getBooleanValue(Boolean b) {
        if (this.booleanToString != null) {
            return b != false ? this.booleanToString[0] : this.booleanToString[1];
        }
        return b;
    }

    public abstract Object getControl();

    public String getName() {
        return this.name;
    }

    protected void handleUpdate(Object value) {
        this.handler.handleUpdate(this.getControl(), value);
    }

    public void initialize(ILaunchConfiguration configuration, IVariableMap rmMap, IVariableMap lcMap) {
        this.configuration = configuration;
        this.rmMap = rmMap;
        this.lcMap = lcMap;
        if (this.name != null) {
            this.defaultValue = lcMap.getDefault(this.name);
        }
        this.refreshValueFromMap();
        if (this.mapValue == null) {
            this.restoreDefault();
            this.refreshValueFromMap();
        }
    }

    public boolean isWritable() {
        return this.canSave;
    }

    protected boolean maybeGetBooleanFromString(Object mapValue) {
        boolean b = false;
        if (mapValue != null) {
            b = mapValue instanceof String ? (this.booleanToString != null ? mapValue.equals(this.booleanToString[0]) : Boolean.parseBoolean((String)mapValue)) : (Boolean)mapValue;
        }
        return b;
    }

    public void restoreDefault() {
        this.lcMap.setDefault(this.name, this.defaultValue);
    }

    protected void setBooleanToString(String translateBooleanAs) {
        String[] pair;
        this.booleanToString = translateBooleanAs == null ? null : ((pair = translateBooleanAs.split(",")).length == 2 ? pair : null);
    }

    public void setValidator(IValidator validator) {
        this.validator = validator;
    }

    public Object storeValue() throws Exception {
        Object value = this.validate();
        this.lcMap.putValue(this.name, value);
        return value;
    }

    private Object validate() throws Exception {
        Object value = this.getValueFromControl();
        String error = null;
        if (this.validator != null) {
            try {
                this.validator.validate(value);
            }
            catch (Exception t) {
                error = this.validator.getErrorMessage();
            }
        }
        if (error != null) {
            this.handler.addError(this.name, error);
            throw new Exception(error);
        }
        this.handler.removeError(this.name);
        return value;
    }

    protected class ValidateJob
    extends UIJob {
        public ValidateJob() {
            super("ValidateJob");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                Object value = AbstractUpdateModel.this.storeValue();
                AbstractUpdateModel.this.handleUpdate(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Status.OK_STATUS;
        }
    }
}

