/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.managers;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ptp.internal.ui.IElementManager;
import org.eclipse.ptp.internal.ui.listeners.ISetListener;
import org.eclipse.ptp.internal.ui.model.IElementHandler;
import org.eclipse.ptp.internal.ui.model.IElementSet;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractElementManager
implements IElementManager {
    protected String cur_set_id = "";
    protected Map<String, IElementHandler> elementHandlers = new HashMap<String, IElementHandler>();
    protected ListenerList setListeners = new ListenerList();

    @Override
    public void addToSet(String setID, IElementHandler elementHandler, BitSet elements) {
        IElementSet set = elementHandler.getSet(setID);
        set.addElements(elements);
        this.fireSetEvent(3, elements, set, null);
    }

    @Override
    public void clear() {
        this.elementHandlers.clear();
    }

    @Override
    public String createSet(String setID, String setName, IElementHandler elementHandler, BitSet elements) {
        IElementSet set = elementHandler.createSet(setID, setName, elements);
        this.fireSetEvent(0, elements, set, null);
        return set.getID();
    }

    @Override
    public void fireSetEvent(final int eventType, final BitSet elements, final IElementSet cur_set, final IElementSet pre_set) {
        Object[] objectArray = this.setListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final ISetListener setListener = (ISetListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    switch (eventType) {
                        case 0: {
                            setListener.createSetEvent(cur_set, elements);
                            break;
                        }
                        case 1: {
                            setListener.deleteSetEvent(cur_set);
                            break;
                        }
                        case 2: {
                            setListener.changeSetEvent(cur_set, pre_set);
                            break;
                        }
                        case 3: {
                            setListener.addElementsEvent(cur_set, elements);
                            break;
                        }
                        case 4: {
                            setListener.removeElementsEvent(cur_set, elements);
                        }
                    }
                }
            });
            ++n2;
        }
    }

    @Override
    public String getCurrentSetId() {
        return this.cur_set_id;
    }

    @Override
    public IElementHandler getElementHandler(String id) {
        return this.elementHandlers.get(id);
    }

    @Override
    public abstract Image getImage(int var1, boolean var2);

    @Override
    public void removeElementHandler(String id) {
        this.elementHandlers.remove(id);
    }

    @Override
    public void removeFromSet(BitSet elements, String setID, IElementHandler elementHandler) {
        IElementSet set = elementHandler.getSet(setID);
        set.removeElements(elements);
        this.fireSetEvent(4, elements, set, null);
        if (set.size() == 0) {
            this.removeSet(setID, elementHandler);
        }
    }

    @Override
    public void removeSet(String setID, IElementHandler elementHandler) {
        IElementSet set = elementHandler.removeSet(setID);
        this.fireSetEvent(1, null, set, null);
    }

    @Override
    public void setElementHandler(String id, IElementHandler handler) {
        this.elementHandlers.put(id, handler);
    }

    @Override
    public void shutdown() {
    }
}

