/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.dialogs.ClassField;
import org.eclipse.reddeer.jface.window.AbstractWindow;
import org.eclipse.reddeer.jface.window.Openable;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.combo.LabeledCombo;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.workbench.workbenchmenu.WorkbenchMenuOpenable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.hamcrest.Matcher;

public class GenerateHashCodeEqualsDialog
extends AbstractWindow {
    public static final String[] MENU = new String[]{"Source", "Generate hashCode() and equals()..."};
    public static final String DIALOG_TEXT = "Generate hashCode() and equals()";

    public void open(boolean viaShellMenu) {
        if (viaShellMenu) {
            new ShellMenuItem(MENU).select();
        } else {
            new ContextMenuItem(MENU).select();
        }
        this.setShell((Shell)new DefaultShell(DIALOG_TEXT));
    }

    public List<ClassField> getFields() {
        ArrayList<ClassField> fields = new ArrayList<ClassField>();
        for (TreeItem i : new DefaultTree((ReferencedComposite)this.shell).getAllItems()) {
            fields.add(new ClassField(i));
        }
        return fields;
    }

    public List<String> getInsertionPoint() {
        return new LabeledCombo((ReferencedComposite)this.shell, "Insertion points:").getItems();
    }

    public void setInsertionPoint(String insertionPoint) {
        new LabeledCombo((ReferencedComposite)this.shell, "Insertion points:").setSelection(insertionPoint);
    }

    public boolean isGenerateMethodComments() {
        return new CheckBox((ReferencedComposite)this.shell, "Generate method comments").isChecked();
    }

    public boolean isUseInstanceofToCompareTypes() {
        return new CheckBox((ReferencedComposite)this.shell, "Use 'instanceof' to compare types").isChecked();
    }

    public boolean isUseBlocksInIfStatements() {
        return new CheckBox((ReferencedComposite)this.shell, "Use blocks in 'if' statements").isChecked();
    }

    public void toggleGenerateMethodComments(boolean toggle) {
        new CheckBox((ReferencedComposite)this.shell, "Generate method comments").toggle(toggle);
    }

    public void toggleUseInstanceofToCompareTypes(boolean toggle) {
        new CheckBox((ReferencedComposite)this.shell, "Use 'instanceof' to compare types").toggle(toggle);
    }

    public void toggleUseBlocksInIfStatements(boolean toggle) {
        new CheckBox((ReferencedComposite)this.shell, "Use blocks in 'if' statements").toggle(toggle);
    }

    public void selectAll() {
        new PushButton((ReferencedComposite)this.shell, "Select All").click();
    }

    public void deselectAll() {
        new PushButton((ReferencedComposite)this.shell, "Deselect All").click();
    }

    public void ok() {
        WidgetIsFound generateButton = new WidgetIsFound(Button.class, (Control)this.shell.getSWTWidget(), new Matcher[]{new WithMnemonicTextMatcher("Generate")});
        Object button = generateButton.test() ? new PushButton((Button)generateButton.getResult()) : new OkButton((ReferencedComposite)this.shell);
        button.click();
        new WaitWhile((WaitCondition)new ShellIsAvailable(this.shell));
    }

    public void cancel() {
        new PushButton((ReferencedComposite)this.shell, "Cancel").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable(this.shell));
    }

    public Openable getDefaultOpenAction() {
        return new WorkbenchMenuOpenable(DIALOG_TEXT, MENU);
    }
}

