/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.rse.core.AbstractRSESystemType;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.osgi.framework.Bundle;

public class PasswordPersistenceManager {
    private static final String SERVER_URL = "file://rse";
    private static final String AUTH_SCHEME = "";
    public static final int RC_OK = 0;
    public static final int RC_ALREADY_EXISTS = 1;
    public static final int RC_DENIED = 2;
    public static final int RC_ERROR = -1;
    public static final IRSESystemType DEFAULT_SYSTEM_TYPE = new DefaultSystemType();
    public static final String DEFAULT_USER_NAME = "DEFAULT_USER";
    private static PasswordPersistenceManager _instance;
    private String mapLocation = null;
    private RegisteredSystemType[] systemTypes;

    public static final synchronized PasswordPersistenceManager getInstance() {
        if (_instance == null) {
            _instance = new PasswordPersistenceManager();
            _instance.initializeSystemTypes();
        }
        return _instance;
    }

    private static boolean isAuthorizationCompatibilityInstalled() {
        boolean result = false;
        Bundle authorizationBundle = Platform.getBundle((String)"org.eclipse.core.runtime.compatibility.auth");
        if (authorizationBundle == null) {
            Status status = new Status(1, "org.eclipse.rse.core", "Saved passwords are not available for migration to secure storage. Deprecated authorization classes (org.eclipse.core.runtime.compatibility.auth) are not installed.");
            RSECorePlugin.getDefault().getLog().log((IStatus)status);
        } else {
            result = true;
        }
        return result;
    }

    private static boolean isSaveAllowed(IRSESystemType systemType, String hostName) {
        boolean allowed = !RSEPreferencesManager.getDenyPasswordSave(systemType, hostName);
        return allowed;
    }

    private static String getKey(String hostName, String userId) {
        StringBuffer buffer = new StringBuffer(hostName);
        buffer.append("//");
        buffer.append(userId);
        return buffer.toString();
    }

    private static String getHostNameFromKey(String passwordKey) {
        int sepIndex = passwordKey.indexOf("//");
        return passwordKey.substring(0, sepIndex);
    }

    private static String getUserIdFromKey(String passwordKey) {
        int sepIndex = passwordKey.indexOf("//");
        return passwordKey.substring(sepIndex + 2, passwordKey.length());
    }

    private static String[] getMatchingKeys(String[] keys, String hostName, String userId, boolean respectCase, boolean fuzzy) {
        ArrayList<String> selectedKeys = new ArrayList<String>();
        int i = 0;
        while (i < keys.length) {
            String khn;
            String phn;
            boolean match;
            String key = keys[i];
            String keyHostName = PasswordPersistenceManager.getHostNameFromKey(key);
            String keyUserId = PasswordPersistenceManager.getUserIdFromKey(key);
            boolean bl = userId != null && (respectCase ? !userId.equals(keyUserId) : !userId.equalsIgnoreCase(keyUserId)) ? false : (match = true);
            if (match && !(match = hostName.equals(keyHostName)) && fuzzy && !(match = (phn = hostName.toUpperCase(Locale.US)).equals(khn = keyHostName.toUpperCase(Locale.US))) && (phn.startsWith(khn) || khn.startsWith(phn))) {
                khn = RSECorePlugin.getQualifiedHostName(khn);
                phn = RSECorePlugin.getQualifiedHostName(phn);
                match = khn.equalsIgnoreCase(phn);
            }
            if (match) {
                selectedKeys.add(key);
            }
            ++i;
        }
        String[] result = new String[selectedKeys.size()];
        selectedKeys.toArray(result);
        return result;
    }

    private PasswordPersistenceManager() {
        String userName = System.getProperty("user.name");
        if (userName == null) {
            userName = DEFAULT_USER_NAME;
        }
        if (PasswordPersistenceManager.isAuthorizationCompatibilityInstalled()) {
            this.mapLocation = SERVER_URL + userName;
        }
    }

    private void initializeSystemTypes() {
        IRSESystemType[] sysTypes = RSECorePlugin.getTheCoreRegistry().getSystemTypes();
        this.systemTypes = new RegisteredSystemType[sysTypes.length];
        int i = 0;
        while (i < sysTypes.length) {
            this.systemTypes[i] = new RegisteredSystemType(sysTypes[i], true);
            ++i;
        }
    }

    private Map getMap(String systemTypeId) {
        Map passwordMap = null;
        if (this.mapLocation != null) {
            try {
                URL oldServerURL1;
                URL serverURL = new URL(this.mapLocation);
                passwordMap = Platform.getAuthorizationInfo((URL)serverURL, (String)systemTypeId, (String)AUTH_SCHEME);
                if (passwordMap == null && (passwordMap = Platform.getAuthorizationInfo((URL)(oldServerURL1 = new URL(SERVER_URL + ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString())), (String)systemTypeId, (String)AUTH_SCHEME)) == null) {
                    URL oldServerURL2 = new URL(SERVER_URL);
                    passwordMap = Platform.getAuthorizationInfo((URL)oldServerURL2, (String)systemTypeId, (String)AUTH_SCHEME);
                }
            }
            catch (MalformedURLException e) {
                RSECorePlugin.getDefault().getLogger().logError("PasswordPersistenceManager.getMap", e);
            }
        }
        return passwordMap;
    }

    private void migrateMap(ISecurePreferences parentNode, String systemTypeId) {
        ISecurePreferences systemTypeNode = parentNode.node(systemTypeId);
        Map passwordMap = this.getMap(systemTypeId);
        if (passwordMap != null) {
            Set entries = passwordMap.entrySet();
            Iterator z = entries.iterator();
            while (z.hasNext()) {
                Map.Entry entry = z.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.basicPut(systemTypeNode, key, value);
            }
        }
        this.basicSave(systemTypeNode);
    }

    private ISecurePreferences getNode(IRSESystemType systemType) {
        ISecurePreferences systemTypeNode = null;
        String enableSecureStoreAccess = System.getProperty("rse.enableSecureStoreAccess", "true");
        if (enableSecureStoreAccess.equals("true")) {
            String id = systemType.getId();
            ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
            ISecurePreferences rseNode = preferences.node("org.eclipse.rse.core.security");
            if (!rseNode.nodeExists(id)) {
                this.migrateMap(rseNode, id);
            }
            systemTypeNode = rseNode.node(id);
        }
        return systemTypeNode;
    }

    private void basicSave(ISecurePreferences node) {
        try {
            node.flush();
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.rse.core", "Unexpected error saving password.", (Throwable)e);
            RSECorePlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private void basicRemove(ISecurePreferences node, String key) {
        node.remove(key);
    }

    private String basicGet(ISecurePreferences node, String key) {
        String value = null;
        try {
            value = node.get(key, null);
        }
        catch (StorageException e) {
            Status status = new Status(4, "org.eclipse.rse.core", "Unexpected error retrieving password.", (Throwable)e);
            RSECorePlugin.getDefault().getLog().log((IStatus)status);
        }
        return value;
    }

    private void basicPut(ISecurePreferences node, String key, String value) {
        try {
            node.put(key, value, true);
        }
        catch (StorageException e) {
            Status status = new Status(4, "org.eclipse.rse.core", "Unexpected error updating password.", (Throwable)e);
            RSECorePlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private int removePassword(IRSESystemType systemType, String hostName, String userId) {
        int result = 0;
        ISecurePreferences passwords = this.getNode(systemType);
        if (passwords != null) {
            boolean respectCase = this.isUserIDCaseSensitive(systemType);
            String[] keys = PasswordPersistenceManager.getMatchingKeys(passwords.keys(), hostName, userId, respectCase, false);
            if (keys.length == 0) {
                keys = PasswordPersistenceManager.getMatchingKeys(passwords.keys(), hostName, userId, respectCase, true);
            }
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                this.basicRemove(passwords, key);
                ++i;
            }
            if (keys.length > 0) {
                this.basicSave(passwords);
            }
            result = keys.length;
        }
        return result;
    }

    private String findPassword(IRSESystemType systemType, String hostName, String userId) {
        String password = null;
        ISecurePreferences passwords = this.getNode(systemType);
        if (passwords != null) {
            boolean respectCase = this.isUserIDCaseSensitive(systemType);
            String[] keys = PasswordPersistenceManager.getMatchingKeys(passwords.keys(), hostName, userId, respectCase, false);
            if (keys.length == 0) {
                keys = PasswordPersistenceManager.getMatchingKeys(passwords.keys(), hostName, userId, respectCase, true);
            }
            if (keys.length > 0) {
                String key = keys[0];
                password = this.basicGet(passwords, key);
            }
        }
        return password;
    }

    private int updatePassword(IRSESystemType systemType, String hostName, String userId, String password) {
        int result = 2;
        ISecurePreferences passwords = this.getNode(systemType);
        if (passwords != null) {
            String key = PasswordPersistenceManager.getKey(hostName, userId);
            this.basicPut(passwords, key, password);
            this.basicSave(passwords);
            result = 0;
        }
        return result;
    }

    public void reset(IRSESystemType systemType) {
        ISecurePreferences systemTypeNode = this.getNode(systemType);
        if (systemTypeNode != null) {
            systemTypeNode.removeNode();
        }
    }

    public int add(SystemSignonInformation info, boolean overwrite) {
        return this.add(info, overwrite, false);
    }

    public int add(SystemSignonInformation info, boolean overwrite, boolean updateDefault) {
        int result = 0;
        IRSESystemType systemType = info.getSystemType();
        String hostName = info.getHostname();
        String userId = info.getUserId();
        String newPassword = info.getPassword();
        if (PasswordPersistenceManager.isSaveAllowed(systemType, hostName)) {
            String oldPassword;
            if (!this.isUserIDCaseSensitive(systemType)) {
                userId = userId.toUpperCase();
                info.setUserId(userId);
            }
            if (updateDefault && systemType != DEFAULT_SYSTEM_TYPE) {
                SystemSignonInformation newInfo = new SystemSignonInformation(hostName, userId, newPassword, DEFAULT_SYSTEM_TYPE);
                result = this.add(newInfo, overwrite, false);
            }
            if ((oldPassword = this.findPassword(systemType, hostName, userId)) == null || overwrite && !newPassword.equals(oldPassword)) {
                result = this.updatePassword(systemType, hostName, userId, newPassword);
            } else if (oldPassword != null) {
                result = 1;
            }
        } else {
            result = 2;
        }
        return result;
    }

    public boolean passwordExists(IRSESystemType systemType, String hostName, String userId) {
        return this.passwordExists(systemType, hostName, userId, true);
    }

    public boolean passwordExists(IRSESystemType systemType, String hostName, String userId, boolean checkDefault) {
        SystemSignonInformation info = this.find(systemType, hostName, userId, checkDefault);
        return info != null;
    }

    public SystemSignonInformation find(IRSESystemType systemType, String hostName, String userId) {
        return this.find(systemType, hostName, userId, true);
    }

    public SystemSignonInformation find(IRSESystemType systemType, String hostName, String userId, boolean checkDefault) {
        SystemSignonInformation result = null;
        if (systemType != null && hostName != null && userId != null) {
            String password;
            if (!this.isUserIDCaseSensitive(systemType)) {
                userId = userId.toUpperCase();
            }
            if ((password = this.findPassword(systemType, hostName, userId)) != null) {
                result = new SystemSignonInformation(hostName, userId, password, systemType);
            }
            if (result == null && checkDefault && !systemType.equals(DEFAULT_SYSTEM_TYPE) && (password = this.findPassword(DEFAULT_SYSTEM_TYPE, hostName, userId)) != null) {
                result = new SystemSignonInformation(hostName, userId, password, DEFAULT_SYSTEM_TYPE);
            }
        }
        return result;
    }

    public void remove(SystemSignonInformation info) {
        this.remove(info.getSystemType(), info.getHostname(), info.getUserId());
    }

    public int remove(IRSESystemType systemType, String hostName) {
        int result = this.removePassword(systemType, hostName, null);
        return result;
    }

    public void remove(IRSESystemType systemType, String hostName, String userId) {
        if (!this.isUserIDCaseSensitive(systemType)) {
            userId = userId.toUpperCase();
        }
        this.removePassword(systemType, hostName, userId);
    }

    public IRSESystemType[] getRegisteredSystemTypes() {
        IRSESystemType[] types = new IRSESystemType[this.systemTypes.length + 1];
        types[0] = DEFAULT_SYSTEM_TYPE;
        int i = 0;
        while (i < this.systemTypes.length) {
            types[i + 1] = this.systemTypes[i].getSystemType();
            ++i;
        }
        return types;
    }

    public List getSavedUserIDs() {
        ArrayList<SystemSignonInformation> savedUserIDs = new ArrayList<SystemSignonInformation>();
        IRSESystemType[] systemTypes = this.getRegisteredSystemTypes();
        int i = 0;
        while (i < systemTypes.length) {
            IRSESystemType systemType = systemTypes[i];
            ISecurePreferences node = this.getNode(systemType);
            if (node != null) {
                String[] keys = node.keys();
                int j = 0;
                while (j < keys.length) {
                    String key = keys[j];
                    String hostName = PasswordPersistenceManager.getHostNameFromKey(key);
                    String userId = PasswordPersistenceManager.getUserIdFromKey(key);
                    SystemSignonInformation info = new SystemSignonInformation(hostName, userId, systemType);
                    savedUserIDs.add(info);
                    ++j;
                }
            }
            ++i;
        }
        return savedUserIDs;
    }

    public boolean isUserIDCaseSensitive(IRSESystemType systemType) {
        boolean result = true;
        int i = 0;
        while (i < this.systemTypes.length) {
            if (this.systemTypes[i].getSystemType().equals(systemType)) {
                result = this.systemTypes[i].isUserIDCaseSensitive();
                break;
            }
            ++i;
        }
        return result;
    }

    private static class DefaultSystemType
    extends AbstractRSESystemType
    implements IRSESystemType {
        private static final String DEFAULT_ID = "DEFAULT";

        private DefaultSystemType() {
            super(DEFAULT_ID, DEFAULT_ID, RSECoreMessages.DefaultSystemType_Label, null, null);
        }

        public String getId() {
            return DEFAULT_ID;
        }

        public String[] getSubsystemConfigurationIds() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class RegisteredSystemType {
        private IRSESystemType _systemType;
        private boolean _userIDCaseSensitive;

        protected RegisteredSystemType(IRSESystemType systemType, boolean caseSensitive) {
            this._systemType = systemType;
            this._userIDCaseSensitive = caseSensitive;
        }

        public IRSESystemType getSystemType() {
            return this._systemType;
        }

        public boolean isUserIDCaseSensitive() {
            return this._userIDCaseSensitive;
        }
    }
}

