/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;

public class SerializingProvider
implements IRSEPersistenceProvider {
    public String[] getSavedProfileNames() {
        Vector<String> names = new Vector<String>(10);
        try {
            IProject project = SystemResourceManager.getRemoteSystemsProject(false);
            if (project.isAccessible()) {
                IResource[] candidates = project.members();
                int i = 0;
                while (i < candidates.length) {
                    IResource child;
                    IFolder candidateFolder;
                    IResource[] children;
                    IResource candidate = candidates[i];
                    if (candidate.getType() == 2 && (children = (candidateFolder = (IFolder)candidate).members()).length == 1 && (child = children[0]).getType() == 1) {
                        String profileName = candidateFolder.getName();
                        String domFileName = String.valueOf(profileName) + ".rsedom";
                        String childName = child.getName();
                        if (childName.equals(domFileName)) {
                            names.add(profileName);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.rse.core", 1, "Unexpected CoreException", (Throwable)e);
            ILog log = RSECorePlugin.getDefault().getLog();
            log.log((IStatus)status);
        }
        String[] result = new String[names.size()];
        names.toArray(result);
        return result;
    }

    public RSEDOM loadRSEDOM(String profileName, IProgressMonitor monitor) {
        RSEDOM dom = null;
        IFile profileFile = this.getProfileFile(profileName, monitor);
        if (profileFile.exists()) {
            try {
                InputStream iStream = profileFile.getContents();
                ObjectInputStream inStream = new ObjectInputStream(iStream);
                dom = (RSEDOM)inStream.readObject();
                inStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    profileFile.delete(true, false, monitor);
                }
                catch (Exception e2) {
                    e.printStackTrace();
                }
            }
        }
        return dom;
    }

    private IFile getProfileFile(String domName, IProgressMonitor monitor) {
        IProject project = SystemResourceManager.getRemoteSystemsProject(true);
        try {
            project.refreshLocal(2, monitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IFolder folder = project.getFolder(domName);
        if (!folder.exists()) {
            try {
                folder.create(true, true, monitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return folder.getFile(String.valueOf(domName) + ".rsedom");
    }

    public boolean saveRSEDOM(RSEDOM dom, IProgressMonitor monitor) {
        IFile profileFile = this.getProfileFile(dom.getName(), monitor);
        File osFile = profileFile.getLocation().toFile();
        try {
            FileOutputStream oStream = new FileOutputStream(osFile);
            ObjectOutputStream outStream = new ObjectOutputStream(oStream);
            outStream.writeObject(dom);
            outStream.close();
            profileFile.getParent().refreshLocal(1, monitor);
            dom.markUpdated();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Job getSaveJob(RSEDOM dom) {
        return null;
    }

    public IStatus deleteProfile(String profileName, IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        IFile profileFile = this.getProfileFile(profileName, monitor);
        if (profileFile.exists()) {
            try {
                profileFile.delete(3, monitor);
            }
            catch (CoreException e) {
                result = new Status(4, null, 1, RSECoreMessages.SerializingProvider_UnexpectedException, (Throwable)e);
            }
        }
        return result;
    }

    public boolean supportsMigration() {
        return false;
    }

    public IStatus setMigrationMark(String profileName, boolean migrated) {
        return new Status(4, "org.eclipse.rse.core", 102, "Profile migration is not supported by the serializing provider.", null);
    }

    public String[] getMigratedProfileNames() {
        return new String[0];
    }

    public void setProperties(Properties properties) {
    }
}

