/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.classid;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.sdk.core.importcollector.IImportCollector;
import org.eclipse.scout.sdk.core.importcollector.ImportCollector;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.importvalidator.ImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.model.ScoutAnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.CompilationUnitScopedImportCollector;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerationContext;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerators;
import org.eclipse.scout.sdk.s2e.operation.AnnotationNewOperation;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.ImportsCreateOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class MissingClassIdsNewOperation
implements IOperation {
    private Set<IResource> m_selection;

    @Override
    public String getOperationName() {
        return "Create missing @ClassId annotations";
    }

    @Override
    public void validate() {
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            Collection<IType> candidates = this.findCandidates(progress.newChild(8));
            if (candidates.isEmpty()) {
                return;
            }
            this.processCandidates(candidates, progress.newChild(2), workingCopyManager);
        }
        catch (OperationCanceledException e) {
            SdkLog.debug((String)"Creation of missing @ClassId annotations has been cancelled.", (Object[])new Object[]{e});
        }
    }

    protected ITypeHierarchy createHierarchy(IType iTypeWithClassId, SubMonitor monitor) throws CoreException {
        if (this.useRegion()) {
            return this.createRegionHierarchy(monitor);
        }
        return iTypeWithClassId.newTypeHierarchy((IProgressMonitor)monitor);
    }

    protected boolean useRegion() {
        Set<IResource> selection = this.selection();
        if (selection.isEmpty() || selection.size() > 100) {
            return false;
        }
        for (IResource r : selection) {
            if (r.getType() == 1) continue;
            return false;
        }
        return true;
    }

    protected ITypeHierarchy createRegionHierarchy(SubMonitor monitor) throws JavaModelException {
        IRegion region = JavaCore.newRegion();
        for (IResource r : this.selection()) {
            IJavaElement element;
            if (r == null || !r.isAccessible() || !S2eUtils.exists(element = JavaCore.create((IResource)r))) continue;
            region.add(element);
        }
        return JavaCore.newTypeHierarchy((IRegion)region, null, (IProgressMonitor)monitor);
    }

    protected Collection<IType> findCandidates(SubMonitor monitor) throws CoreException {
        HashSet<IType> result = new HashSet<IType>();
        Set<IType> startTypes = S2eUtils.resolveJdtTypes("org.eclipse.scout.rt.platform.classid.ITypeWithClassId");
        monitor.setWorkRemaining(startTypes.size());
        monitor.setTaskName("Search for classes...");
        if (startTypes.isEmpty()) {
            return Collections.emptyList();
        }
        for (IType startType : startTypes) {
            ITypeHierarchy hierarchy = this.createHierarchy(startType, monitor.newChild(1));
            if (hierarchy == null || monitor.isCanceled()) {
                return Collections.emptyList();
            }
            IType[] iTypeArray = hierarchy.getAllSubtypes(startType);
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType t = iTypeArray[n2];
                result.add(t);
                ++n2;
            }
            if (!monitor.isCanceled()) continue;
            return Collections.emptyList();
        }
        return result;
    }

    protected boolean acceptType(IType candidate) {
        IResource resource = candidate.getResource();
        if (resource == null || !resource.isAccessible()) {
            return false;
        }
        if (this.selection().isEmpty()) {
            return true;
        }
        return this.isInResources(resource);
    }

    protected boolean isInResources(IResource candidate) {
        IPath location = candidate.getLocation();
        for (IResource r : this.selection()) {
            if (!r.getLocation().isPrefixOf(location)) continue;
            return true;
        }
        return false;
    }

    protected void processCandidates(Collection<IType> candidates, SubMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor subMonitor = monitor.newChild(2);
        subMonitor.setWorkRemaining(candidates.size());
        subMonitor.setTaskName("Search for missing annotations...");
        int numTypes = 0;
        HashMap<ICompilationUnit, HashSet<IType>> typesWithoutClassId = new HashMap<ICompilationUnit, HashSet<IType>>();
        for (IType t : candidates) {
            IAnnotation annotation;
            boolean isValidType;
            boolean bl = isValidType = S2eUtils.exists((IJavaElement)t) && t.isClass() && !t.isBinary() && !t.isAnonymous();
            if (isValidType && this.acceptType(t) && (annotation = S2eUtils.getAnnotation((IAnnotatable)t, "org.eclipse.scout.rt.platform.classid.ClassId")) == null) {
                ICompilationUnit icu = t.getCompilationUnit();
                HashSet<IType> listByIcu = (HashSet<IType>)typesWithoutClassId.get(icu);
                if (listByIcu == null) {
                    listByIcu = new HashSet<IType>();
                    typesWithoutClassId.put(icu, listByIcu);
                }
                if (listByIcu.add(t)) {
                    ++numTypes;
                }
            }
            if (monitor.isCanceled()) {
                return;
            }
            subMonitor.worked(1);
        }
        subMonitor = monitor.newChild(6);
        subMonitor.setWorkRemaining(numTypes);
        subMonitor.setTaskName("Create new annotations...");
        CachingJavaEnvironmentProvider envProvider = new CachingJavaEnvironmentProvider();
        for (Map.Entry e : typesWithoutClassId.entrySet()) {
            MissingClassIdsNewOperation.createClassIdsForIcu((ICompilationUnit)e.getKey(), (Set)e.getValue(), (IProgressMonitor)subMonitor, workingCopyManager, envProvider);
            if (!monitor.isCanceled()) continue;
            return;
        }
    }

    public static void createClassIdsForIcu(ICompilationUnit icu, Set<IType> types, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager, IJavaEnvironmentProvider envProvider) throws CoreException {
        workingCopyManager.register(icu, null);
        IJavaEnvironment environment = envProvider.get(icu.getJavaProject());
        CompilationUnitScopedImportCollector collector = new CompilationUnitScopedImportCollector((IImportCollector)new ImportCollector(environment), S2eUtils.getPackage(icu));
        IBuffer buffer = icu.getBuffer();
        Document sourceDoc = new Document(buffer.getContents());
        MultiTextEdit multiEdit = new MultiTextEdit();
        ImportValidator validator = new ImportValidator((IImportCollector)collector);
        String nl = icu.findRecommendedLineSeparator();
        for (IType t : types) {
            String newClassId = ClassIdGenerators.generateNewId(new ClassIdGenerationContext(t));
            AnnotationNewOperation op = new AnnotationNewOperation(ScoutAnnotationSourceBuilderFactory.createClassId((String)newClassId), (IMember)t);
            TextEdit edit = op.createEdit((IImportValidator)validator, sourceDoc, nl);
            multiEdit.addChild(edit);
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            return;
        }
        try {
            multiEdit.apply((IDocument)sourceDoc);
            buffer.setContents(sourceDoc.get());
            new ImportsCreateOperation(icu, (IImportCollector)collector).run((IProgressMonitor)new NullProgressMonitor(), workingCopyManager);
        }
        catch (BadLocationException e) {
            SdkLog.warning((String)"Could not update @ClassId annotations for compilation unit '{}'.", (Object[])new Object[]{icu.getElementName(), e});
        }
    }

    public Set<IResource> selection() {
        if (this.m_selection == null) {
            return Collections.emptySet();
        }
        return this.m_selection;
    }

    public MissingClassIdsNewOperation withSelection(Set<IResource> selection) {
        this.m_selection = selection;
        return this;
    }
}

