/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.util;

import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public enum ScoutTier implements Predicate<IJavaElement>
{
    Client,
    Shared,
    Server,
    HtmlUi;


    @Override
    public boolean test(IJavaElement element) {
        return this.isIncludedIn(ScoutTier.valueOfInternal(element));
    }

    public boolean isIncludedIn(ScoutTier tierOfOtherElement) {
        if (tierOfOtherElement == null) {
            return false;
        }
        if (Shared.equals(this)) {
            return true;
        }
        if (Client.equals(this)) {
            return Client.equals(tierOfOtherElement) || HtmlUi.equals(tierOfOtherElement);
        }
        return this.equals(tierOfOtherElement);
    }

    private static ScoutTier valueOfInternal(IJavaElement element) {
        try {
            return ScoutTier.valueOf(element);
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public String tierName() {
        switch (this) {
            case Client: {
                return "client";
            }
            case Shared: {
                return "shared";
            }
            case HtmlUi: {
                return "ui.html";
            }
        }
        return "server";
    }

    public String convert(ScoutTier to, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        return StringUtils.replace((String)name, (String)(String.valueOf('.') + this.tierName()), (String)(String.valueOf('.') + to.tierName()));
    }

    public IJavaProject convert(ScoutTier to, IJavaProject origin) throws JavaModelException {
        if (!S2eUtils.exists((IJavaElement)origin)) {
            return null;
        }
        String originJavaProjectName = origin.getJavaProject().getElementName();
        IJavaProject project = origin.getJavaModel().getJavaProject(this.convert(to, originJavaProjectName));
        if (S2eUtils.exists((IJavaElement)project) && to.equals(ScoutTier.valueOf((IJavaElement)project))) {
            return project;
        }
        return null;
    }

    public IPackageFragment convert(ScoutTier to, IPackageFragment origin) throws JavaModelException {
        if (!S2eUtils.exists((IJavaElement)origin)) {
            return null;
        }
        IPackageFragmentRoot targetSrcFolder = this.convert(to, (IPackageFragmentRoot)origin.getAncestor(3));
        if (targetSrcFolder == null) {
            return null;
        }
        String name = this.convert(to, origin.getElementName());
        IPackageFragment packageFragment = targetSrcFolder.getPackageFragment(name);
        if (!S2eUtils.exists((IJavaElement)packageFragment)) {
            return null;
        }
        return packageFragment;
    }

    public IPackageFragmentRoot convert(ScoutTier to, IPackageFragmentRoot origin) throws JavaModelException {
        IJavaElement element;
        if (!S2eUtils.exists((IJavaElement)origin)) {
            return null;
        }
        IJavaProject targetProject = this.convert(to, origin.getJavaProject());
        if (targetProject == null) {
            return null;
        }
        String projectRelResourcePath = origin.getPath().removeFirstSegments(1).toString();
        IFolder folder = targetProject.getProject().getFolder(projectRelResourcePath);
        if (folder != null && folder.exists() && S2eUtils.exists(element = JavaCore.create((IFolder)folder)) && element.getElementType() == 3) {
            return (IPackageFragmentRoot)element;
        }
        try {
            return S2eUtils.getPrimarySourceFolder(targetProject);
        }
        catch (JavaModelException e) {
            SdkLog.info((String)"Unable to calculate default source folder.", (Object[])new Object[]{e});
            return null;
        }
    }

    public static ScoutTier valueOf(String string) {
        return Enum.valueOf(ScoutTier.class, string);
    }
}

