/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.viewer.dnd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.core.cdt.elf.ElfUtils;
import org.eclipse.tcf.te.launch.core.bindings.LaunchConfigTypeBindingsManager;
import org.eclipse.tcf.te.launch.core.lm.LaunchConfigHelper;
import org.eclipse.tcf.te.launch.core.lm.LaunchManager;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchSpecification;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.selection.LaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.ProjectSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.RemoteSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ILaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.eclipse.tcf.te.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.launch.ui.model.LaunchModel;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.tcf.te.launch.ui.nls.Messages;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.ui.jface.dialogs.OptionalMessageDialog;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.IRoot;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.navigator.CommonDropAdapter;

public class CommonDnD {
    public boolean isDraggable(IStructuredSelection selection) {
        Object[] objects;
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object[] objectArray = objects = selection.toArray();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (!this.isDraggableObject(this.translateObject(object))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private Object translateObject(Object object) {
        IPath location;
        if (object == null || object instanceof LaunchNode || object instanceof IModelNode || object instanceof ICategory) {
            return object;
        }
        IResource resource = (IResource)Platform.getAdapterManager().loadAdapter(object, IResource.class.getName());
        if (resource != null && (location = resource.getLocation()) != null) {
            try {
                int elfType = ElfUtils.getELFType((File)location.toFile());
                if (elfType == 1 || elfType == 3) {
                    return resource;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private boolean isDraggableObject(Object object) {
        return object instanceof LaunchNode && ((LaunchNode)((Object)object)).getLaunchConfiguration() != null || !(object instanceof LaunchNode) && object instanceof IModelNode || object instanceof IResource;
    }

    public boolean isValidDnD(CommonDropAdapter dropAdapter, Object target, int operation, TransferData transferType) {
        boolean valid = false;
        int overrideOperation = -1;
        IStructuredSelection selection = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
            selection = (IStructuredSelection)transfer.getSelection();
        }
        if (selection == null) {
            return false;
        }
        boolean allow = true;
        target = this.translateObject(target);
        Iterator iterator = selection.iterator();
        boolean isCopy = (operation & 1) != 0;
        while (iterator.hasNext() && allow) {
            LaunchNode toNode;
            IModelNode toContext;
            Object from = this.translateObject(iterator.next());
            if (from instanceof LaunchNode) {
                LaunchNode fromNode = (LaunchNode)((Object)from);
                if (target instanceof LaunchNode) {
                    allow = false;
                    continue;
                }
                if (target instanceof IModelNode) {
                    toContext = (IModelNode)target;
                    allow &= this.internalValidate(fromNode, null, toContext, true, isCopy);
                    continue;
                }
                if (target instanceof IResource) {
                    IResource toResource = (IResource)target;
                    allow &= this.internalValidate(fromNode, toResource, null, true, isCopy);
                    continue;
                }
                if (target instanceof ICategory) {
                    ICategory toCategory = (ICategory)target;
                    overrideOperation = 4;
                    allow &= fromNode.getLaunchConfiguration() != null && "org.eclipse.tcf.te.ui.views.category.favorites".equals(toCategory.getId()) && !Managers.getCategoryManager().belongsTo(toCategory.getId(), LaunchModel.getCategoryId(fromNode.getLaunchConfiguration()));
                    continue;
                }
                if (target instanceof IRoot) {
                    allow &= fromNode.getModel().getModelRoot() instanceof ICategory && fromNode.getLaunchConfiguration() != null && Managers.getCategoryManager().belongsTo(((ICategory)fromNode.getModel().getModelRoot()).getId(), LaunchModel.getCategoryId(fromNode.getLaunchConfiguration()));
                    continue;
                }
                allow = false;
                continue;
            }
            if (from instanceof IModelNode) {
                IModelNode fromContext = (IModelNode)from;
                if (target instanceof LaunchNode) {
                    toNode = (LaunchNode)((Object)target);
                    overrideOperation = 2;
                    allow &= this.internalValidate(toNode, null, fromContext, true, false);
                    continue;
                }
                allow = false;
                continue;
            }
            if (from instanceof IResource) {
                IResource fromResource = (IResource)from;
                if (target instanceof LaunchNode) {
                    toNode = (LaunchNode)((Object)target);
                    allow &= this.internalValidate(toNode, fromResource, null, !isCopy, false);
                    continue;
                }
                if (target instanceof IModelNode) {
                    toContext = (IModelNode)target;
                    LaunchSelection launchSel = new LaunchSelection(null, new ISelectionContext[]{new RemoteSelectionContext(toContext, new Object[]{toContext}, true), new ProjectSelectionContext(fromResource.getProject(), new Object[]{fromResource.getLocation()}, true)});
                    String[] typeIds = LaunchConfigTypeBindingsManager.getInstance().getValidLaunchConfigTypes((ILaunchSelection)launchSel);
                    allow &= typeIds != null && typeIds.length > 0;
                    continue;
                }
                allow = false;
                continue;
            }
            allow = false;
        }
        valid = allow;
        if (dropAdapter != null && valid && overrideOperation > -1) {
            dropAdapter.overrideOperation(overrideOperation);
        }
        return valid;
    }

    private boolean internalValidate(LaunchNode node, IResource resource, IModelNode context, boolean replaceData, boolean duplicateConfig) {
        if (node.getLaunchConfiguration() == null) {
            return false;
        }
        if (resource != null && !LaunchConfigTypeBindingsManager.getInstance().isValidLaunchConfigType(node.getLaunchConfigurationType().getIdentifier(), (ILaunchSelection)new LaunchSelection(null, (ISelectionContext)new ProjectSelectionContext(resource.getProject(), new Object[]{resource.getLocation()}, true)))) {
            return false;
        }
        if (context != null) {
            if (!LaunchConfigTypeBindingsManager.getInstance().isValidLaunchConfigType(node.getLaunchConfigurationType().getIdentifier(), (ILaunchSelection)new LaunchSelection(null, (ISelectionContext)new RemoteSelectionContext(context, true)))) {
                return false;
            }
            IModelNode[] oldContexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchConfiguration)node.getLaunchConfiguration());
            if (oldContexts != null && Arrays.asList(oldContexts).contains(context) && !duplicateConfig) {
                return false;
            }
        }
        return true;
    }

    public boolean doDnD(CommonDropAdapter dropAdapter, Object target, int operation, IStructuredSelection selection) {
        boolean success = true;
        target = this.translateObject(target);
        Iterator iterator = selection.iterator();
        boolean isCopy = (operation & 1) != 0;
        while (iterator.hasNext()) {
            LaunchNode toNode;
            IModelNode toContext;
            Object from = this.translateObject(iterator.next());
            if (from instanceof LaunchNode) {
                LaunchNode fromNode = (LaunchNode)((Object)from);
                if (target instanceof LaunchNode) {
                    success = false;
                    continue;
                }
                if (target instanceof IModelNode) {
                    toContext = (IModelNode)target;
                    success &= this.internalDrop(fromNode, null, toContext, true, isCopy);
                    continue;
                }
                if (target instanceof IResource) {
                    IResource toResource = (IResource)target;
                    success &= this.internalDrop(fromNode, toResource, null, true, isCopy);
                    continue;
                }
                if (target instanceof ICategory) {
                    ICategory toCategory = (ICategory)target;
                    success &= Managers.getCategoryManager().add(toCategory.getId(), LaunchModel.getCategoryId(fromNode.getLaunchConfiguration()));
                    continue;
                }
                if (target instanceof IRoot) {
                    success &= Managers.getCategoryManager().remove(((ICategory)fromNode.getModel().getModelRoot()).getId(), LaunchModel.getCategoryId(fromNode.getLaunchConfiguration()));
                    continue;
                }
                success = false;
                continue;
            }
            if (from instanceof IModelNode) {
                IModelNode fromContext = (IModelNode)from;
                if (target instanceof LaunchNode) {
                    toNode = (LaunchNode)((Object)target);
                    success &= this.internalDrop(toNode, null, fromContext, true, false);
                    continue;
                }
                success = false;
                continue;
            }
            if (from instanceof IResource) {
                IResource fromResource = (IResource)from;
                if (target instanceof LaunchNode) {
                    toNode = (LaunchNode)((Object)target);
                    success &= this.internalDrop(toNode, fromResource, null, !isCopy, false);
                    continue;
                }
                if (target instanceof IModelNode) {
                    ILaunchConfigurationType type;
                    String[] modes;
                    toContext = (IModelNode)target;
                    LaunchSelection launchSel = new LaunchSelection(null, new ISelectionContext[]{new RemoteSelectionContext(toContext, new Object[]{toContext}, true), new ProjectSelectionContext(fromResource.getProject(), new Object[]{fromResource.getLocation()}, true)});
                    String[] typeIds = LaunchConfigTypeBindingsManager.getInstance().getValidLaunchConfigTypes((ILaunchSelection)launchSel);
                    if (typeIds == null || typeIds.length <= 0) continue;
                    String typeId = null;
                    typeId = typeIds.length == 1 ? typeIds[0] : this.askForLaunchType(typeIds);
                    if (typeId == null || (modes = LaunchConfigHelper.getLaunchConfigTypeModes((ILaunchConfigurationType)(type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(typeId)), (boolean)false)) == null || modes.length <= 0) continue;
                    String mode = null;
                    mode = modes.length == 1 ? modes[0] : this.askForLaunchMode(type, modes);
                    if (mode == null) continue;
                    success &= this.openLaunchConfigDialog(type, mode, (ILaunchSelection)new LaunchSelection(mode, launchSel.getSelectedContexts()));
                    continue;
                }
                success = false;
                continue;
            }
            success = false;
        }
        ViewsUtil.refresh((String)"org.eclipse.tcf.te.ui.views.View");
        return success;
    }

    private String askForLaunchType(String[] typeIds) {
        ArrayList<ILaunchConfigurationType> types = new ArrayList<ILaunchConfigurationType>();
        String[] stringArray = typeIds;
        int n = typeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String typeId = stringArray[n2];
            types.add(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(typeId));
            ++n2;
        }
        ListDialog dialog = new ListDialog(UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setTitle(Messages.CommonDnD_launchType_dialog_title);
        dialog.setMessage(Messages.CommonDnD_launchType_dialog_message);
        dialog.setInput((Object)types.toArray());
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ILaunchConfigurationType)element).getName();
            }
        });
        dialog.setInitialSelections(new Object[]{types.get(0)});
        if (dialog.open() == 0) {
            return ((ILaunchConfigurationType)dialog.getResult()[0]).getIdentifier();
        }
        return null;
    }

    private String askForLaunchMode(ILaunchConfigurationType type, String[] modes) {
        ArrayList<String> modeLabels = new ArrayList<String>();
        int defaultIndex = 0;
        String[] stringArray = modes;
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            String mode = stringArray[n2];
            ILaunchMode launchMode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(mode);
            modeLabels.add(launchMode.getLabel());
            if (mode.equals("debug")) {
                defaultIndex = modeLabels.size() - 1;
            }
            ++n2;
        }
        if (modeLabels.size() > 0) {
            modeLabels.add(IDialogConstants.CANCEL_LABEL);
            OptionalMessageDialog dialog = new OptionalMessageDialog(UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.CommonDnD_launchMode_dialog_title, null, NLS.bind((String)Messages.CommonDnD_launchMode_dialog_message, (Object)type.getName()), 3, modeLabels.toArray(new String[modeLabels.size()]), defaultIndex, null, null);
            int result = dialog.open();
            if (result >= 256) {
                return modes[result - 256];
            }
        }
        return null;
    }

    private boolean openLaunchConfigDialog(ILaunchConfigurationType type, String mode, ILaunchSelection launchSel) {
        try {
            ILaunchSpecification launchSpec;
            ILaunchManagerDelegate delegate = LaunchManager.getInstance().getLaunchManagerDelegate(type, mode);
            if (delegate != null && (launchSpec = delegate.getLaunchSpecification(type.getIdentifier(), launchSel)) != null) {
                ILaunchConfiguration[] launchConfigs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
                ILaunchConfiguration config = (launchConfigs = delegate.getMatchingLaunchConfigurations(launchSpec, launchConfigs)) != null && launchConfigs.length > 0 ? launchConfigs[0] : null;
                config = LaunchManager.getInstance().createOrUpdateLaunchConfiguration(config, launchSpec);
                ILaunchGroup launchGroup = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)mode);
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)new StructuredSelection((Object)config), (String)launchGroup.getIdentifier());
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private boolean internalDrop(LaunchNode node, IResource resource, IModelNode context, boolean replaceData, boolean duplicateConfig) {
        try {
            ILaunchManagerDelegate delegate = LaunchManager.getInstance().getLaunchManagerDelegate(node.getLaunchConfigurationType(), "");
            ILaunchConfigurationWorkingCopy wc = node.getLaunchConfiguration().getWorkingCopy();
            if (resource != null) {
                delegate.updateLaunchConfig(wc, (ISelectionContext)new ProjectSelectionContext(resource.getProject(), new Object[]{resource.getLocation()}, true), replaceData);
            }
            if (context != null) {
                delegate.updateLaunchConfig(wc, (ISelectionContext)new RemoteSelectionContext(context, new Object[]{context}, true), replaceData);
            }
            if (duplicateConfig) {
                wc = wc.copy(LaunchConfigHelper.getUniqueLaunchConfigName((String)delegate.getDefaultLaunchName((ILaunchConfiguration)wc)));
            } else {
                String oldName;
                String newName = LaunchConfigHelper.getUniqueLaunchConfigName((String)delegate.getDefaultLaunchName((ILaunchConfiguration)wc)).replaceAll("\\([0-9]+\\)$", "").trim();
                if (!newName.equals(oldName = wc.getName().replaceAll("\\([0-9]+\\)$", "").trim())) {
                    wc.rename(LaunchConfigHelper.getUniqueLaunchConfigName((String)newName));
                }
            }
            wc.doSave();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

