/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.search;

import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.search.FSGeneralSearchable;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.search.FSModifiedSearchable;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.search.FSSizeSearchable;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.ui.interfaces.ISearchable;
import org.eclipse.tcf.te.ui.utils.CompositeSearchable;

public class FSTreeNodeSearchable
extends CompositeSearchable {
    public FSTreeNodeSearchable(IFSTreeNode node) {
        this.setSearchables(new ISearchable[]{new FSGeneralSearchable(node), new FSModifiedSearchable(), new FSSizeSearchable()});
    }

    public String getSearchTitle(Object rootElement) {
        return Messages.FSTreeNodeSearchable_FindFilesAndFolders;
    }

    public String getSearchMessage(Object rootElement) {
        String message = Messages.FSTreeNodeSearchable_FindMessage;
        IFSTreeNode rootNode = (IFSTreeNode)rootElement;
        String rootName = this.getElementName(rootElement);
        if (rootNode != null && !rootNode.isFileSystem()) {
            rootName = "\"" + rootName + "\"";
        }
        message = NLS.bind((String)message, (Object)rootName);
        return message;
    }

    private String getElementName(Object rootElement) {
        if (rootElement == null) {
            return Messages.FSTreeNodeSearchable_SelectedFileSystem;
        }
        IFSTreeNode rootNode = (IFSTreeNode)rootElement;
        if (rootNode.isFileSystem()) {
            return Messages.FSTreeNodeSearchable_SelectedFileSystem;
        }
        return rootNode.getName();
    }

    public String getElementText(Object element) {
        return this.getElementName(element);
    }

    public String getCustomMessage(Object rootElement, String key) {
        return null;
    }
}

