/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutToRemoteFolderOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ShareProjectOperation;

public class ReconcileProjectOperation
extends ShareProjectOperation {
    private ICVSRemoteFolder folder;
    private SyncInfoFilter.ContentComparisonSyncInfoFilter contentCompare = new SyncInfoFilter.ContentComparisonSyncInfoFilter(false);

    public ReconcileProjectOperation(Shell shell, IProject project, ICVSRemoteFolder folder) {
        super(shell, folder.getRepository(), project, folder.getRepositoryRelativePath());
        this.folder = folder;
    }

    @Override
    protected String getTaskName() {
        return NLS.bind((String)CVSUIMessages.ReconcileProjectOperation_0, (Object[])new String[]{this.getProject().getName(), this.folder.getRepositoryRelativePath()});
    }

    @Override
    protected ICVSRemoteFolder createRemoteFolder(IProgressMonitor monitor) throws CVSException {
        return this.folder;
    }

    @Override
    protected void mapProjectToRemoteFolder(ICVSRemoteFolder remote, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, 100);
        super.mapProjectToRemoteFolder(remote, Policy.subMonitorFor(monitor, 10));
        this.reconcileSyncInfo(Policy.subMonitorFor(monitor, 90));
        monitor.done();
    }

    protected void reconcileSyncInfo(IProgressMonitor monitor) throws CVSException {
        try {
            try {
                monitor.beginTask(null, 100);
                ICVSRemoteFolder remote = CheckoutToRemoteFolderOperation.checkoutRemoteFolder(this.getPart(), this.folder, Policy.subMonitorFor(monitor, 80));
                this.populateWorkspace(remote, Policy.subMonitorFor(monitor, 20));
            }
            catch (InvocationTargetException e) {
                throw CVSException.wrapException((Exception)e);
            }
            catch (TeamException e) {
                throw CVSException.wrapException((CoreException)((Object)e));
            }
            catch (InterruptedException interruptedException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void populateWorkspace(ICVSRemoteFolder remote, IProgressMonitor monitor) throws CVSException {
        CVSWorkspaceRoot.getCVSFolderFor((IContainer)this.getProject()).run(monitor1 -> this.populateWorkspace((IResource)this.getProject(), (ICVSRemoteResource)remote, monitor1), monitor);
    }

    void populateWorkspace(IResource resource, ICVSRemoteResource remote, IProgressMonitor monitor) throws CVSException {
        try {
            if (resource.getType() == 1) {
                if (remote.isContainer()) {
                    CVSUIPlugin.log(4, NLS.bind((String)CVSUIMessages.ReconcileProjectOperation_1, (Object[])new String[]{resource.getFullPath().toString(), remote.getRepositoryRelativePath()}), null);
                } else {
                    IFile file = (IFile)resource;
                    IResourceVariant variant = (IResourceVariant)remote;
                    if (file.exists() && variant != null && this.contentCompare.compareContents(file, variant, monitor)) {
                        this.makeInSync(file, remote, monitor);
                    }
                }
            } else if (!remote.isContainer()) {
                CVSUIPlugin.log(4, NLS.bind((String)CVSUIMessages.ReconcileProjectOperation_2, (Object[])new String[]{resource.getFullPath().toString(), remote.getRepositoryRelativePath()}), null);
            } else {
                ICVSRemoteResource[] members;
                ICVSFolder folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                folder.setFolderSyncInfo(((ICVSFolder)remote).getFolderSyncInfo());
                ICVSRemoteResource[] iCVSRemoteResourceArray = members = remote.members(monitor);
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    ICVSRemoteResource member = iCVSRemoteResourceArray[n2];
                    this.populateWorkspace(this.getLocalChild((IContainer)resource, member), member, monitor);
                    ++n2;
                }
            }
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
    }

    private IResource getLocalChild(IContainer parent, ICVSRemoteResource member) {
        Object resource = parent.findMember(member.getName());
        if (resource == null) {
            resource = member.isContainer() ? parent.getFolder((IPath)new Path(null, member.getName())) : parent.getFile((IPath)new Path(null, member.getName()));
        }
        return resource;
    }

    private void makeInSync(IFile file, ICVSRemoteResource remote, IProgressMonitor monitor) throws CVSException {
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
        ResourceSyncInfo info = remote.getSyncInfo();
        Date modTime = info.getTimeStamp();
        if (modTime != null) {
            cvsFile.setTimeStamp(modTime);
        }
        modTime = cvsFile.getTimeStamp();
        MutableResourceSyncInfo newInfoWithTimestamp = info.cloneMutable();
        newInfoWithTimestamp.setTimeStamp(modTime);
        cvsFile.setSyncInfo((ResourceSyncInfo)newInfoWithTimestamp, 1);
    }
}

