/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IConnectionMethod;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.team.internal.ccvs.ui.wizards.ConfigurationWizardMainPage;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.dialogs.DetailsDialogWithProjects;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.PropertyPage;

public class CVSRepositoryPropertiesPage
extends PropertyPage {
    private static final String FAKE_PASSWORD = "*********";
    ICVSRepositoryLocation location;
    Text userText;
    Text passwordText;
    Combo methodType;
    Text hostText;
    Text pathText;
    private Text portText;
    private Button useDefaultPort;
    private Button useCustomPort;
    private Button allowCachingButton;
    private boolean allowCaching = false;
    boolean passwordChanged;
    boolean connectionInfoChanged;
    IUserInfo info;
    private Button useLocationAsLabel;
    private Button useCustomLabel;
    private Text labelText;

    protected Control createContents(Composite parent) {
        this.initialize();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        Composite labelGroup = new Composite(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        labelGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        labelGroup.setLayout((Layout)layout);
        Listener labelListener = event -> this.updateWidgetEnablements();
        this.useLocationAsLabel = this.createRadioButton(labelGroup, CVSUIMessages.CVSRepositoryPropertiesPage_useLocationAsLabel, 3);
        this.useCustomLabel = this.createRadioButton(labelGroup, CVSUIMessages.CVSRepositoryPropertiesPage_useCustomLabel, 1);
        this.useCustomLabel.addListener(13, labelListener);
        this.labelText = this.createTextField(labelGroup);
        this.labelText.addListener(24, labelListener);
        this.createLabel(composite, "", 3);
        this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_connectionType, 1);
        this.methodType = this.createCombo(composite);
        this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_user, 1);
        this.userText = this.createTextField(composite);
        this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_password, 1);
        this.passwordText = this.createPasswordField(composite);
        this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_host, 1);
        this.hostText = this.createTextField(composite);
        this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_path, 1);
        this.pathText = this.createTextField(composite);
        Composite portGroup = new Composite(composite, 0);
        data = new GridData();
        data.horizontalSpan = 3;
        portGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        portGroup.setLayout((Layout)layout);
        this.useDefaultPort = this.createRadioButton(portGroup, CVSUIMessages.ConfigurationWizardMainPage_useDefaultPort, 3);
        this.useCustomPort = this.createRadioButton(portGroup, CVSUIMessages.ConfigurationWizardMainPage_usePort, 1);
        this.portText = this.createTextField(portGroup);
        this.createLabel(composite, "", 3);
        this.allowCachingButton = new Button(composite, 32);
        this.allowCachingButton.setText(CVSUIMessages.UserValidationDialog_6);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.allowCachingButton.setLayoutData((Object)data);
        this.allowCachingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSRepositoryPropertiesPage.this.allowCaching = CVSRepositoryPropertiesPage.this.allowCachingButton.getSelection();
            }
        });
        Link link = SWTUtils.createPreferenceLink((Shell)this.getShell(), (Composite)composite, (String)CVSUIMessages.ConfigurationWizardMainPage_9, (String)CVSUIMessages.ConfigurationWizardMainPage_10);
        link.setLayoutData((Object)data);
        this.createLabel(composite, "", 3);
        this.initializeValues();
        this.updateWidgetEnablements();
        Listener connectionInfoChangedListener = event -> {
            this.connectionInfoChanged = true;
            this.updateWidgetEnablements();
        };
        this.passwordText.addListener(24, event -> {
            boolean bl = this.passwordChanged = !this.passwordText.getText().equals(FAKE_PASSWORD);
        });
        this.userText.addListener(24, connectionInfoChangedListener);
        this.methodType.addListener(24, connectionInfoChangedListener);
        this.hostText.addListener(24, connectionInfoChangedListener);
        this.portText.addListener(24, connectionInfoChangedListener);
        this.useCustomPort.addListener(13, connectionInfoChangedListener);
        this.pathText.addListener(24, connectionInfoChangedListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.repository_location_property_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 2;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        return this.layoutTextField(text);
    }

    protected Text createPasswordField(Composite parent) {
        Text text = new Text(parent, 0x400804);
        return this.layoutTextField(text);
    }

    protected Text layoutTextField(Text text) {
        GridData data = new GridData(768);
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        data.widthHint = 200;
        data.horizontalSpan = 2;
        text.setLayoutData((Object)data);
        return text;
    }

    protected Button createRadioButton(Composite parent, String label, int span) {
        Button button = new Button(parent, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    private void initialize() {
        this.location = null;
        IAdaptable element = this.getElement();
        if (element instanceof ICVSRepositoryLocation) {
            this.location = (ICVSRepositoryLocation)element;
        } else {
            Object adapter = element.getAdapter(ICVSRepositoryLocation.class);
            if (adapter instanceof ICVSRepositoryLocation) {
                this.location = (ICVSRepositoryLocation)adapter;
            }
        }
    }

    private void initializeValues() {
        Object method;
        IConnectionMethod[] methods;
        this.passwordChanged = false;
        this.connectionInfoChanged = false;
        IConnectionMethod[] iConnectionMethodArray = methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            method = iConnectionMethodArray[n2];
            this.methodType.add(method.getName());
            ++n2;
        }
        method = this.location.getMethod().getName();
        this.methodType.select(this.methodType.indexOf((String)method));
        this.info = this.location.getUserInfo(true);
        this.userText.setText(this.info.getUsername());
        this.passwordText.setText(FAKE_PASSWORD);
        this.hostText.setText(this.location.getHost());
        int port = this.location.getPort();
        if (port == 0) {
            this.useDefaultPort.setSelection(true);
            this.useCustomPort.setSelection(false);
            this.portText.setEnabled(false);
        } else {
            this.useDefaultPort.setSelection(false);
            this.useCustomPort.setSelection(true);
            this.portText.setText("" + port);
        }
        this.pathText.setText(this.location.getRootDirectory());
        this.allowCachingButton.setSelection(this.location.getUserInfoCached());
        this.allowCaching = this.allowCachingButton.getSelection();
        String label = null;
        RepositoryRoot root = CVSUIPlugin.getPlugin().getRepositoryManager().getRepositoryRootFor(this.location);
        label = root.getName();
        this.useLocationAsLabel.setSelection(label == null);
        this.useCustomLabel.setSelection(!this.useLocationAsLabel.getSelection());
        if (label == null) {
            label = this.location.getLocation(true);
        }
        this.labelText.setText(label);
    }

    private boolean performConnectionInfoChanges() {
        block10: {
            block9: {
                if (!this.connectionInfoChanged) {
                    this.location.setAllowCaching(this.allowCaching);
                    if (!this.passwordChanged) {
                        ((CVSRepositoryLocation)this.location).updateCache();
                    }
                }
                if (!this.passwordChanged && !this.connectionInfoChanged) {
                    return true;
                }
                if (!this.passwordChanged || this.connectionInfoChanged) break block9;
                CVSRepositoryLocation oldLocation = (CVSRepositoryLocation)this.location;
                oldLocation.setPassword(this.getNewPassword());
                if (this.allowCaching) {
                    oldLocation.updateCache();
                }
                this.passwordChanged = false;
                return true;
            }
            if (this.location.getHost().equals(this.hostText.getText()) && this.location.getRootDirectory().equals(this.pathText.getText()) || MessageDialog.openConfirm((Shell)this.getShell(), (String)CVSUIMessages.CVSRepositoryPropertiesPage_0, (String)CVSUIMessages.CVSRepositoryPropertiesPage_1)) break block10;
            return false;
        }
        try {
            final boolean[] result = new boolean[1];
            final ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                /*
                 * Unable to fully structure code
                 */
                public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        block11: {
                            newLocation = CVSRepositoryLocation.fromProperties((Properties)CVSRepositoryPropertiesPage.access$2(CVSRepositoryPropertiesPage.this));
                            newLocation.setEncoding(CVSRepositoryPropertiesPage.this.location.getEncoding());
                            CVSRepositoryPropertiesPage.this.location.setAllowCaching(CVSRepositoryPropertiesPage.access$3(CVSRepositoryPropertiesPage.this));
                            projects = new ArrayList<IProject>();
                            var8_6 = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                            var7_7 = allProjects.length;
                            var6_9 = 0;
                            while (var6_9 < var7_7) {
                                project = var8_6[var6_9];
                                teamProvider = RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                                if (teamProvider != null && (cvsProvider = (CVSTeamProvider)teamProvider).getCVSWorkspaceRoot().getRemoteLocation().equals(CVSRepositoryPropertiesPage.this.location)) {
                                    projects.add(project);
                                }
                                ++var6_9;
                            }
                            if (projects.size() <= 0) ** GOTO lbl38
                            dialog = new DetailsDialogWithProjects(progressMonitorDialog.getShell(), CVSUIMessages.CVSRepositoryPropertiesPage_Confirm_Project_Sharing_Changes_1, CVSUIMessages.CVSRepositoryPropertiesPage_There_are_projects_in_the_workspace_shared_with_this_repository_2, NLS.bind((String)CVSUIMessages.CVSRepositoryPropertiesPage_sharedProject, (Object[])new String[]{CVSRepositoryPropertiesPage.this.location.toString()}), projects.toArray(new IProject[projects.size()]), true, "dialog_warning_image");
                            r = dialog.open();
                            if (r == 0) break block11;
                            result[0] = false;
                            newLocation = (CVSRepositoryLocation)KnownRepositories.getInstance().addRepository((ICVSRepositoryLocation)newLocation, KnownRepositories.getInstance().isKnownRepository(newLocation.getLocation()) == false);
                            return;
                        }
                        try {
                            monitor.beginTask(null, 1000 * projects.size());
                            try {
                                for (IProject project : projects) {
                                    teamProvider = RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                                    cvsProvider = (CVSTeamProvider)teamProvider;
                                    cvsProvider.setRemoteRoot((ICVSRepositoryLocation)newLocation, Policy.subMonitorFor(monitor, 1000));
                                }
                            }
                            finally {
                                monitor.done();
                            }
                            CVSUIPlugin.getPlugin().getRepositoryManager().replaceRepositoryLocation(CVSRepositoryPropertiesPage.this.location, newLocation);
                        }
                        catch (Throwable var12_14) {
                            newLocation = (CVSRepositoryLocation)KnownRepositories.getInstance().addRepository((ICVSRepositoryLocation)newLocation, KnownRepositories.getInstance().isKnownRepository(newLocation.getLocation()) == false);
                            throw var12_14;
                        }
                        newLocation = (CVSRepositoryLocation)KnownRepositories.getInstance().addRepository((ICVSRepositoryLocation)newLocation, KnownRepositories.getInstance().isKnownRepository(newLocation.getLocation()) == false);
                        CVSRepositoryPropertiesPage.this.location = newLocation;
                        CVSRepositoryPropertiesPage.this.connectionInfoChanged = false;
                        CVSRepositoryPropertiesPage.this.passwordChanged = false;
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                    result[0] = true;
                }
            });
            return result[0];
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private void performNonConnectionInfoChanges() {
        this.recordNewLabel((CVSRepositoryLocation)this.location);
    }

    public boolean performOk() {
        if (this.performConnectionInfoChanges()) {
            this.performNonConnectionInfoChanges();
            return true;
        }
        return false;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeValues();
    }

    protected void handle(Throwable e) {
        CVSUIPlugin.openError(this.getShell(), null, null, e);
    }

    protected void updateWidgetEnablements() {
        if (this.useLocationAsLabel.getSelection()) {
            this.labelText.setEnabled(false);
        } else {
            this.labelText.setEnabled(true);
        }
        if (this.useDefaultPort.getSelection()) {
            this.portText.setEnabled(false);
        } else {
            this.portText.setEnabled(true);
        }
        this.validateFields();
    }

    private void validateFields() {
        String port;
        if (this.labelText.isEnabled() && this.labelText.getText().length() == 0) {
            this.setValid(false);
            return;
        }
        String user = this.userText.getText();
        IStatus status = ConfigurationWizardMainPage.validateUserName(user);
        if (!this.isStatusOK(status)) {
            return;
        }
        String host = this.hostText.getText();
        status = ConfigurationWizardMainPage.validateHost(host);
        if (!this.isStatusOK(status)) {
            return;
        }
        if (this.portText.isEnabled() && !this.isStatusOK(status = ConfigurationWizardMainPage.validatePort(port = this.portText.getText()))) {
            return;
        }
        String pathString = this.pathText.getText();
        status = ConfigurationWizardMainPage.validatePath(pathString);
        if (!this.isStatusOK(status)) {
            return;
        }
        try {
            CVSRepositoryLocation l = CVSRepositoryLocation.fromProperties((Properties)this.createProperties());
            if (!l.equals((Object)this.location) && KnownRepositories.getInstance().isKnownRepository(l.getLocation())) {
                this.setErrorMessage(CVSUIMessages.ConfigurationWizardMainPage_0);
                this.setValid(false);
                return;
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }

    private boolean isStatusOK(IStatus status) {
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            this.setValid(false);
            return false;
        }
        return true;
    }

    private void recordNewLabel(CVSRepositoryLocation location) {
        String oldLabel;
        String newLabel = this.getNewLabel(location);
        if (newLabel == null ? (oldLabel = this.getOldLabel(location)) == null || oldLabel.equals(location.getLocation()) : newLabel.equals(this.getOldLabel(location))) {
            return;
        }
        CVSUIPlugin.getPlugin().getRepositoryManager().setLabel(location, newLabel);
        CVSUIPlugin.broadcastPropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED", null, null));
    }

    private String getOldLabel(CVSRepositoryLocation location) {
        return CVSUIPlugin.getPlugin().getRepositoryManager().getRepositoryRootFor((ICVSRepositoryLocation)location).getName();
    }

    private String getNewLabel(CVSRepositoryLocation location) {
        String label = null;
        if (this.useCustomLabel.getSelection() && (label = this.labelText.getText()).equals(location.getLocation())) {
            label = null;
        }
        return label;
    }

    String getNewPassword() {
        return this.passwordText.getText();
    }

    private Properties createProperties() {
        Properties result = new Properties();
        result.setProperty("connection", this.methodType.getText());
        result.setProperty("user", this.userText.getText());
        if (this.passwordChanged) {
            result.setProperty("password", this.passwordText.getText());
        }
        result.setProperty("host", this.hostText.getText());
        if (this.useCustomPort.getSelection()) {
            result.setProperty("port", this.portText.getText());
        }
        result.setProperty("root", this.pathText.getText());
        return result;
    }

    static /* synthetic */ Properties access$2(CVSRepositoryPropertiesPage cVSRepositoryPropertiesPage) {
        return cVSRepositoryPropertiesPage.createProperties();
    }

    static /* synthetic */ boolean access$3(CVSRepositoryPropertiesPage cVSRepositoryPropertiesPage) {
        return cVSRepositoryPropertiesPage.allowCaching;
    }
}

