/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CacheBaseContentsOperation;
import org.eclipse.team.internal.ccvs.ui.operations.SingleProjectScopeManager;
import org.eclipse.team.internal.ccvs.ui.operations.SingleProjectSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberOperation;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class RefreshDirtyStateOperation
extends CVSSubscriberOperation {
    protected RefreshDirtyStateOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    @Override
    protected void runWithProjectRule(IProject project, SyncInfoSet set, IProgressMonitor monitor) throws TeamException {
        SyncInfo[] infos = set.getSyncInfos();
        if (infos.length == 0) {
            return;
        }
        monitor.beginTask(null, 200);
        this.ensureBaseContentsCached(project, infos, Policy.subMonitorFor(monitor, 100));
        this.performCleanTimestamps(project, infos, monitor);
        monitor.done();
    }

    private void performCleanTimestamps(IProject project, SyncInfo[] infos, IProgressMonitor monitor) throws CVSException {
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        SyncInfoFilter.ContentComparisonSyncInfoFilter comparator = new SyncInfoFilter.ContentComparisonSyncInfoFilter(false);
        folder.run(monitor1 -> {
            monitor1.beginTask(null, infos.length * 100);
            SyncInfo[] syncInfoArray2 = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                SyncInfo info = syncInfoArray2[n2];
                IResource resource = info.getLocal();
                if (resource.getType() == 1 && comparator.compareContents((IFile)resource, info.getBase(), Policy.subMonitorFor(monitor1, 100))) {
                    ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource));
                    cvsFile.checkedIn(null, false);
                }
                ++n2;
            }
            monitor1.done();
        }, Policy.subMonitorFor(monitor, 100));
    }

    private void ensureBaseContentsCached(IProject project, SyncInfo[] infos, IProgressMonitor monitor) throws CVSException {
        ArrayList<IDiff> diffs = new ArrayList<IDiff>();
        SyncInfo[] syncInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo info = syncInfoArray[n2];
            IDiff node = this.getConverter().getDeltaFor(info);
            diffs.add(node);
            ++n2;
        }
        this.ensureBaseContentsCached(project, diffs.toArray(new IDiff[diffs.size()]), monitor);
    }

    private SyncInfoToDiffConverter getConverter() {
        SyncInfoToDiffConverter converter = (SyncInfoToDiffConverter)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().getAdapter(SyncInfoToDiffConverter.class);
        if (converter == null) {
            return SyncInfoToDiffConverter.getDefault();
        }
        return converter;
    }

    private void ensureBaseContentsCached(final IProject project, IDiff[] nodes, IProgressMonitor monitor) throws CVSException {
        try {
            ResourceDiffTree tree = new ResourceDiffTree();
            IDiff[] iDiffArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                IDiff node = iDiffArray[n2];
                tree.add(node);
                ++n2;
            }
            new CacheBaseContentsOperation(this.getPart(), new ResourceMapping[]{(ResourceMapping)project.getAdapter(ResourceMapping.class)}, (IResourceDiffTree)tree, true){

                @Override
                protected ResourceMappingContext getResourceMappingContext() {
                    return new SingleProjectSubscriberContext((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), false, project);
                }

                @Override
                protected SynchronizationScopeManager createScopeManager(boolean consultModels) {
                    return new SingleProjectScopeManager(this.getJobName(), this.getSelectedMappings(), this.getResourceMappingContext(), consultModels, project);
                }
            }.run(monitor);
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    @Override
    protected String getErrorTitle() {
        return CVSUIMessages.RefreshDirtyStateOperation_0;
    }

    protected String getJobName() {
        return CVSUIMessages.RefreshDirtyStateOperation_1;
    }
}

