/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.AdaptableResourceList;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.PlatformUI;

public class CheckoutAsProjectSelectionPage
extends CVSWizardPage {
    public static final String NAME = "CheckoutAsProjectSelectionPage";
    private TreeViewer tree;
    private Text nameField;
    private Combo filterList;
    private IResource selection;
    private ICVSRemoteFolder[] remoteFolders;
    private String folderName;
    private int filter;

    public CheckoutAsProjectSelectionPage(ImageDescriptor titleImage, ICVSRemoteFolder[] remoteFolders) {
        super(NAME, CVSUIMessages.CheckoutAsProjectSelectionPage_title, titleImage, CVSUIMessages.CheckoutAsProjectSelectionPage_description);
        this.remoteFolders = remoteFolders;
    }

    private boolean isSingleFolder() {
        return this.remoteFolders.length == 1;
    }

    private String getInputFolderName() {
        return CheckoutAsProjectSelectionPage.getPreferredFolderName(this.remoteFolders[0]);
    }

    private String getRepository() throws CVSException {
        return this.remoteFolders[0].getFolderSyncInfo().getRoot();
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 2, false);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.checkout_into_resource_selection_page_context");
        if (this.isSingleFolder()) {
            CheckoutAsProjectSelectionPage.createLabel(composite, CVSUIMessages.CheckoutAsProjectSelectionPage_name);
            this.nameField = CheckoutAsProjectSelectionPage.createTextField(composite);
            this.nameField.addListener(24, event -> {
                this.folderName = this.nameField.getText();
                this.updateWidgetEnablements();
            });
        }
        this.createWrappingLabel(composite, CVSUIMessages.CheckoutAsProjectSelectionPage_treeLabel, 0, 2);
        this.tree = this.createResourceSelectionTree(composite, 6, 2);
        this.tree.addSelectionChangedListener(event -> this.handleResourceSelection(event));
        Composite filterComposite = this.createComposite(composite, 2, false);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        filterComposite.setLayoutData((Object)data);
        CheckoutAsProjectSelectionPage.createLabel(filterComposite, CVSUIMessages.CheckoutAsProjectSelectionPage_showLabel);
        this.filterList = this.createCombo(filterComposite);
        this.filterList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutAsProjectSelectionPage.this.handleFilterSelection();
            }
        });
        this.createWrappingLabel(composite, "", 0, 2);
        this.initializeValues();
        this.updateWidgetEnablements();
        this.tree.getControl().setFocus();
        Dialog.applyDialogFont((Control)parent);
    }

    private void initializeValues() {
        if (this.isSingleFolder()) {
            this.nameField.setText(this.getInputFolderName());
        }
        this.tree.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.filter = 0;
        this.updateTreeContents(this.filter);
        this.filterList.add(CVSUIMessages.CheckoutAsProjectSelectionPage_showAll);
        this.filterList.add(CVSUIMessages.CheckoutAsProjectSelectionPage_showUnshared);
        this.filterList.add(CVSUIMessages.CheckoutAsProjectSelectionPage_showSameRepo);
        this.filterList.select(this.filter);
    }

    private void handleResourceSelection(SelectionChangedEvent event) {
        ISelection sel = event.getSelection();
        if (sel.isEmpty()) {
            this.selection = null;
        } else if (sel instanceof IStructuredSelection) {
            this.selection = (IResource)((IStructuredSelection)sel).getFirstElement();
        }
        this.updateWidgetEnablements();
    }

    private void updateWidgetEnablements() {
        if (this.isSingleFolder() && !Path.EMPTY.isValidSegment(this.folderName)) {
            this.setPageComplete(false);
            this.setErrorMessage(NLS.bind((String)CVSUIMessages.CheckoutAsProjectSelectionPage_invalidFolderName, (Object[])new String[]{this.folderName}));
            return;
        }
        boolean complete = this.selection != null && this.selection.getType() != 1;
        this.setErrorMessage(null);
        this.setPageComplete(complete);
    }

    public IResource getSelection() {
        return this.selection;
    }

    private void updateTreeContents(int selected) {
        try {
            if (selected == 0) {
                this.tree.setInput((Object)new AdaptableResourceList((IResource[])this.getProjects(this.getRepository(), true)));
            } else if (selected == 1) {
                this.tree.setInput((Object)new AdaptableResourceList((IResource[])this.getProjects(null, true)));
            } else if (selected == 2) {
                this.tree.setInput((Object)new AdaptableResourceList((IResource[])this.getProjects(this.getRepository(), false)));
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    private IProject[] getProjects(String root, boolean unshared) throws CVSException {
        ArrayList<IProject> validTargets = new ArrayList<IProject>();
        try {
            IResource[] projects;
            IResource[] iResourceArray = projects = ResourcesPlugin.getWorkspace().getRoot().members();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                IResource resource = iResourceArray[n2];
                if (resource instanceof IProject && (project = (IProject)resource).isAccessible()) {
                    RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                    if (provider == null && unshared) {
                        validTargets.add(project);
                    } else if (provider != null && provider.getID().equals(CVSProviderPlugin.getTypeId())) {
                        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
                        FolderSyncInfo info = cvsFolder.getFolderSyncInfo();
                        if (root != null && info != null && root.equals(info.getRoot())) {
                            validTargets.add(project);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException((CoreException)e);
        }
        return validTargets.toArray(new IProject[validTargets.size()]);
    }

    public IContainer getLocalFolder() {
        if (Path.EMPTY.isValidSegment(this.folderName)) {
            return ((IContainer)this.getSelection()).getFolder((IPath)new Path(null, this.folderName));
        }
        return null;
    }

    public IContainer getParentFolder() {
        return (IContainer)this.getSelection();
    }

    private void handleFilterSelection() {
        this.filter = this.filterList.getSelectionIndex();
        this.updateTreeContents(this.filter);
    }
}

