/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.math;

public final class SaturatedArithmetic {
    private SaturatedArithmetic() {
    }

    public static int multiply(int left, int right) {
        int retVal = left * right;
        if (left != 0 && retVal / left != right) {
            return SaturatedArithmetic.sameSign(left, right) ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        return retVal;
    }

    public static long multiply(long left, long right) {
        long retVal = left * right;
        if (left != 0L && retVal / left != right) {
            return SaturatedArithmetic.sameSign(left, right) ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return retVal;
    }

    public static final int add(int left, int right) {
        int retVal = left + right;
        if (SaturatedArithmetic.sameSign(left, right) && !SaturatedArithmetic.sameSign(left, retVal)) {
            if (retVal > 0 || left == Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return Integer.MAX_VALUE;
        }
        return retVal;
    }

    public static final long add(long left, long right) {
        long retVal = left + right;
        if (SaturatedArithmetic.sameSign(left, right) && !SaturatedArithmetic.sameSign(left, retVal)) {
            if (retVal > 0L || left == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return Long.MAX_VALUE;
        }
        return retVal;
    }

    public static boolean sameSign(long left, long right) {
        return (left ^ right) >= 0L;
    }
}

