/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.order;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.order.TabOrderInfo;
import org.eclipse.wb.internal.core.model.util.ObjectsLabelProvider;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.TableFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;
import org.eclipse.wb.internal.gef.tree.dnd.TreeTransfer;

final class ReorderDialog
extends ResizableDialog {
    private final TabOrderInfo m_orderInfo;
    private final List<AbstractComponentInfo> m_allInfos;
    private CheckboxTableViewer m_viewer;
    private Button m_upButton;
    private Button m_downButton;
    private Button m_unSelectAllButton;
    private Button m_selectAllButton;

    public ReorderDialog(Shell parentShell, TabOrderInfo orderInfo) {
        super(parentShell, (AbstractUIPlugin)DesignerPlugin.getDefault());
        this.m_orderInfo = orderInfo;
        this.m_allInfos = this.m_orderInfo.getInfos();
        this.setShellStyle(2160);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.create((Composite)container).columns(2);
        Label title = new Label(container, 0);
        title.setText(ModelMessages.ReorderDialog_childrenLabel);
        GridDataFactory.create((Control)title).spanH(2);
        this.m_viewer = CheckboxTableViewer.newCheckList((Composite)container, (int)67584);
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ReorderDialog.this.do_viewer_selectionChanged();
            }
        });
        this.m_viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)ObjectsLabelProvider.INSTANCE);
        TableFactory.modify((TableViewer)this.m_viewer).headerVisible(true).linesVisible(true);
        GridDataFactory.create((Control)this.m_viewer.getControl()).fill().grab().hintC(60, 15);
        TableFactory.modify((TableViewer)this.m_viewer).newColumn().width(this.convertWidthInCharsToPixels(60)).text(ModelMessages.ReorderDialog_childColumn);
        this.m_viewer.setInput(this.m_allInfos);
        this.m_viewer.getTable().select(0);
        this.m_viewer.setCheckedElements(this.m_orderInfo.getOrderedInfos().toArray());
        this.setupDragAndDrop();
        Composite buttonsComposite = new Composite(container, 0);
        GridLayoutFactory.create((Composite)buttonsComposite).noMargins();
        GridDataFactory.create((Control)buttonsComposite).fill().hintHC(18);
        this.m_upButton = new Button(buttonsComposite, 0);
        this.m_upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReorderDialog.this.do_upButton_widgetSelected(e);
            }
        });
        this.m_upButton.setText(ModelMessages.ReorderDialog_upButton);
        GridDataFactory.create((Control)this.m_upButton).fillH().grabH();
        this.m_downButton = new Button(buttonsComposite, 0);
        this.m_downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReorderDialog.this.do_downButton_widgetSelected(e);
            }
        });
        this.m_downButton.setText(ModelMessages.ReorderDialog_downButton);
        GridDataFactory.create((Control)this.m_downButton).fillH().grabH();
        GridDataFactory.create((Control)new Label(buttonsComposite, 0)).fillH().grabH();
        this.m_selectAllButton = new Button(buttonsComposite, 0);
        this.m_selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReorderDialog.this.m_viewer.setAllChecked(true);
            }
        });
        this.m_selectAllButton.setText(ModelMessages.ReorderDialog_selectAllButton);
        GridDataFactory.create((Control)this.m_selectAllButton).fillH().grabH();
        this.m_unSelectAllButton = new Button(buttonsComposite, 0);
        this.m_unSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReorderDialog.this.m_viewer.setAllChecked(false);
            }
        });
        this.m_unSelectAllButton.setText(ModelMessages.ReorderDialog_deselectAllButton);
        GridDataFactory.create((Control)this.m_unSelectAllButton).fillH().grabH();
        this.do_viewer_selectionChanged();
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ModelMessages.ReorderDialog_title);
    }

    protected void okPressed() {
        List<AbstractComponentInfo> orderedInfos = this.m_orderInfo.getOrderedInfos();
        orderedInfos.clear();
        Object[] objectArray = this.m_viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            orderedInfos.add((AbstractComponentInfo)((Object)element));
            ++n2;
        }
        super.okPressed();
    }

    protected void do_viewer_selectionChanged() {
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            this.m_upButton.setEnabled(false);
            this.m_downButton.setEnabled(false);
        } else {
            JavaInfo child = (JavaInfo)((Object)selection.getFirstElement());
            this.m_upButton.setEnabled(this.m_allInfos.indexOf((Object)child) > 0);
            this.m_downButton.setEnabled(this.m_allInfos.indexOf((Object)child) < this.m_allInfos.size() - 1);
        }
    }

    protected void do_upButton_widgetSelected(SelectionEvent e) {
        AbstractComponentInfo child = this.getSelectionElement();
        int index = this.m_allInfos.indexOf((Object)child);
        this.m_allInfos.remove(index);
        this.m_allInfos.add(index - 1, child);
        this.m_viewer.refresh();
        this.do_viewer_selectionChanged();
    }

    protected void do_downButton_widgetSelected(SelectionEvent e) {
        AbstractComponentInfo child = this.getSelectionElement();
        int index = this.m_allInfos.indexOf((Object)child);
        this.m_allInfos.remove((Object)child);
        this.m_allInfos.add(index + 1, child);
        this.m_viewer.refresh();
        this.do_viewer_selectionChanged();
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.m_viewer.getSelection();
    }

    private AbstractComponentInfo getSelectionElement() {
        return (AbstractComponentInfo)((Object)this.getSelection().getFirstElement());
    }

    private void setupDragAndDrop() {
        int ops = 2;
        Transfer[] transfers = new Transfer[]{TreeTransfer.INSTANCE};
        final AbstractComponentInfo[] dragWidget = new AbstractComponentInfo[1];
        this.m_viewer.addDragSupport(ops, transfers, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                dragWidget[0] = ReorderDialog.this.getSelectionElement();
            }
        });
        ViewerDropAdapter adapter = new ViewerDropAdapter((Viewer)this.m_viewer){
            private AbstractComponentInfo m_targetWidget;

            protected int determineLocation(DropTargetEvent event) {
                int location = super.determineLocation(event);
                if (location == 1 || location == 2) {
                    location = 3;
                }
                return location;
            }

            public boolean performDrop(Object data) {
                int sourceIndex = ReorderDialog.this.m_allInfos.indexOf((Object)dragWidget[0]);
                int targetIndex = ReorderDialog.this.m_allInfos.indexOf((Object)this.m_targetWidget);
                ReorderDialog.this.m_allInfos.remove(sourceIndex);
                if (this.m_targetWidget == null) {
                    ReorderDialog.this.m_allInfos.add(dragWidget[0]);
                } else if (sourceIndex < targetIndex) {
                    ReorderDialog.this.m_allInfos.add(targetIndex - 1, dragWidget[0]);
                } else {
                    ReorderDialog.this.m_allInfos.add(targetIndex, dragWidget[0]);
                }
                ReorderDialog.this.m_viewer.refresh();
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                this.m_targetWidget = (AbstractComponentInfo)((Object)target);
                return true;
            }
        };
        adapter.setFeedbackEnabled(true);
        this.m_viewer.addDropSupport(ops | 0x10, transfers, (DropTargetListener)adapter);
    }
}

