/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.datamodel.ui;

import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.AddablePageGroup;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageGroupHandler;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageHandler;

public class SimplePageGroup
implements AddablePageGroup {
    private String groupID;
    private String wizardID;
    private boolean allowExtendedPages;
    private String requiredDataOperation;
    private Set dataModelIDs;
    private IDMPageHandler pageHandler;
    private IDMPageGroupHandler pageGroupHandler;
    private Vector pages;

    public SimplePageGroup(String groupID, String wizardID, boolean allowExtendedPages, String requireDataOperation) {
        this.groupID = groupID;
        this.wizardID = wizardID;
        this.allowExtendedPages = allowExtendedPages;
        this.requiredDataOperation = requireDataOperation;
        this.pages = new Vector();
    }

    public SimplePageGroup(String groupID, String wizardID) {
        this(groupID, wizardID, true, null);
    }

    public void addPage(IWizardPage page) {
        this.pages.add(page);
    }

    public void addPages(IWizardPage[] newPages) {
        int index = 0;
        while (index < newPages.length) {
            this.pages.add(newPages[index]);
            ++index;
        }
    }

    public boolean getAllowsExtendedPages() {
        return this.allowExtendedPages;
    }

    public void setPageGroupHandler(IDMPageGroupHandler handler) {
        this.pageGroupHandler = handler;
    }

    public IDMPageGroupHandler getPageGroupHandler(IDataModel dataModel) {
        return this.pageGroupHandler;
    }

    public void setPageHandler(IDMPageHandler handler) {
        this.pageHandler = handler;
    }

    public IDMPageHandler getPageHandler(IDataModel dataModel) {
        return this.pageHandler;
    }

    public List getPages(IDataModel dataModel) {
        return this.pages;
    }

    public IWizardPage[] getExtendedPages(IDataModel dataModel) {
        return this.pages.toArray(new IWizardPage[0]);
    }

    public String getPageGroupID() {
        return this.groupID;
    }

    public String getPageGroupInsertionID() {
        return null;
    }

    public String getRequiredDataOperationToRun() {
        return this.requiredDataOperation;
    }

    public String getWizardID() {
        return this.wizardID;
    }

    public Set getDataModelIDs() {
        return this.dataModelIDs;
    }

    public void setDataModelIDs(Set dataModelIDs) {
        this.dataModelIDs = dataModelIDs;
    }
}

