/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.pdf;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.transcoder.DefaultErrorHandler;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.fop.svg.PDFTranscoder;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.pdf.PDFInteractiveRenderer;
import org.eclipse.birt.chart.device.svg.SVGRendererImpl;
import org.eclipse.birt.chart.device.util.ChartTextRenderer;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.w3c.dom.Document;

public class PDFRendererImpl
extends SVGRendererImpl {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.svg/trace");

    protected void init() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this._ids = ps.getDisplayServer("ds.PDF");
            this._tr = new ChartTextRenderer(this._ids);
            this.ivRenderer = new PDFInteractiveRenderer((IDeviceRenderer)this);
        }
        catch (ChartException pex) {
            logger.log((Exception)((Object)pex));
        }
    }

    public void enableInteraction(InteractionEvent ie) throws ChartException {
    }

    public void setProperty(String sProperty, Object oValue) {
        if (!(sProperty.equals("device.component") || sProperty.equals("javascript.code.list") || sProperty.equals("javascript.ref.list"))) {
            if (sProperty.equals("resize.svg")) {
                this._resizeSVG = false;
            } else {
                super.setProperty(sProperty, oValue);
            }
        }
    }

    protected void addGroupStructure(Object block) {
    }

    public void after() throws ChartException {
        if (this.oOutputIdentifier instanceof OutputStream) {
            try {
                this.transcode2PDF(new StringReader(this.serializeGeneratedDocumentToString(this.dom)), (OutputStream)this.oOutputIdentifier);
            }
            catch (Exception ex) {
                throw new ChartException("org.eclipse.birt.chart.device.svg", 11, (Throwable)ex);
            }
        } else if (this.oOutputIdentifier instanceof String) {
            FileOutputStream fos = null;
            try {
                fos = SecurityUtil.newFileOutputStream((String)((String)this.oOutputIdentifier));
                StringReader r = new StringReader(this.serializeGeneratedDocumentToString(this.dom));
                this.transcode2PDF(r, (OutputStream)fos);
                fos.close();
            }
            catch (Exception ex) {
                throw new ChartException("org.eclipse.birt.chart.device.svg", 11, (Throwable)ex);
            }
        } else {
            throw new ChartException("org.eclipse.birt.chart.device.svg", 11, "SVGRendererImpl.exception.UnableToWriteChartImage", new Object[]{this.oOutputIdentifier}, null);
        }
    }

    protected void transcode2PDF(TranscoderInput tcin, TranscoderOutput tcout) throws TranscoderException {
        PDFTranscoder t = new PDFTranscoder();
        t.setErrorHandler((ErrorHandler)new DefaultErrorHandler(){

            public void error(TranscoderException te) {
                te.printStackTrace();
            }

            public void warning(TranscoderException te) {
                te.printStackTrace();
            }
        });
        t.transcode(tcin, tcout);
    }

    protected void transcode2PDF(Document dom, OutputStream ostream) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(dom);
        TranscoderOutput tcout = new TranscoderOutput(ostream);
        this.transcode2PDF(tcin, tcout);
        try {
            ostream.flush();
        }
        catch (IOException iOException) {}
    }

    protected void transcode2PDF(Reader r, OutputStream ostream) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(r);
        TranscoderOutput tcout = new TranscoderOutput(ostream);
        this.transcode2PDF(tcin, tcout);
        try {
            ostream.flush();
        }
        catch (IOException iOException) {}
    }

    protected String serializeGeneratedDocumentToString(Document generatedDocument) throws Exception {
        if (generatedDocument == null) {
            return null;
        }
        OutputStreamWriter writer = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        writer = SecurityUtil.newOutputStreamWriter((OutputStream)stream, (String)"UTF-8");
        DOMSource source = new DOMSource(generatedDocument);
        StreamResult result = new StreamResult(writer);
        TransformerFactory transFactory = SecurityUtil.newTransformerFactory();
        Transformer transformer = transFactory.newTransformer();
        transformer.transform(source, result);
        return stream.toString();
    }
}

