/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.participant;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.features.AbstractDefaultDeleteFeature;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramBehavior;

public class DeleteParticipantFeature
extends AbstractDefaultDeleteFeature {
    boolean isReference = false;

    public DeleteParticipantFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canDelete(IDeleteContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)pe)) {
            int referenceCount = 0;
            Participant participant = (Participant)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, Participant.class);
            Definitions definitions = ModelUtil.getDefinitions((Object)participant);
            TreeIterator iter = definitions.eAllContents();
            while (iter.hasNext()) {
                EObject o = (EObject)iter.next();
                for (EReference reference : o.eClass().getEAllReferences()) {
                    if (reference.isContainment() || o instanceof DiagramElement) continue;
                    if (reference.isMany()) {
                        List list = (List)o.eGet((EStructuralFeature)reference);
                        for (Object referencedObject : list) {
                            if (referencedObject != participant) continue;
                            ++referenceCount;
                        }
                        continue;
                    }
                    Object referencedObject = o.eGet((EStructuralFeature)reference);
                    if (referencedObject != participant) continue;
                    ++referenceCount;
                }
            }
            return referenceCount <= 1;
        }
        return true;
    }

    @Override
    public void delete(IDeleteContext context) {
        Participant lastParticipant;
        Collaboration collaboration = null;
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof ContainerShape) {
            ContainerShape poolShape = (ContainerShape)pe;
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            if (bo instanceof Participant) {
                Participant participant = (Participant)bo;
                if (FeatureSupport.isParticipantReference((Diagram)this.getDiagram(), (Participant)participant)) {
                    this.isReference = true;
                }
                if (!this.isReference) {
                    Definitions definitions = ModelUtil.getDefinitions((Object)participant);
                    List collaborations = ModelUtil.getAllRootElements((Definitions)definitions, Collaboration.class);
                    for (Collaboration c : collaborations) {
                        if (!c.getParticipants().contains(participant)) continue;
                        collaboration = c;
                        break;
                    }
                    ArrayList children = new ArrayList();
                    FeatureSupport.collectChildren((ContainerShape)poolShape, children, (boolean)true);
                    for (PictogramElement child : children) {
                        if (child instanceof Connection) continue;
                        DeleteContext dc = new DeleteContext(child);
                        IDeleteFeature df = this.getFeatureProvider().getDeleteFeature((IDeleteContext)dc);
                        if (!df.canDelete((IDeleteContext)dc)) continue;
                        df.delete((IDeleteContext)dc);
                    }
                    bo = participant.getProcessRef();
                    if (bo instanceof FlowElementsContainer) {
                        BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)((FlowElementsContainer)bo));
                        if (bpmnDiagram != null) {
                            DIUtils.deleteDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)bpmnDiagram);
                        }
                        EcoreUtil.delete((EObject)((FlowElementsContainer)bo), (boolean)true);
                    }
                }
            }
        }
        super.delete(context);
        if (collaboration != null && collaboration.getParticipants().size() == 1 && (lastParticipant = (Participant)collaboration.getParticipants().get(0)).getProcessRef() != null && DIUtils.findBPMNShape((BaseElement)lastParticipant) == null) {
            BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram(collaboration);
            EcoreUtil.delete((EObject)lastParticipant);
            EcoreUtil.delete(collaboration);
            if (bpmnDiagram != null) {
                bpmnDiagram.getPlane().setBpmnElement((BaseElement)lastParticipant.getProcessRef());
            }
        }
    }

    protected void deleteBusinessObjects(Object[] businessObjects) {
        if (businessObjects != null) {
            Object[] objectArray = businessObjects;
            int n = businessObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object bo = objectArray[n2];
                if (!(bo instanceof Participant) || !this.isReference) {
                    this.deleteBusinessObject(bo);
                }
                ++n2;
            }
        }
    }
}

