/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;

public class CSourceManager
implements ICSourceLocator,
IPersistableSourceLocator,
IAdaptable {
    private ISourceLocator fSourceLocator = null;
    private ILaunch fLaunch = null;

    public CSourceManager(ISourceLocator sourceLocator) {
        this.setSourceLocator(sourceLocator);
    }

    @Override
    public int getLineNumber(IStackFrame frame) {
        if (this.getCSourceLocator() != null) {
            return this.getCSourceLocator().getLineNumber(frame);
        }
        if (frame instanceof ICStackFrame) {
            return ((ICStackFrame)frame).getFrameLineNumber();
        }
        return 0;
    }

    @Override
    public ICSourceLocation[] getSourceLocations() {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().getSourceLocations() : new ICSourceLocation[]{};
    }

    @Override
    public void setSourceLocations(ICSourceLocation[] locations) {
        if (this.getCSourceLocator() != null) {
            this.getCSourceLocator().setSourceLocations(locations);
        }
    }

    @Override
    public boolean contains(IResource resource) {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().contains(resource) : false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(CSourceManager.class)) {
            return (T)this;
        }
        if (adapter.equals(ICSourceLocator.class)) {
            return (T)this;
        }
        if (adapter.equals(IPersistableSourceLocator.class)) {
            return (T)this;
        }
        if (adapter.equals(IResourceChangeListener.class) && this.fSourceLocator instanceof IResourceChangeListener) {
            return (T)this.fSourceLocator;
        }
        return null;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        Object result = null;
        if (this.getSourceLocator() != null) {
            result = this.getSourceLocator().getSourceElement(stackFrame);
        }
        return result;
    }

    protected ICSourceLocator getCSourceLocator() {
        if (this.getSourceLocator() instanceof ICSourceLocator) {
            return (ICSourceLocator)this.getSourceLocator();
        }
        return null;
    }

    protected ISourceLocator getSourceLocator() {
        if (this.fSourceLocator != null) {
            return this.fSourceLocator;
        }
        if (this.fLaunch != null) {
            return this.fLaunch.getSourceLocator();
        }
        return null;
    }

    private void setSourceLocator(ISourceLocator sl) {
        this.fSourceLocator = sl;
    }

    @Override
    public Object findSourceElement(String fileName) {
        if (this.getCSourceLocator() != null) {
            return this.getCSourceLocator().findSourceElement(fileName);
        }
        return null;
    }

    public String getMemento() throws CoreException {
        if (this.getPersistableSourceLocator() != null) {
            return this.getPersistableSourceLocator().getMemento();
        }
        return null;
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        if (this.getPersistableSourceLocator() != null) {
            this.getPersistableSourceLocator().initializeDefaults(configuration);
        }
    }

    public void initializeFromMemento(String memento) throws CoreException {
        if (this.getPersistableSourceLocator() != null) {
            this.getPersistableSourceLocator().initializeFromMemento(memento);
        }
    }

    private IPersistableSourceLocator getPersistableSourceLocator() {
        if (this.fSourceLocator instanceof IPersistableSourceLocator) {
            return (IPersistableSourceLocator)this.fSourceLocator;
        }
        return null;
    }

    @Override
    public IProject getProject() {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().getProject() : null;
    }

    @Override
    public void setSearchForDuplicateFiles(boolean search) {
        if (this.getCSourceLocator() != null) {
            this.getCSourceLocator().setSearchForDuplicateFiles(search);
        }
    }

    @Override
    public boolean searchForDuplicateFiles() {
        return this.getCSourceLocator() != null && this.getCSourceLocator().searchForDuplicateFiles();
    }
}

