"use strict";
/*********************************************************************
 * Copyright (c) 2018 Ericsson and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
function sendDataReadMemoryBytes(gdb, address, size, offset = 0) {
    return gdb.sendCommand(`-data-read-memory-bytes -o ${offset} "${address}" ${size}`);
}
exports.sendDataReadMemoryBytes = sendDataReadMemoryBytes;
function sendDataEvaluateExpression(gdb, expr) {
    return gdb.sendCommand(`-data-evaluate-expression "${expr}"`);
}
exports.sendDataEvaluateExpression = sendDataEvaluateExpression;
// https://sourceware.org/gdb/onlinedocs/gdb/GDB_002fMI-Data-Manipulation.html#The-_002ddata_002ddisassemble-Command
function sendDataDisassemble(gdb, startAddress, endAddress) {
    return __awaiter(this, void 0, void 0, function* () {
        // -- 5 == mixed source and disassembly with raw opcodes
        // TODO needs to be -- 3 for GDB < 7.11 -- are we supporting such old versions?
        const result = yield gdb.sendCommand(`-data-disassemble -s "${startAddress}" -e "${endAddress}" -- 5`);
        // cleanup the result data
        if (result.asm_insns.length > 0) {
            if (!result.asm_insns[0].hasOwnProperty('line_asm_insn')) {
                // In this case there is no source info available for any instruction,
                // so GDB treats as if we had done -- 2 instead of -- 5
                // This bit of code remaps the data to look like it should
                const e = {
                    line_asm_insn: result.asm_insns,
                };
                result.asm_insns = [e];
            }
            for (const asmInsn of result.asm_insns) {
                if (!asmInsn.hasOwnProperty('line_asm_insn')) {
                    asmInsn.line_asm_insn = [];
                }
            }
        }
        return Promise.resolve(result);
    });
}
exports.sendDataDisassemble = sendDataDisassemble;
//# sourceMappingURL=data.js.map