/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;

public class CfgHolder {
    private static final String DELIMITER = "_with_";
    private static final String LBR = " (v ";
    private static final String RBR = ")";
    private String name;
    private IConfiguration cfg;
    private IToolChain tc;

    public CfgHolder(IToolChain _tc, IConfiguration _cfg) {
        this.tc = _tc;
        this.cfg = _cfg;
        this.name = this.cfg == null ? (this.tc == null || this.tc.getParent() == null ? Messages.StdProjectTypeHandler_2 : this.tc.getParent().getName()) : this.cfg.getName();
    }

    public void setConfiguration(IConfiguration cfg) {
        this.cfg = cfg;
    }

    public boolean isSystem() {
        if (this.cfg == null) {
            return false;
        }
        return this.cfg.isSystemObject();
    }

    public boolean isSupported() {
        if (this.cfg == null) {
            return true;
        }
        return this.cfg.isSupported();
    }

    public static boolean hasDoubles(CfgHolder[] its) {
        int i = 0;
        while (i < its.length) {
            String s = its[i].name;
            int j = 0;
            while (j < its.length) {
                if (i != j && s.equals(its[j].name)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static CfgHolder[] cfgs2items(IConfiguration[] cfgs) {
        CfgHolder[] its = new CfgHolder[cfgs.length];
        int i = 0;
        while (i < cfgs.length) {
            its[i] = new CfgHolder(cfgs[i].getToolChain(), cfgs[i]);
            ++i;
        }
        return its;
    }

    public static CfgHolder[] unique(CfgHolder[] its) {
        int k;
        if (CfgHolder.hasDoubles(its)) {
            k = 0;
            while (k < its.length) {
                String ver;
                if (its[k].tc != null && (ver = ManagedBuildManager.getVersionFromIdAndVersion((String)its[k].tc.getId())) != null) {
                    its[k].name = String.valueOf(its[k].name) + LBR + ver + RBR;
                }
                ++k;
            }
        }
        if (CfgHolder.hasDoubles(its)) {
            k = 0;
            while (k < its.length) {
                IToolChain tc;
                String s = its[k].name;
                int x = s.indexOf(LBR);
                if (x >= 0) {
                    s = s.substring(0, x);
                }
                if ((tc = its[k].tc) == null && its[k].cfg != null) {
                    tc = its[k].cfg.getToolChain();
                }
                if (tc != null) {
                    its[k].name = String.valueOf(s) + DELIMITER + tc.getUniqueRealName();
                }
                ++k;
            }
        }
        if (CfgHolder.hasDoubles(its)) {
            k = 0;
            while (k < its.length) {
                its[k].name = String.valueOf(its[k].name) + k;
                ++k;
            }
        }
        return its;
    }

    public IProjectType getProjectType() {
        if (this.cfg != null) {
            return this.cfg.getProjectType();
        }
        if (this.tc != null && this.tc.getParent() != null) {
            return this.tc.getParent().getProjectType();
        }
        return null;
    }

    public static CfgHolder[] reorder(CfgHolder[] its) {
        ArrayList<CfgHolder> ls = new ArrayList<CfgHolder>(its.length);
        boolean found = true;
        while (found) {
            found = false;
            int i = 0;
            while (i < its.length) {
                if (its[i] != null) {
                    found = true;
                    IProjectType pt = its[i].getProjectType();
                    if (pt == null) {
                        ls.add(its[i]);
                        its[i] = null;
                    } else {
                        IConfiguration[] cfs = pt.getConfigurations();
                        int j = 0;
                        while (j < cfs.length) {
                            int k = 0;
                            while (k < its.length) {
                                if (its[k] != null && cfs[j].equals(its[k].getTcCfg())) {
                                    ls.add(its[k]);
                                    its[k] = null;
                                }
                                ++k;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return ls.toArray(new CfgHolder[ls.size()]);
    }

    public static IConfiguration[] items2cfgs(CfgHolder[] its) {
        ArrayList<IConfiguration> lst = new ArrayList<IConfiguration>(its.length);
        CfgHolder[] cfgHolderArray = its;
        int n = its.length;
        int n2 = 0;
        while (n2 < n) {
            CfgHolder h = cfgHolderArray[n2];
            if (h.cfg != null) {
                lst.add(h.cfg);
            }
            ++n2;
        }
        return lst.toArray(new IConfiguration[lst.size()]);
    }

    public IConfiguration getTcCfg() {
        if (this.tc != null) {
            return this.tc.getParent();
        }
        return null;
    }

    public IConfiguration getConfiguration() {
        return this.cfg;
    }

    public String getName() {
        return this.name;
    }

    public IToolChain getToolChain() {
        return this.tc;
    }
}

