/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.template.c.CContext;
import org.eclipse.cdt.internal.corext.template.c.CContextType;
import org.eclipse.cdt.internal.corext.template.c.TranslationUnitContext;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.preferences.CSourcePreviewerUpdater;
import org.eclipse.cdt.internal.ui.preferences.EditTemplateDialog;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.SimpleCSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.template.TemplateVariableProcessor;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.templates.AbstractTemplatesPage;

public class CTemplatesPage
extends AbstractTemplatesPage {
    private static final String PREFERENCE_PAGE_ID = "org.eclipse.cdt.ui.preferences.TemplatePreferencePage";
    private static final TemplateStore TEMPLATE_STORE = CUIPlugin.getDefault().getTemplateStore();
    private static final IPreferenceStore PREFERENCE_STORE = CUIPlugin.getDefault().getPreferenceStore();
    private static final ContextTypeRegistry TEMPLATE_CONTEXT_REGISTRY = CUIPlugin.getDefault().getTemplateContextRegistry();
    private TemplateVariableProcessor fTemplateProcessor;
    private CEditor fCEditor;

    public CTemplatesPage(CEditor cEditor) {
        super((ITextEditor)cEditor, cEditor.getViewer());
        this.fCEditor = cEditor;
        this.fTemplateProcessor = new TemplateVariableProcessor();
    }

    protected void insertTemplate(Template template, IDocument document) {
        String savedText;
        if (!this.fCEditor.validateEditorInputState()) {
            return;
        }
        ISourceViewer contextViewer = this.fCEditor.getViewer();
        ITextSelection textSelection = (ITextSelection)contextViewer.getSelectionProvider().getSelection();
        if (!this.isValidTemplate(document, template, textSelection.getOffset(), textSelection.getLength())) {
            return;
        }
        this.beginCompoundChange(contextViewer);
        try {
            savedText = document.get(textSelection.getOffset(), textSelection.getLength());
            if (savedText.length() == 0) {
                String prefix = this.getIdentifierPart(document, template, textSelection.getOffset(), textSelection.getLength());
                if (prefix.length() > 0 && !template.getName().startsWith(prefix.toString())) {
                    return;
                }
                if (prefix.length() > 0) {
                    contextViewer.setSelectedRange(textSelection.getOffset() - prefix.length(), prefix.length());
                    textSelection = (ITextSelection)contextViewer.getSelectionProvider().getSelection();
                }
            }
            document.replace(textSelection.getOffset(), textSelection.getLength(), template.getName().substring(0, 1));
        }
        catch (BadLocationException e) {
            this.endCompoundChange(contextViewer);
            return;
        }
        Position position = new Position(textSelection.getOffset() + 1, 0);
        Region region = new Region(textSelection.getOffset() + 1, 0);
        contextViewer.getSelectionProvider().setSelection((ISelection)new TextSelection(textSelection.getOffset(), 1));
        ITranslationUnit compilationUnit = (ITranslationUnit)EditorUtility.getEditorInputCElement((IEditorPart)this.fCEditor);
        TemplateContextType type = this.getContextTypeRegistry().getContextType(template.getContextTypeId());
        TranslationUnitContext context = ((CContextType)type).createContext(document, position, compilationUnit);
        context.setVariable("selection", savedText);
        if (context.getKey().length() == 0) {
            try {
                document.replace(textSelection.getOffset(), 1, savedText);
            }
            catch (BadLocationException e) {
                this.endCompoundChange(contextViewer);
                return;
            }
        }
        TemplateProposal proposal = new TemplateProposal(template, (TemplateContext)context, (IRegion)region, null);
        this.fCEditor.getSite().getPage().activate((IWorkbenchPart)this.fCEditor);
        proposal.apply((ITextViewer)this.fCEditor.getViewer(), ' ', 0, region.getOffset());
        this.endCompoundChange(contextViewer);
    }

    protected ContextTypeRegistry getContextTypeRegistry() {
        return TEMPLATE_CONTEXT_REGISTRY;
    }

    protected IPreferenceStore getTemplatePreferenceStore() {
        return PREFERENCE_STORE;
    }

    public TemplateStore getTemplateStore() {
        return TEMPLATE_STORE;
    }

    protected boolean isValidTemplate(IDocument document, Template template, int offset, int length) {
        String[] contextIds = this.getContextTypeIds(document, offset);
        int i = 0;
        while (i < contextIds.length) {
            if (contextIds[i].equals(template.getContextTypeId())) {
                DocumentTemplateContext context = this.getContext(document, template, offset, length);
                return context.canEvaluate(template) || this.isTemplateAllowed(context, template);
            }
            ++i;
        }
        return false;
    }

    protected SourceViewer createPatternViewer(Composite parent) {
        Document document = new Document();
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        tools.setupCDocumentPartitioner((IDocument)document, "___c_partitioning", null);
        IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
        CSourceViewer viewer = new CSourceViewer(parent, null, null, false, 768, store);
        SimpleCSourceViewerConfiguration configuration = new SimpleCSourceViewerConfiguration(tools.getColorManager(), store, null, "___c_partitioning", false);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont");
        viewer.getTextWidget().setFont(font);
        new CSourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        Control control = viewer.getControl();
        GridData data = new GridData(1296);
        control.setLayoutData((Object)data);
        viewer.setEditable(false);
        return viewer;
    }

    protected Image getImage(Template template) {
        return CDTSharedImages.getImage("icons/obj16/template_obj.gif");
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        EditTemplateDialog dialog = new EditTemplateDialog(this.getSite().getShell(), template, edit, isNameModifiable, false, (org.eclipse.text.templates.ContextTypeRegistry)this.getContextTypeRegistry());
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    protected void updatePatternViewer(Template template) {
        if (template == null) {
            this.getPatternViewer().getDocument().set("");
            return;
        }
        String contextId = template.getContextTypeId();
        TemplateContextType type = this.getContextTypeRegistry().getContextType(contextId);
        this.fTemplateProcessor.setContextType(type);
        IDocument doc = this.getPatternViewer().getDocument();
        String start = "";
        doc.set(String.valueOf(start) + template.getPattern());
        int startLen = start.length();
        this.getPatternViewer().setDocument(doc, startLen, doc.getLength() - startLen);
    }

    protected String getPreferencePageId() {
        return PREFERENCE_PAGE_ID;
    }

    private void endCompoundChange(ISourceViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).getRewriteTarget().endCompoundChange();
        }
    }

    private void beginCompoundChange(ISourceViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).getRewriteTarget().beginCompoundChange();
        }
    }

    private boolean isTemplateAllowed(DocumentTemplateContext context, Template template) {
        try {
            int offset = context.getCompletionOffset();
            return offset > 0 && !this.isTemplateNamePart(context.getDocument().getChar(offset - 1));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isTemplateNamePart(char ch) {
        return !Character.isWhitespace(ch) && ch != '(' && ch != ')' && ch != '{' && ch != '}' && ch != ';';
    }

    private DocumentTemplateContext getContext(IDocument document, Template template, int offset, int length) {
        CContext context = new CContext(this.getContextTypeRegistry().getContextType(template.getContextTypeId()), document, new Position(offset, length), (ITranslationUnit)EditorUtility.getEditorInputCElement((IEditorPart)this.fCEditor));
        return context;
    }

    protected String[] getContextTypeIds(IDocument document, int offset) {
        return new String[]{"org.eclipse.cdt.ui.text.templates.c"};
    }

    private String getIdentifierPart(IDocument document, Template template, int offset, int length) {
        return this.getContext(document, template, offset, length).getKey();
    }
}

