/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.ui.editor.SourceHeaderPartnerFinder;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoringContext;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.InsertLocation;
import org.eclipse.cdt.internal.ui.refactoring.utils.DefinitionFinder;
import org.eclipse.cdt.internal.ui.refactoring.utils.NamespaceHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class MethodDefinitionInsertLocationFinder {
    Map<IASTSimpleDeclaration, IASTName> cachedDeclarationToDefinition = new HashMap<IASTSimpleDeclaration, IASTName>();

    public InsertLocation find(ITranslationUnit declarationTu, IASTFileLocation methodDeclarationLocation, IASTNode parent, CRefactoringContext refactoringContext, IProgressMonitor pm) throws CoreException {
        IASTName name;
        IASTName definition;
        IASTDeclaration[] declarations = NodeHelper.getDeclarations(parent);
        InsertLocation insertLocation = new InsertLocation();
        Collection<IASTSimpleDeclaration> allPreviousSimpleDeclarationsFromClassInReverseOrder = MethodDefinitionInsertLocationFinder.getAllPreviousSimpleDeclarationsFromClassInReverseOrder(declarations, methodDeclarationLocation, pm);
        Collection<IASTSimpleDeclaration> allFollowingSimpleDeclarationsFromClass = MethodDefinitionInsertLocationFinder.getAllFollowingSimpleDeclarationsFromClass(declarations, methodDeclarationLocation, pm);
        for (IASTSimpleDeclaration simpleDeclaration : allPreviousSimpleDeclarationsFromClassInReverseOrder) {
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            definition = null;
            if (this.cachedDeclarationToDefinition.containsKey(simpleDeclaration)) {
                definition = this.cachedDeclarationToDefinition.get(simpleDeclaration);
            } else {
                name = simpleDeclaration.getDeclarators()[0].getName();
                definition = DefinitionFinder.getDefinition(name, refactoringContext, pm);
                if (definition != null) {
                    this.cachedDeclarationToDefinition.put(simpleDeclaration, definition);
                }
            }
            if (definition == null) continue;
            insertLocation.setNodeToInsertAfter(MethodDefinitionInsertLocationFinder.findFirstSurroundingParentFunctionNode((IASTNode)definition), definition.getTranslationUnit().getOriginatingTranslationUnit());
        }
        for (IASTSimpleDeclaration simpleDeclaration : allFollowingSimpleDeclarationsFromClass) {
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            definition = null;
            if (this.cachedDeclarationToDefinition.containsKey(simpleDeclaration)) {
                definition = this.cachedDeclarationToDefinition.get(simpleDeclaration);
            } else {
                name = simpleDeclaration.getDeclarators()[0].getName();
                definition = DefinitionFinder.getDefinition(name, refactoringContext, pm);
                if (definition != null) {
                    this.cachedDeclarationToDefinition.put(simpleDeclaration, definition);
                }
            }
            if (definition == null) continue;
            insertLocation.setNodeToInsertBefore(MethodDefinitionInsertLocationFinder.findFirstSurroundingParentFunctionNode((IASTNode)definition), definition.getTranslationUnit().getOriginatingTranslationUnit());
        }
        if (insertLocation.getTranslationUnit() == null) {
            if (declarationTu.isHeaderUnit()) {
                ITranslationUnit partner = SourceHeaderPartnerFinder.getPartnerTranslationUnit(declarationTu, refactoringContext);
                if (partner != null) {
                    if (methodDeclarationLocation == null) {
                        insertLocation.setParentNode((IASTNode)refactoringContext.getAST(partner, null), partner);
                        return insertLocation;
                    }
                    final ICPPASTName[] names = NamespaceHelper.getSurroundingNamespace(declarationTu, methodDeclarationLocation.getNodeOffset(), refactoringContext);
                    IASTTranslationUnit ast = refactoringContext.getAST(partner, null);
                    final IASTNode[] target = new IASTNode[1];
                    if (ast != null) {
                        ast.accept(new ASTVisitor(){
                            {
                                this.shouldVisitNamespaces = true;
                            }

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
                                IASTName name = namespaceDefinition.getName();
                                IBinding binding = name.resolveBinding();
                                if (!(binding instanceof ICPPNamespace)) {
                                    return 3;
                                }
                                try {
                                    char[][] qualNames = ((ICPPNamespace)binding).getQualifiedNameCharArray();
                                    if (qualNames.length != names.length - 1) {
                                        return 3;
                                    }
                                    int i = 0;
                                    while (i < names.length - 1) {
                                        if (!CharArrayUtils.equals((char[])qualNames[i], (char[])names[i].getSimpleID())) {
                                            return 3;
                                        }
                                        ++i;
                                    }
                                }
                                catch (DOMException e) {
                                    e.printStackTrace();
                                    return 3;
                                }
                                target[0] = namespaceDefinition;
                                return 2;
                            }
                        });
                    }
                    if (target[0] != null) {
                        insertLocation.setParentNode(target[0], partner);
                    } else {
                        insertLocation.setParentNode((IASTNode)ast, partner);
                    }
                }
            } else {
                insertLocation.setParentNode((IASTNode)parent.getTranslationUnit(), declarationTu);
            }
        }
        return insertLocation;
    }

    private static IASTNode findFunctionDefinitionInParents(IASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof IASTFunctionDefinition) {
            if (node.getParent() instanceof ICPPASTTemplateDeclaration) {
                node = node.getParent();
            }
            return node;
        }
        return MethodDefinitionInsertLocationFinder.findFunctionDefinitionInParents(node.getParent());
    }

    private static IASTNode findFirstSurroundingParentFunctionNode(IASTNode definition) {
        IASTNode functionDefinitionInParents = MethodDefinitionInsertLocationFinder.findFunctionDefinitionInParents(definition);
        if (functionDefinitionInParents == null) {
            return null;
        }
        if (functionDefinitionInParents.getNodeLocations().length == 0) {
            return null;
        }
        return functionDefinitionInParents;
    }

    private static Collection<IASTSimpleDeclaration> getAllPreviousSimpleDeclarationsFromClassInReverseOrder(IASTDeclaration[] declarations, IASTFileLocation methodPosition, IProgressMonitor pm) {
        ArrayList<IASTSimpleDeclaration> outputDeclarations = new ArrayList<IASTSimpleDeclaration>();
        if (declarations.length >= 0) {
            IASTDeclaration[] iASTDeclarationArray = declarations;
            int n = declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration decl = iASTDeclarationArray[n2];
                if (pm != null && pm.isCanceled()) {
                    return outputDeclarations;
                }
                if (methodPosition != null && decl.getFileLocation().getStartingLineNumber() >= methodPosition.getStartingLineNumber()) break;
                if (MethodDefinitionInsertLocationFinder.isMemberFunctionDeclaration(decl)) {
                    outputDeclarations.add((IASTSimpleDeclaration)decl);
                }
                ++n2;
            }
        }
        Collections.reverse(outputDeclarations);
        return outputDeclarations;
    }

    private static Collection<IASTSimpleDeclaration> getAllFollowingSimpleDeclarationsFromClass(IASTDeclaration[] declarations, IASTFileLocation methodPosition, IProgressMonitor pm) {
        ArrayList<IASTSimpleDeclaration> outputDeclarations = new ArrayList<IASTSimpleDeclaration>();
        if (methodPosition == null) {
            return outputDeclarations;
        }
        if (declarations.length >= 0) {
            IASTDeclaration[] iASTDeclarationArray = declarations;
            int n = declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration decl = iASTDeclarationArray[n2];
                if (pm != null && pm.isCanceled()) {
                    return outputDeclarations;
                }
                if (MethodDefinitionInsertLocationFinder.isMemberFunctionDeclaration(decl) && decl.getFileLocation().getStartingLineNumber() > methodPosition.getStartingLineNumber()) {
                    outputDeclarations.add((IASTSimpleDeclaration)decl);
                }
                ++n2;
            }
        }
        return outputDeclarations;
    }

    private static boolean isMemberFunctionDeclaration(IASTDeclaration decl) {
        return decl instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)decl).getDeclarators().length > 0 && ((IASTSimpleDeclaration)decl).getDeclarators()[0] instanceof IASTFunctionDeclarator;
    }
}

