/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CloudApplicationURL;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.cft.server.ui.internal.CloudApplicationUrlPart;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.wizards.AbstractURLWizardPage;
import org.eclipse.cft.server.ui.internal.wizards.CloudUIEvent;
import org.eclipse.cft.server.ui.internal.wizards.HostnameValidationResult;
import org.eclipse.cft.server.ui.internal.wizards.IReservedURLTracker;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ApplicationURLWizard
extends Wizard
implements IReservedURLTracker {
    private final CloudFoundryServer cloudServer;
    private final String initialUrl;
    private String editedUrl;
    private ApplicationURLWizardPage urlPage;
    private static final String title = Messages.ApplicationURLWizard_TITLE_MOD_APP_URL;
    private List<CloudApplicationURL> reservedUrls;

    public ApplicationURLWizard(CloudFoundryServer cloudServer, String initialUrl) {
        this.cloudServer = cloudServer;
        this.initialUrl = initialUrl;
        this.setWindowTitle(title);
        this.setNeedsProgressMonitor(true);
        this.reservedUrls = new ArrayList<CloudApplicationURL>();
    }

    public boolean performFinish() {
        CFUiUtil.cleanupReservedRoutes((IWizard)this, this.cloudServer, this.reservedUrls, this.editedUrl);
        return true;
    }

    public boolean performCancel() {
        CFUiUtil.cleanupReservedRoutes((IWizard)this, this.cloudServer, this.reservedUrls, null);
        return super.performCancel();
    }

    public void addPages() {
        String serverTypeId = this.cloudServer.getServer().getServerType().getId();
        ImageDescriptor imageDescriptor = CloudFoundryImages.getWizardBanner(serverTypeId);
        ApplicationUrlLookupService urlLookup = ApplicationUrlLookupService.getCurrentLookup((CloudFoundryServer)this.cloudServer);
        this.urlPage = this.createPage(imageDescriptor, urlLookup);
        this.urlPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.urlPage);
    }

    public String getUrl() {
        return this.editedUrl;
    }

    protected ApplicationURLWizardPage createPage(ImageDescriptor imageDescriptor, ApplicationUrlLookupService urlLookup) {
        CloudApplicationUrlPart urlPart = new CloudApplicationUrlPart(urlLookup);
        ApplicationURLWizardPage applicationURLWizardPage = new ApplicationURLWizardPage(imageDescriptor, urlLookup, urlPart);
        urlPart.setPage((IWizardPage)applicationURLWizardPage);
        return applicationURLWizardPage;
    }

    @Override
    public void addToReserved(CloudApplicationURL appUrl, boolean isUrlCreatedByWizard) {
        this.reservedUrls.add(appUrl);
    }

    @Override
    public void removeFromReserved(CloudApplicationURL appUrl) {
        if (this.reservedUrls.contains(appUrl)) {
            this.reservedUrls.remove(appUrl);
        }
    }

    @Override
    public boolean isReserved(CloudApplicationURL appUrl) {
        return this.reservedUrls.contains(appUrl);
    }

    @Override
    public HostnameValidationResult validateURL(CloudApplicationURL appUrl) {
        return CFUiUtil.validateHostname(appUrl, this.cloudServer, this.getContainer());
    }

    class ApplicationURLWizardPage
    extends AbstractURLWizardPage {
        private final CloudApplicationUrlPart urlPart;

        protected ApplicationURLWizardPage(ImageDescriptor titleImage, ApplicationUrlLookupService urlLookup, CloudApplicationUrlPart urlPart) {
            super(Messages.ApplicationURLWizard_TEXT_PAGE, title, titleImage, urlLookup);
            this.setDescription(Messages.ApplicationURLWizard_TEXT_MOD_APP_URL);
            this.urlPart = urlPart;
        }

        @Override
        protected void performWhenPageVisible() {
            if (!this.refreshedDomains) {
                this.refreshApplicationUrlDomains();
            }
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            this.urlPart.createPart(composite);
            this.urlPart.addPartChangeListener(this);
            this.setControl((Control)composite);
        }

        @Override
        protected void domainsRefreshed() {
            this.urlPart.refreshDomains();
            this.urlPart.setUrl(ApplicationURLWizard.this.initialUrl);
        }

        @Override
        public void handleChange(PartChangeEvent event) {
            if (event.getSource() == CloudUIEvent.APPLICATION_URL_CHANGED) {
                ApplicationURLWizard.this.editedUrl = event.getData() instanceof String ? (String)event.getData() : null;
            }
            super.handleChange(event);
        }
    }
}

