/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class CorePrinter
extends PrintWriter {
    private int fTabLevel = 0;
    private boolean fAfterNewLine = false;

    public CorePrinter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public CorePrinter(OutputStream out) {
        super(out);
    }

    public CorePrinter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public CorePrinter(Writer out) {
        super(out);
    }

    public void indent() {
        this.print("{");
        this.println("");
        this.formatPrint(" ");
        ++this.fTabLevel;
    }

    public void dedent() {
        if (this.fTabLevel > 0) {
            --this.fTabLevel;
        }
        this.printTabs();
        this.print("}");
        this.fAfterNewLine = true;
    }

    private void printTabs() {
        String tabs = "";
        int i = 0;
        while (i < this.fTabLevel) {
            tabs = String.valueOf(tabs) + "\t";
            ++i;
        }
        this.print(tabs);
    }

    public void formatPrintLn(String text) {
        if (this.fAfterNewLine) {
            this.fAfterNewLine = false;
            this.printTabs();
        }
        this.print(text.replaceAll("\n", "/n"));
    }

    public void formatPrint(String text) {
        String[] strs = text.split("\n");
        int count = 0;
        int i = 0;
        while (i < strs.length) {
            this.printTabs();
            if (count != strs.length) {
                this.println(strs[i]);
            } else {
                this.print(strs[i]);
            }
            ++count;
            ++i;
        }
        this.fAfterNewLine = true;
    }
}

