/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.properties;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Named;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.properties.ProjectOSGiTranslationProvider;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ExternalizeStringHandler {
    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Translation Messages messages, IModelResource resource, IResourcePool pool, IProject project) {
        ExtractionDialog dialog = new ExtractionDialog(shell, messages, resource, resource.getRoot(), pool, project);
        dialog.open();
    }

    private static String findId(List<String> ids, String prefix) {
        int count = 1;
        String id = String.valueOf(prefix) + "." + count;
        while (ids.contains(id)) {
            id = String.valueOf(prefix) + "." + ++count;
        }
        return id;
    }

    static class Entry {
        private EObject object;
        private EStructuralFeature feature;
        private String key;
        private String value;

        public Entry(EObject object, EStructuralFeature feature, String key, String value) {
            this.object = object;
            this.feature = feature;
            this.key = key;
            this.value = value;
        }
    }

    static class ExtractionDialog
    extends TitleAreaDialog {
        private Messages messages;
        private IObservableList<? extends EObject> list;
        private IResourcePool pool;
        private IProject project;
        private CheckboxTableViewer viewer;
        private IModelResource resource;

        public ExtractionDialog(Shell parentShell, Messages messages, IModelResource resource, IObservableList<? extends EObject> list, IResourcePool pool, IProject project) {
            super(parentShell);
            this.messages = messages;
            this.list = list;
            this.pool = pool;
            this.project = project;
            this.resource = resource;
        }

        /*
         * WARNING - void declaration
         */
        protected Control createDialogArea(Composite parent) {
            void var10_16;
            this.getShell().setText(this.messages.ExternalizeStringHandler_Dialog_ShellTitle);
            this.setTitle(this.messages.ExternalizeStringHandler_Dialog_DialogTitle);
            this.setMessage(this.messages.ExternalizeStringHandler_Dialog_DialogMessage);
            this.setTitleImage(this.pool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.wizban.extstr_wiz"));
            Composite container = (Composite)super.createDialogArea(parent);
            Table t = new Table(container, 68384);
            GridData gd = new GridData(1808);
            gd.heightHint = t.getItemHeight() * 15;
            t.setLayoutData((Object)gd);
            t.setHeaderVisible(true);
            t.setLinesVisible(true);
            this.viewer = new CheckboxTableViewer(t);
            TableViewerColumn column = new TableViewerColumn((TableViewer)this.viewer, 0);
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return "";
                }
            });
            column = new TableViewerColumn((TableViewer)this.viewer, 0);
            column.getColumn().setText(this.messages.ExternalizeStringHandler_Dialog_ElementName);
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Entry e = (Entry)element;
                    return e.object.eClass().getName();
                }
            });
            column = new TableViewerColumn((TableViewer)this.viewer, 0);
            column.getColumn().setText(this.messages.ExternalizeStringHandler_Dialog_AttributeName);
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Entry e = (Entry)element;
                    return e.feature.getName();
                }
            });
            column = new TableViewerColumn((TableViewer)this.viewer, 0);
            column.getColumn().setText(this.messages.ExternalizeStringHandler_Dialog_Key);
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Entry e = (Entry)element;
                    return e.key;
                }
            });
            column = new TableViewerColumn((TableViewer)this.viewer, 0);
            column.getColumn().setText(this.messages.ExternalizeStringHandler_Dialog_Value);
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Entry e = (Entry)element;
                    return e.value;
                }
            });
            ArrayList<Entry> entries = new ArrayList<Entry>();
            TreeIterator it = EcoreUtil.getAllContents(this.list);
            ArrayList<String> ids = new ArrayList<String>();
            ArrayList<EAttribute> translatedFeatures = new ArrayList<EAttribute>();
            translatedFeatures.add(UiPackageImpl.Literals.UI_LABEL__LABEL);
            translatedFeatures.add(UiPackageImpl.Literals.UI_LABEL__TOOLTIP);
            translatedFeatures.add(CommandsPackageImpl.Literals.COMMAND__COMMAND_NAME);
            translatedFeatures.add(CommandsPackageImpl.Literals.COMMAND__DESCRIPTION);
            translatedFeatures.add(CommandsPackageImpl.Literals.CATEGORY__NAME);
            translatedFeatures.add(CommandsPackageImpl.Literals.CATEGORY__DESCRIPTION);
            translatedFeatures.add(BasicPackageImpl.Literals.PART__DESCRIPTION);
            translatedFeatures.add(BasicPackageImpl.Literals.PART_DESCRIPTOR__DESCRIPTION);
            translatedFeatures.add(MenuPackageImpl.Literals.MENU_ELEMENT__MNEMONICS);
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                for (EAttribute eAttribute : o.eClass().getEAllAttributes()) {
                    String v;
                    if (!translatedFeatures.contains(eAttribute) || (v = (String)o.eGet((EStructuralFeature)eAttribute)) == null || !v.startsWith("%")) continue;
                    ids.add(v);
                }
            }
            Properties properties = this.getBaseProperties();
            for (Object e : properties.keySet()) {
                ids.add(e.toString());
            }
            it = EcoreUtil.getAllContents(this.list);
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                for (EAttribute a : eObject.eClass().getEAllAttributes()) {
                    String v;
                    if (!translatedFeatures.contains(a) || (v = (String)eObject.eGet((EStructuralFeature)a)) == null || v.trim().length() <= 0 || v.startsWith("%")) continue;
                    String id = ExternalizeStringHandler.findId(ids, String.valueOf(eObject.eClass().getName().toLowerCase()) + "." + a.getName().toLowerCase());
                    entries.add(new Entry(eObject, (EStructuralFeature)a, id, v));
                    ids.add(id);
                }
            }
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.setInput(entries);
            this.viewer.setAllChecked(true);
            boolean bl = true;
            while (var10_16 < this.viewer.getTable().getColumnCount()) {
                TableColumn c = this.viewer.getTable().getColumn((int)var10_16);
                c.pack();
                if (c.getWidth() < 120) {
                    c.setWidth(120);
                }
                ++var10_16;
            }
            return container;
        }

        protected void okPressed() {
            Object[] els = this.viewer.getCheckedElements();
            if (els.length > 0) {
                try {
                    Entry e;
                    Object o;
                    IFile f = this.getBasePropertyFile();
                    StringBuilder b = new StringBuilder(System.lineSeparator());
                    Object[] objectArray = els;
                    int n = els.length;
                    int n2 = 0;
                    while (n2 < n) {
                        o = objectArray[n2];
                        e = (Entry)o;
                        b.append(String.valueOf(e.key) + " = " + e.value + System.lineSeparator());
                        ++n2;
                    }
                    o = null;
                    Object var5_11 = null;
                    try (ByteArrayInputStream stream = new ByteArrayInputStream(b.toString().getBytes());){
                        if (f.exists()) {
                            f.appendContents((InputStream)stream, 2, (IProgressMonitor)new NullProgressMonitor());
                        } else {
                            this.createParent(f.getParent());
                            f.create((InputStream)stream, 2, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (Throwable throwable) {
                        if (o == null) {
                            o = throwable;
                        } else if (o != throwable) {
                            ((Throwable)o).addSuppressed(throwable);
                        }
                        throw o;
                    }
                    objectArray = els;
                    int n3 = els.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        o = objectArray[n4];
                        e = (Entry)o;
                        Command cmd = SetCommand.create((EditingDomain)this.resource.getEditingDomain(), (Object)e.object, (Object)e.feature, (Object)("%" + e.key));
                        if (cmd.canExecute()) {
                            this.resource.getEditingDomain().getCommandStack().execute(cmd);
                        }
                        ++n4;
                    }
                    super.okPressed();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private void createParent(IContainer container) throws CoreException {
            if (!container.exists()) {
                this.createParent(container.getParent());
                if (container instanceof IFolder) {
                    IFolder f = (IFolder)container;
                    f.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }

        private IFile getBasePropertyFile() throws CoreException, IOException {
            IFile file = this.project.getFile("META-INF/MANIFEST.MF");
            String base = ProjectOSGiTranslationProvider.extractBasenameFromManifest(file);
            return this.project.getFile(String.valueOf(base) + ".properties");
        }

        private Properties getBaseProperties() {
            Properties prop;
            block12: {
                prop = new Properties();
                try {
                    IFile f = this.getBasePropertyFile();
                    if (!f.exists()) break block12;
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (InputStream in = f.getContents();){
                        prop.load(in);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return prop;
        }
    }
}

