/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import java.util.Properties;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class CheckoutWizardPage
extends WizardPage {
    public CheckoutWizardPage(String title, String message) {
        super("wizardPage");
        this.setImageDescriptor(OM.getImageDescriptor("icons/wiz/new_checkout.gif"));
        this.setTitle(title);
        this.setMessage(message);
    }

    public final CheckoutWizard getWizard() {
        return (CheckoutWizard)super.getWizard();
    }

    public final void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout containerGridLayout = new GridLayout();
        container.setLayout((Layout)containerGridLayout);
        this.setControl((Control)container);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)this.createCompositeGridData());
        composite.setLayout(this.createCompositeLayout());
        this.createUI(composite);
        this.validate();
    }

    protected GridData createCompositeGridData() {
        return new GridData(4, 4, true, true);
    }

    protected Layout createCompositeLayout() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    protected abstract void createUI(Composite var1);

    protected void showNextPage() {
        if (this.isPageComplete()) {
            this.getContainer().showPage(this.getNextPage());
        }
    }

    protected void repositoryChanged(CDORepository repository) {
        CheckoutWizardPage nextPage = (CheckoutWizardPage)this.getNextPage();
        if (nextPage != null) {
            nextPage.repositoryChanged(repository);
        }
    }

    protected void typeChanged(String type) {
        CheckoutWizardPage nextPage = (CheckoutWizardPage)this.getNextPage();
        if (nextPage != null) {
            nextPage.typeChanged(type);
        }
    }

    protected void branchPointChanged(int branchID, long timeStamp) {
        CheckoutWizardPage nextPage = (CheckoutWizardPage)this.getNextPage();
        if (nextPage != null) {
            nextPage.branchPointChanged(branchID, timeStamp);
        }
    }

    protected void rootObjectChanged(CDOID rootID) {
        CheckoutWizardPage nextPage = (CheckoutWizardPage)this.getNextPage();
        if (nextPage != null) {
            nextPage.rootObjectChanged(rootID);
        }
    }

    protected void pageActivated() {
    }

    protected final void validate() {
        try {
            boolean valid = this.doValidate();
            this.setErrorMessage(null);
            this.setPageComplete(valid);
        }
        catch (ValidationProblem ex) {
            String message = ex.getMessage();
            this.setErrorMessage(message);
            this.setPageComplete(false);
        }
    }

    protected abstract boolean doValidate() throws ValidationProblem;

    protected abstract void fillProperties(Properties var1);

    protected static void log(String message) {
    }

    public static final class ValidationProblem
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ValidationProblem() {
        }

        public ValidationProblem(String message) {
            super(message);
        }
    }
}

