/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.lissome.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeStore;
import org.eclipse.emf.cdo.server.internal.lissome.bundle.OM;
import org.eclipse.emf.cdo.server.internal.lissome.db.Index;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class IndexReader
implements IDBConnectionProvider {
    private static final ContextTracer TRACER = new ContextTracer(OM.INDEX, IndexReader.class);
    protected Index index;
    protected CDOCommonRepository.IDGenerationLocation idGenerationLocation;
    protected boolean supportingAudits;
    protected boolean supportingBranches;
    protected Connection connection;
    protected PreparedStatement[] queryResourcesStatements = new PreparedStatement[4];
    protected PreparedStatement[] readRevisionStatements = new PreparedStatement[2];
    protected PreparedStatement readRevisionByVersionStatement;
    protected PreparedStatement[] handleRevisionsStatements = new PreparedStatement[32];
    protected PreparedStatement loadSubBranchesStatement;
    protected PreparedStatement loadBranchesStatement;
    protected PreparedStatement[] loadCommitInfosStatements = new PreparedStatement[8];

    public IndexReader(Index index) {
        this.index = index;
        this.idGenerationLocation = index.getIDGenerationLocation();
        this.supportingAudits = index.isSupportingAudits();
        this.supportingBranches = index.isSupportingBranches();
        this.connection = index.getConnection();
    }

    public Index getIndex() {
        return this.index;
    }

    public LissomeStore getStore() {
        return this.index.getStore();
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected int setParameters(PreparedStatement stmt, int column, CDOBranchPoint branchPoint) throws SQLException {
        long timeStamp;
        if (this.supportingBranches) {
            int branchID = branchPoint.getBranch().getID();
            stmt.setInt(++column, branchID);
        }
        if (this.supportingAudits && (timeStamp = branchPoint.getTimeStamp()) != 0L) {
            stmt.setLong(++column, timeStamp);
            stmt.setLong(++column, timeStamp);
        }
        return column;
    }

    public void queryResources(IStoreAccessor.QueryResourcesContext context) {
        if (TRACER.isEnabled()) {
            TRACER.format("queryResources: {0}", new Object[]{context});
        }
        ResultSet resultSet = null;
        try {
            try {
                boolean historical = context.getTimeStamp() != 0L;
                boolean exactMatch = context.exactMatch();
                int stmtIndex = (historical ? 0 : 1) + (exactMatch ? 0 : 2);
                PreparedStatement stmt = this.queryResourcesStatements[stmtIndex];
                if (stmt == null) {
                    String sql = this.index.objects.sqlQueryResources(historical, exactMatch);
                    this.queryResourcesStatements[stmtIndex] = stmt = this.connection.prepareStatement(sql);
                }
                int column = 0;
                CDOID folderID = context.getFolderID();
                this.index.setCDOID(stmt, ++column, folderID);
                String name = context.getName();
                if (name == null) {
                    name = CDOURIUtil.SEGMENT_SEPARATOR;
                } else if (!exactMatch) {
                    name = String.valueOf(name) + "%";
                }
                stmt.setString(++column, name);
                this.setParameters(stmt, column, (CDOBranchPoint)context);
                this.index.trace(TRACER, stmt);
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    this.index.trace(TRACER, resultSet);
                    CDOID id = this.index.getCDOID(resultSet, 1);
                    if (context.addResource(id)) {
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
    }

    protected RevisionInfo readRevision(PreparedStatement stmt) throws SQLException {
        ResultSet resultSet;
        block4: {
            RevisionInfo revisionInfo;
            resultSet = null;
            try {
                this.index.trace(TRACER, stmt);
                resultSet = stmt.executeQuery();
                if (!resultSet.next()) break block4;
                this.index.trace(TRACER, resultSet);
                RevisionInfo revisionInfo2 = new RevisionInfo();
                revisionInfo2.setPointer(resultSet.getLong(1));
                if (this.supportingAudits) {
                    revisionInfo2.setRevised(resultSet.getLong(2));
                } else {
                    revisionInfo2.setRevised(0L);
                }
                revisionInfo = revisionInfo2;
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                throw throwable;
            }
            DBUtil.close((ResultSet)resultSet);
            return revisionInfo;
        }
        DBUtil.close((ResultSet)resultSet);
        return null;
    }

    public RevisionInfo readRevision(CDOID id, CDOBranchPoint branchPoint) {
        if (TRACER.isEnabled()) {
            TRACER.format("readRevision: {0}, {1}", new Object[]{id, branchPoint});
        }
        try {
            boolean historical = branchPoint.getTimeStamp() != 0L;
            int stmtIndex = historical ? 0 : 1;
            PreparedStatement stmt = this.readRevisionStatements[stmtIndex];
            if (stmt == null) {
                String sql = this.index.objects.sqlReadRevision(historical);
                this.readRevisionStatements[stmtIndex] = stmt = this.connection.prepareStatement(sql);
            }
            int column = 0;
            this.index.setCDOID(stmt, ++column, id);
            this.setParameters(stmt, column, branchPoint);
            return this.readRevision(stmt);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public RevisionInfo readRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        if (TRACER.isEnabled()) {
            TRACER.format("readRevisionByVersion: {0}, {1}", new Object[]{id, branchVersion});
        }
        try {
            if (this.readRevisionByVersionStatement == null) {
                String sql = this.index.objects.sqlReadRevisionByVersion();
                this.readRevisionByVersionStatement = this.connection.prepareStatement(sql);
            }
            this.index.setCDOID(this.readRevisionByVersionStatement, 1, id);
            this.readRevisionByVersionStatement.setInt(2, branchVersion.getBranch().getID());
            this.readRevisionByVersionStatement.setInt(3, Math.abs(branchVersion.getVersion()));
            return this.readRevision(this.readRevisionByVersionStatement);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    public void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, RevisionInfo.Handler handler) {
        if (TRACER.isEnabled()) {
            TRACER.format("handleRevisions: {0}, {1}, {2}, {3}", new Object[]{eClass, branch, timeStamp, exactTime});
        }
        ResultSet resultSet = null;
        try {
            try {
                boolean withClass = eClass != null;
                boolean withBranch = branch != null && this.supportingBranches;
                boolean withTime = timeStamp != -1L;
                boolean historical = timeStamp != 0L;
                int stmtIndex = (withClass ? 0 : 1) + (withBranch ? 0 : 2) + (withTime ? 0 : 4) + (exactTime ? 0 : 8) + (historical ? 0 : 16);
                PreparedStatement stmt = this.handleRevisionsStatements[stmtIndex];
                if (stmt == null) {
                    String sql = this.index.objects.sqlHandleRevisions(withClass, withBranch, withTime, exactTime, historical);
                    this.handleRevisionsStatements[stmtIndex] = stmt = this.connection.prepareStatement(sql);
                }
                int column = 0;
                if (withClass) {
                    int cid = this.getStore().getMetaID(eClass);
                    stmt.setInt(++column, cid);
                }
                if (withBranch) {
                    int branchID = branch.getID();
                    stmt.setInt(++column, branchID);
                }
                if (withTime) {
                    if (exactTime) {
                        if (historical) {
                            stmt.setLong(++column, timeStamp);
                        }
                    } else if (historical) {
                        stmt.setLong(++column, timeStamp);
                        stmt.setLong(++column, timeStamp);
                    }
                }
                this.index.trace(TRACER, stmt);
                resultSet = stmt.executeQuery();
                RevisionInfo revisionInfo = new RevisionInfo();
                revisionInfo.setRevised(0L);
                while (resultSet.next()) {
                    this.index.trace(TRACER, resultSet);
                    CDOID id = this.index.getCDOID(resultSet, 1);
                    revisionInfo.setPointer(resultSet.getLong(2));
                    if (this.supportingAudits) {
                        revisionInfo.setRevised(resultSet.getLong(3));
                    }
                    handler.handleRevisionInfo(id, revisionInfo);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        throw new UnsupportedOperationException();
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        InternalCDOBranchManager.BranchLoader.SubBranchInfo[] subBranchInfoArray;
        if (TRACER.isEnabled()) {
            TRACER.format("loadSubBranches: {0}", new Object[]{branchID});
        }
        ResultSet resultSet = null;
        try {
            if (this.loadSubBranchesStatement == null) {
                String sql = this.index.branches.sqlLoadSubBranches();
                this.loadSubBranchesStatement = this.connection.prepareStatement(sql);
            }
            this.loadSubBranchesStatement.setInt(1, branchID);
            this.index.trace(TRACER, this.loadSubBranchesStatement);
            resultSet = this.loadSubBranchesStatement.executeQuery();
            ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo> result = new ArrayList<InternalCDOBranchManager.BranchLoader.SubBranchInfo>();
            while (resultSet.next()) {
                this.index.trace(TRACER, resultSet);
                int id = resultSet.getInt(1);
                String name = resultSet.getString(2);
                long baseTimeStamp = resultSet.getLong(3);
                result.add(new InternalCDOBranchManager.BranchLoader.SubBranchInfo(id, name, baseTimeStamp));
            }
            subBranchInfoArray = result.toArray(new InternalCDOBranchManager.BranchLoader.SubBranchInfo[result.size()]);
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        return subBranchInfoArray;
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler handler) {
        int n;
        if (TRACER.isEnabled()) {
            TRACER.format("loadBranches: {0}, {1}", new Object[]{startID, endID});
        }
        InternalCDOBranchManager branchManager = this.getStore().getRepository().getBranchManager();
        ResultSet resultSet = null;
        try {
            if (this.loadBranchesStatement == null) {
                String sql = this.index.branches.sqlLoadBranches();
                this.loadBranchesStatement = this.connection.prepareStatement(sql);
            }
            this.loadBranchesStatement.setInt(1, startID);
            this.loadBranchesStatement.setInt(2, endID);
            this.index.trace(TRACER, this.loadBranchesStatement);
            resultSet = this.loadBranchesStatement.executeQuery();
            int count = 0;
            while (resultSet.next()) {
                this.index.trace(TRACER, resultSet);
                int branchID = resultSet.getInt(1);
                String name = resultSet.getString(2);
                int baseBranchID = resultSet.getInt(3);
                long baseTimeStamp = resultSet.getLong(4);
                InternalCDOBranch branch = branchManager.getBranch(branchID, new InternalCDOBranchManager.BranchLoader.BranchInfo(name, baseBranchID, baseTimeStamp));
                handler.handleBranch((CDOBranch)branch);
                ++count;
            }
            n = count;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        return n;
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, PointerHandler handler) {
        if (TRACER.isEnabled()) {
            TRACER.format("loadCommitInfos: {0}, {1}, {2}", new Object[]{branch, startTime, endTime});
        }
        ResultSet resultSet = null;
        try {
            try {
                boolean withBranch = branch != null;
                boolean withStartTime = startTime != 0L;
                boolean withEndTime = endTime != 0L;
                int stmtIndex = (withBranch ? 0 : 1) + (withStartTime ? 0 : 2) + (withEndTime ? 0 : 4);
                PreparedStatement stmt = this.loadCommitInfosStatements[stmtIndex];
                if (stmt == null) {
                    String sql = this.index.commitInfos.sqlLoadCommitInfos(withBranch, withStartTime, withEndTime);
                    this.loadCommitInfosStatements[stmtIndex] = stmt = this.connection.prepareStatement(sql);
                }
                int column = 0;
                if (withBranch) {
                    int branchID = branch.getID();
                    stmt.setInt(++column, branchID);
                }
                if (withStartTime) {
                    stmt.setLong(++column, startTime);
                }
                if (withEndTime) {
                    stmt.setLong(++column, endTime);
                }
                this.index.trace(TRACER, stmt);
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    this.index.trace(TRACER, resultSet);
                    long pointer = resultSet.getLong(1);
                    handler.handlePointer(pointer);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
    }

    public static interface PointerHandler {
        public void handlePointer(long var1);
    }

    public static final class RevisionInfo {
        private long pointer;
        private long revised;

        public RevisionInfo(long pointer, long revised) {
            this.pointer = pointer;
            this.revised = revised;
        }

        public RevisionInfo() {
        }

        public long getPointer() {
            return this.pointer;
        }

        public void setPointer(long pointer) {
            this.pointer = pointer;
        }

        public long getRevised() {
            return this.revised;
        }

        public void setRevised(long revised) {
            this.revised = revised;
        }

        public String toString() {
            return "RevisionInfo[pointer=" + this.pointer + ", revised=" + this.revised + "]";
        }

        public static interface Handler {
            public void handleRevisionInfo(CDOID var1, RevisionInfo var2);
        }
    }
}

