/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.handlers;

import static org.eclipse.e4.core.contexts.ContextInjectionFactory.make;
import static org.eclipse.e4.ui.services.IServiceConstants.ACTIVE_SHELL;
import static org.eclipse.epp.internal.logging.aeri.ide.IDEWorkflow.TOPIC_RESCHEDULE_NOTIFCATION_LAST_LOG_EVENT;
import static org.eclipse.epp.internal.logging.aeri.ide.utils.Servers.copyOfUnconfigured;
import static org.eclipse.epp.internal.logging.aeri.ide.utils.Servers.isOnlyEclipseServer;
import static org.eclipse.epp.internal.logging.aeri.ide.utils.Servers.sort;

import java.util.List;

import javax.inject.Named;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.IDEWorkflow;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.ServersPage;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.SetupWizard;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.SetupWizardDialog;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.SystemSettingsPage;
import org.eclipse.swt.widgets.Shell;

@Creatable
public class OpenSystemSetupWizardHandler {

    @Execute
    public void execute(IEclipseContext context, @Named(IDEWorkflow.CTX_SERVERS) List<IServerDescriptor> servers,
            final IEventBroker broker) {

        // checkState(!systemStateSetupInProgress);

        IEclipseContext child = context.createChild("setup-wizard"); //$NON-NLS-1$
        List<IServerDescriptor> unconfigured = sort(copyOfUnconfigured(servers));
        child.set(IDEWorkflow.CTX_SERVERS, unconfigured);

        SetupWizard wizard = make(SetupWizard.class, child);
        SystemSettingsPage defaultsPage = make(SystemSettingsPage.class, child);
        wizard.addPage(defaultsPage);
        if (!isOnlyEclipseServer(servers)) {
            ServersPage serversPage = make(ServersPage.class, child);
            wizard.addPage(serversPage);
        }

        Shell parentShell = (Shell) child.get(ACTIVE_SHELL);
        SetupWizardDialog dialog = new SetupWizardDialog(parentShell, wizard) {

            @Override
            protected void finishPressed() {
                super.finishPressed();
                broker.post(TOPIC_RESCHEDULE_NOTIFCATION_LAST_LOG_EVENT, null);
            }
        };
        dialog.open();

    }

}
