/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.server.mars;

import static java.lang.String.valueOf;
import static org.apache.commons.lang3.StringUtils.defaultString;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.gson.annotations.SerializedName;

public class ServerResponse {
    public static final String KEYWORD_NEEDINFO = "needinfo"; //$NON-NLS-1$
    public static final String[] EMPTY_STRINGS = new String[0];
    public static final String FIXED = "FIXED"; //$NON-NLS-1$
    public static final String ASSIGNED = "ASSIGNED"; //$NON-NLS-1$
    public static final String NOT_ECLIPSE = "NOT_ECLIPSE"; //$NON-NLS-1$
    public static final String INVALID = "INVALID"; //$NON-NLS-1$
    public static final String WONTFIX = "WONTFIX"; //$NON-NLS-1$
    public static final String WORKSFORME = "WORKSFORME"; //$NON-NLS-1$
    public static final String MOVED = "MOVED"; //$NON-NLS-1$
    public static final String DUPLICATE = "DUPLICATE"; //$NON-NLS-1$
    public static final String UNKNOWN = "UNKNOWN"; //$NON-NLS-1$
    public static final String CLOSED = "CLOSED"; //$NON-NLS-1$
    public static final String RESOLVED = "RESOLVED"; //$NON-NLS-1$
    public static final String NEW = "NEW"; //$NON-NLS-1$
    public static final String UNCONFIRMED = "UNCONFIRMED"; //$NON-NLS-1$

    boolean created;

    @SerializedName("bugId")
    String submissionId;
    @SerializedName("bugUrl")
    String submissionUrl;

    @SerializedName("bugId2")
    int bugId;
    @SerializedName("bugUrl2")
    String bugUrl;

    /**
     * public enum Status { UNCONFIRMED, NEW, ASSIGNED, RESOLVED, CLOSED, UNKNOWN }
     *
     * public enum Resolution { UNSPECIFIED, FIXED, DUPLICATE, WONTFIX, WORKSFORME, INVALID, UNKNOWN }
     */
    String status;
    @SerializedName("resolved")
    String resolution;
    String information;
    String[] keywords;

    public boolean isCreated() {
        return created;
    }

    public Optional<String> getSubmissionId() {
        // special case when aeri did not process the event, the bug id is '0'
        if (Objects.equal(submissionId, "0")) { //$NON-NLS-1$
            return Optional.absent();
        }
        return Optional.fromNullable(submissionId);
    }

    public Optional<String> getSubmissionUrl() {
        return Optional.fromNullable(submissionUrl);
    }

    public boolean hasBug() {
        return bugId > 0;
    }

    public Optional<String> getBugId() {
        // special case when aeri did not process the event, the bug id is '0'
        if (Objects.equal(bugId, 0)) {
            return Optional.absent();
        }
        return Optional.fromNullable(valueOf(bugId));
    }

    public Optional<String> getBugUrl() {
        return Optional.fromNullable(submissionUrl);
    }

    public Optional<String> getInformation() {
        return Optional.fromNullable(information);
    }

    public Optional<String[]> getKeywords() {
        return Optional.fromNullable(keywords);
    }

    public Optional<String> getResolved() {
        return Optional.fromNullable(resolution);
    }

    public Optional<String> getStatus() {
        return Optional.fromNullable(status);
    }

    public boolean isProcessed() {
        // Previous versions used different defaults:
        switch (defaultString(submissionId)) {
        case "": //$NON-NLS-1$
        case "0": //$NON-NLS-1$
            return false;
        default:
        }
        switch (defaultString(status)) {
        case UNKNOWN:
            return false;
        default:
        }
        return true;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
