/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.browser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.IPath;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.browser.StreamConsumer;
import org.eclipse.osgi.util.NLS;

public class MozillaBrowserAdapter
implements IBrowser {
    protected static final int DELAY = 5000;
    protected long browserFullyOpenedAt = 0L;
    private BrowserThread lastBrowserThread = null;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean setLocationPending = false;
    private boolean setSizePending = false;
    protected String executable;
    protected String executableName;
    protected Thread uiThread = Thread.currentThread();

    MozillaBrowserAdapter(String executable, String executableName) {
        this.executable = executable;
        this.executableName = executableName;
    }

    @Override
    public void close() {
    }

    @Override
    public void displayURL(String url) {
        if (this.lastBrowserThread != null) {
            this.lastBrowserThread.exitRequested = true;
        }
        if (this.setLocationPending || this.setSizePending) {
            url = this.createPositioningURL(url);
        }
        this.lastBrowserThread = new BrowserThread(url);
        this.lastBrowserThread.start();
        this.setLocationPending = false;
        this.setSizePending = false;
    }

    @Override
    public boolean isCloseSupported() {
        return false;
    }

    @Override
    public boolean isSetLocationSupported() {
        return true;
    }

    @Override
    public boolean isSetSizeSupported() {
        return true;
    }

    @Override
    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
        this.setLocationPending = true;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.setSizePending = true;
    }

    private synchronized String createPositioningURL(String url) {
        IPath pluginPath = HelpBasePlugin.getDefault().getStateLocation();
        File outFile = pluginPath.append("mozillaPositon").append("position.html").toFile();
        try {
            outFile.getParentFile().mkdirs();
            Throwable throwable = null;
            Object var5_6 = null;
            try (PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8)), false);){
                writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
                writer.println("<html><head>");
                writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
                writer.print("<title></title><script type=\"text/javascript\">");
                if (this.setSizePending) {
                    writer.print("window.resizeTo(" + this.width + "," + this.height + ");");
                }
                if (this.setLocationPending) {
                    writer.print("window.moveTo(" + this.x + "," + this.y + ");");
                }
                writer.print("location.replace(\"" + url + "\");");
                writer.print("</script></head><body>");
                writer.print("<a href=\"" + url + "\">--&gt;</a>");
                writer.print("</body></html>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return "file://" + outFile.getAbsolutePath();
        }
        catch (IOException iOException) {
            return url;
        }
    }

    private class BrowserThread
    extends Thread {
        public boolean exitRequested = false;
        private String url;

        public BrowserThread(String urlName) {
            this.url = urlName;
        }

        private int openBrowser(String browserCmd) {
            int ret;
            block4: {
                Process pr = Runtime.getRuntime().exec(browserCmd);
                StreamConsumer outputs = new StreamConsumer(pr.getInputStream());
                outputs.start();
                StreamConsumer errors = new StreamConsumer(pr.getErrorStream());
                errors.start();
                pr.waitFor();
                ret = pr.exitValue();
                if (ret != 0 || !this.errorsInOutput(outputs, errors)) break block4;
                return -1;
            }
            try {
                return ret;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException e) {
                HelpBasePlugin.logError("Launching " + MozillaBrowserAdapter.this.executableName + " has failed.", e);
                String msg = NLS.bind((String)HelpBaseResources.MozillaBrowserAdapter_executeFailed, (Object)MozillaBrowserAdapter.this.executableName);
                BaseHelpSystem.getDefaultErrorUtil().displayError(msg, MozillaBrowserAdapter.this.uiThread);
                return 0;
            }
            return -1;
        }

        private boolean errorsInOutput(StreamConsumer outputs, StreamConsumer errors) {
            block4: {
                try {
                    outputs.join(1000L);
                    if (outputs.getLastLine() == null || !outputs.getLastLine().contains("No running window found") && !outputs.getLastLine().contains("not running on display")) break block4;
                    return true;
                }
                catch (InterruptedException interruptedException) {}
            }
            errors.join(1000L);
            if (errors.getLastLine() != null && (errors.getLastLine().contains("No running window found") || errors.getLastLine().contains("not running on display"))) {
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.waitForBrowser();
            if (this.exitRequested) {
                return;
            }
            if (this.openBrowser(String.valueOf(MozillaBrowserAdapter.this.executable) + " -remote openURL(" + this.url + ")") == 0) {
                return;
            }
            if (this.exitRequested) {
                return;
            }
            MozillaBrowserAdapter.this.browserFullyOpenedAt = System.currentTimeMillis() + 5000L;
            this.openBrowser(String.valueOf(MozillaBrowserAdapter.this.executable) + " " + this.url);
        }

        private void waitForBrowser() {
            while (System.currentTimeMillis() < MozillaBrowserAdapter.this.browserFullyOpenedAt) {
                try {
                    if (this.exitRequested) {
                        return;
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

