/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;

public class NativeSQLUtils {
    private static final int MAXLGT = 990;
    private static final String FAIL = "Operation failed due to database error.";

    private NativeSQLUtils() {
    }

    public static String getIdList(Collection<? extends IPersistentObject> objects) {
        if (objects.isEmpty()) {
            throw new IllegalArgumentException("Collection should not be empty.");
        }
        StringBuilder str = new StringBuilder("(");
        for (IPersistentObject iPersistentObject : objects) {
            str.append(iPersistentObject.getId());
            str.append(",");
        }
        str.deleteCharAt(str.length() - 1);
        str.append(")");
        return str.toString();
    }

    public static List<String> getSlicedIdLists(Collection<? extends IPersistentObject> objects) {
        if (objects.isEmpty()) {
            throw new IllegalArgumentException("Collection should not be empty.");
        }
        StringBuilder str = null;
        int num = 0;
        ArrayList<String> result = new ArrayList<String>();
        for (IPersistentObject iPersistentObject : objects) {
            if (num == 0) {
                str = new StringBuilder("(");
            }
            str.append(iPersistentObject.getId());
            str.append(",");
            if (++num != 990) continue;
            str.deleteCharAt(str.length() - 1);
            str.append(")");
            result.add(str.toString());
            num = 0;
        }
        if (num != 0) {
            str.deleteCharAt(str.length() - 1);
            str.append(")");
            result.add(str.toString());
        }
        return result;
    }

    public static void deleteFromTCTSTreeAFFECTS(EntityManager sess, Collection<INodePO> nodes, IProgressMonitor monitor) {
        for (INodePO node : nodes) {
            node.goingToBeDeleted(sess);
            NativeSQLUtils.removeNodeAFFECTS(sess, node);
            if (monitor == null) continue;
            monitor.worked(1);
        }
        for (String smallList : NativeSQLUtils.getSlicedIdLists(nodes)) {
            Query q = sess.createNativeQuery("delete from NODE where ID in " + smallList);
            q.executeUpdate();
        }
    }

    public static void removeNodeAFFECTS(EntityManager sess, INodePO node) {
        GeneralStorage.getInstance().getProject();
        int pos = -1;
        INodePO par = node.getParentNode();
        pos = par.indexOf(node);
        Query q1 = sess.createNativeQuery("update NODE set PARENT = null, IDX = null where ID = ?1");
        q1.setParameter(1, (Object)node.getId()).executeUpdate();
        Query q2 = sess.createNativeQuery("update NODE set IDX = IDX - 1 where PARENT = ?1 and IDX > ?2");
        q2.setParameter(1, (Object)par.getId());
        q2.setParameter(2, (Object)pos).executeUpdate();
        node.getParentNode().removeNode(node);
    }

    public static void addNodeAFFECTS(EntityManager sess, INodePO toAdd, IPersistentObject par) {
        GeneralStorage.getInstance().getProject();
        int pos = -1;
        pos = ((INodePO)par).getNodeListSize();
        Query q1 = sess.createNativeQuery("update NODE set PARENT = ?1, IDX = ?3 where ID = ?2");
        q1.setParameter(1, (Object)par.getId()).setParameter(2, (Object)toAdd.getId());
        int res = q1.setParameter(3, (Object)pos).executeUpdate();
        if (res != 1) {
            throw new PersistenceException(FAIL);
        }
        ((INodePO)par).addNode(toAdd);
    }

    public static void moveNode(EntityManager sess, INodePO toMove, IPersistentObject target) {
        NativeSQLUtils.removeNodeAFFECTS(sess, toMove);
        NativeSQLUtils.addNodeAFFECTS(sess, toMove, target);
    }

    public static Set<Long> getSpecTCParentIds(Collection<? extends INodePO> nodes, EntityManager sess) {
        int n;
        HashSet<Long> result = new HashSet<Long>();
        ArrayList<Long> extendingListOfIDs = new ArrayList<Long>();
        for (INodePO iNodePO : nodes) {
            extendingListOfIDs.add(iNodePO.getId());
        }
        boolean bl = false;
        while (n < extendingListOfIDs.size()) {
            int notYetHandled = Math.min(extendingListOfIDs.size(), (int)(n + 990));
            String listIDs = StringUtils.join(extendingListOfIDs.subList(n, notYetHandled), (String)",");
            Query q = sess.createNativeQuery("select CLASS_ID, ID, PARENT from NODE where ID in (" + listIDs + ")");
            List res = q.getResultList();
            for (Object[] next : res) {
                if (StringUtils.equals((String)((String)next[0]), (String)"S")) {
                    result.add((Long)next[1]);
                    continue;
                }
                extendingListOfIDs.add((Long)next[2]);
            }
            n = notYetHandled;
        }
        return result;
    }

    public static void removeOMCatAssoc(IObjectMappingCategoryPO omc) {
        EntityManager session = Persistor.instance().openSession();
        EntityTransaction transaction = session.getTransaction();
        transaction.begin();
        Query query = session.createNativeQuery("DELETE FROM SPEC_OM_CATEGORIES WHERE OMC_ID = ?1");
        query.setParameter(1, (Object)omc.getId());
        query.executeUpdate();
        transaction.commit();
    }

    public static List<BigDecimal> getSpecIdsforAssoc(EntityManager sess, Set<IObjectMappingCategoryPO> deletedOMC) {
        StringBuilder builder = new StringBuilder();
        Iterator<IObjectMappingCategoryPO> iterator = deletedOMC.iterator();
        while (iterator.hasNext()) {
            IObjectMappingCategoryPO cat = iterator.next();
            if (cat == null || cat.getId() == null || cat.getId() <= 0L) continue;
            builder.append(cat.getId());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        String string = builder.toString();
        if (StringUtils.isBlank((String)string)) {
            return new ArrayList<BigDecimal>();
        }
        Query query = sess.createNativeQuery("SELECT SPEC_ID FROM SPEC_OM_CATEGORIES WHERE OMC_ID in( ?1 )");
        query.setParameter(1, (Object)string);
        List resultList = query.getResultList();
        return resultList;
    }
}

