/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.inspector.ui.provider.sourceprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.agent.AutRegistrationEvent;
import org.eclipse.jubula.client.core.agent.IAutRegistrationListener;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.sourceprovider.AbstractJBSourceProvider;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectableAutSourceProvider
extends AbstractJBSourceProvider
implements IAutRegistrationListener,
DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IProjectStateListener {
    public static final String INSPECTABLE_AUTS = "org.eclipse.jubula.client.inspector.ui.variable.inspectableAuts";

    public InspectableAutSourceProvider() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
        ded.addProjectStateListener((DataEventDispatcher.IProjectStateListener)this);
        AutAgentRegistration.getInstance().addListener((IAutRegistrationListener)this);
    }

    public void dispose() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this);
        ded.removeProjectStateListener((DataEventDispatcher.IProjectStateListener)this);
        AutAgentRegistration.getInstance().removeListener((IAutRegistrationListener)this);
    }

    public Map<String, Object> getCurrentState() {
        HashMap<String, Object> currentState = new HashMap<String, Object>();
        ArrayList<AutIdentifier> inspectableAuts = new ArrayList<AutIdentifier>();
        currentState.put(INSPECTABLE_AUTS, inspectableAuts);
        Map autToId = AutAgentRegistration.getRunningAuts((IProjectPO)GeneralStorage.getInstance().getProject(), (Collection)AutAgentRegistration.getInstance().getRegisteredAuts());
        for (IAUTMainPO aut : autToId.keySet()) {
            if (!this.isInspectable(aut)) continue;
            for (AutIdentifier autId : (Collection)autToId.get(aut)) {
                inspectableAuts.add(autId);
            }
        }
        return currentState;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{INSPECTABLE_AUTS};
    }

    private boolean isInspectable(IAUTMainPO aut) {
        return "com.bredexsw.guidancer.RcpToolkitPlugin".equals(aut.getToolkit());
    }

    public void handleAutRegistration(AutRegistrationEvent event) {
        this.gdFireSourceChanged(0, this.getCurrentState());
    }

    public void handleProjectLoaded() {
        this.gdFireSourceChanged(0, this.getCurrentState());
    }

    public void handleProjectStateChanged(DataEventDispatcher.ProjectState state) {
        if (DataEventDispatcher.ProjectState.prop_modified.equals((Object)state)) {
            this.gdFireSourceChanged(0, this.getCurrentState());
        }
    }
}

