/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.properties.dialogs.contexts;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.checks.contexts.BaseContext;
import org.eclipse.jubula.client.teststyle.i18n.Messages;
import org.eclipse.jubula.client.teststyle.properties.dialogs.DlgUtils;
import org.eclipse.jubula.client.teststyle.properties.dialogs.contexts.provider.ContextCheckProvider;
import org.eclipse.jubula.client.teststyle.properties.dialogs.contexts.provider.ContextContentProvider;
import org.eclipse.jubula.client.teststyle.properties.dialogs.contexts.provider.ContextLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class EditContextDialog
extends TrayDialog {
    public static final int CON_STL = 68352;
    public static final String CONT_TITLE = Messages.EditContextDialogTitle;
    private static final String NAME_COLUMN = Messages.EditContextColumnName;
    private static final String DESCRIPTION_COLUMN = Messages.EditContextColumnDescription;
    private static final int NAME_COLUMN_WIDTH = 200;
    private static final int DESCRIPTION_COLUMN_WIDTH = 100;
    private static final String TESTSTYLE_PROPERTY_PAGE_EDIT_CONTEXT = "org.eclipse.jubula.client.ua.help.testStylePropertyPageEditContextContextId";
    private BaseCheck m_check;
    private Map<BaseContext, Boolean> m_contexts;
    private CheckboxTableViewer m_tablView;

    public EditContextDialog(Shell parentShell, BaseCheck check) {
        super(parentShell);
        this.setShellStyle(67696);
        this.m_check = check;
        this.m_contexts = new TreeMap<BaseContext, Boolean>(check.getContexts());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = DlgUtils.createFillComposite(parent);
        this.createTable(composite);
        this.setTableEvents();
        this.getShell().setText(CONT_TITLE);
        this.setHelpAvailable(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), TESTSTYLE_PROPERTY_PAGE_EDIT_CONTEXT);
        return super.createDialogArea(parent);
    }

    private void createTable(Composite parent) {
        this.m_tablView = CheckboxTableViewer.newCheckList((Composite)parent, (int)68352);
        this.m_tablView.setColumnProperties(new String[]{NAME_COLUMN, DESCRIPTION_COLUMN});
        Table table = this.m_tablView.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setWidth(200);
        nameColumn.setText(NAME_COLUMN);
        TableColumn descriptionColumn = new TableColumn(table, 0);
        descriptionColumn.setWidth(100);
        descriptionColumn.setText(DESCRIPTION_COLUMN);
        this.m_tablView.setContentProvider((IContentProvider)new ContextContentProvider());
        this.m_tablView.setCheckStateProvider((ICheckStateProvider)new ContextCheckProvider(this.m_contexts));
        this.m_tablView.setLabelProvider((IBaseLabelProvider)new ContextLabelProvider());
        this.m_tablView.setInput(this.m_contexts);
        nameColumn.pack();
        nameColumn.setWidth(nameColumn.getWidth() + 5);
        descriptionColumn.pack();
        descriptionColumn.setWidth(descriptionColumn.getWidth() + 5);
    }

    public void setTableEvents() {
        this.m_tablView.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                BaseContext context = (BaseContext)event.getElement();
                EditContextDialog.this.m_contexts.put(context, event.getChecked());
                EditContextDialog.this.m_tablView.refresh();
            }
        });
    }

    protected void okPressed() {
        super.okPressed();
        this.m_check.setContexts(this.m_contexts);
    }
}

