/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers;

import org.apache.commons.lang.Validate;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jubula.client.ui.rcp.utils.ContentAssistUtil;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedText;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ContentAssistCellEditor
extends TextCellEditor {
    private boolean m_popupOpen = false;

    public ContentAssistCellEditor(Composite parent, IContentProposalProvider contentProposalProvider, CheckedText.IValidator validator, int proposalAcceptanceStyle) {
        super(parent);
        Validate.notNull((Object)this.text);
        this.enableValidation(validator);
        this.enableContentProposal(contentProposalProvider, proposalAcceptanceStyle);
    }

    private void enableValidation(CheckedText.IValidator validator) {
        if (validator != null) {
            this.text.addVerifyListener((VerifyListener)new CheckedText.ValidationListener(validator));
        }
    }

    private void enableContentProposal(IContentProposalProvider contentProposalProvider, int proposalAcceptanceStyle) {
        if (contentProposalProvider != null) {
            ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), contentProposalProvider, ContentAssistUtil.getTriggerKeyStroke(), ContentAssistUtil.getTriggerChars());
            contentProposalAdapter.setFilterStyle(1);
            contentProposalAdapter.setProposalAcceptanceStyle(proposalAcceptanceStyle);
            contentProposalAdapter.addContentProposalListener(new IContentProposalListener2(){

                public void proposalPopupClosed(ContentProposalAdapter adapter) {
                    ContentAssistCellEditor.this.m_popupOpen = false;
                }

                public void proposalPopupOpened(ContentProposalAdapter adapter) {
                    ContentAssistCellEditor.this.m_popupOpen = true;
                }
            });
        }
    }

    protected void focusLost() {
        if (!this.m_popupOpen) {
            super.focusLost();
        }
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }
}

