/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.handlers.project.ExportFileOperation;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportDialog {
    private static Logger log = LoggerFactory.getLogger(ExportDialog.class);

    private ExportDialog() {
    }

    public static final void showExportDialog(Shell activeShell) {
        FileDialog fileDialog = new FileDialog(activeShell, 73728);
        fileDialog.setText(Messages.ActionBuilderSaveAs);
        String[] filters = new String[]{"*.jub"};
        fileDialog.setFilterExtensions(filters);
        fileDialog.setFilterPath(Utils.getLastDirPath());
        StringBuilder sb = new StringBuilder(GeneralStorage.getInstance().getProject().getDisplayName());
        fileDialog.setFileName(sb.toString());
        String fileNameTemp = fileDialog.open();
        if (fileNameTemp == null) {
            return;
        }
        String extension = filters[fileDialog.getFilterIndex()].replace("*", "");
        File file = new File(fileNameTemp = fileNameTemp.endsWith(extension) ? fileNameTemp : String.valueOf(fileNameTemp) + extension);
        if (file.exists()) {
            MessageBox mb = new MessageBox(fileDialog.getParent(), 200);
            mb.setText(Messages.ExportFileActionConfirmOverwriteTitle);
            mb.setMessage(NLS.bind((String)Messages.ExportFileActionConfirmOverwrite, (Object)fileNameTemp));
            if (mb.open() == 128) {
                return;
            }
        }
        Plugin.startLongRunning(Messages.ExportFileActionWaitWhileExporting);
        String fileName = fileNameTemp;
        Utils.storeLastDirPath(fileDialog.getFilterPath());
        Plugin console = Plugin.getDefault();
        ExportFileOperation op = new ExportFileOperation(fileName, console);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)op);
        }
        catch (InvocationTargetException ite) {
            log.error(ite.getLocalizedMessage(), ite.getCause());
        }
        catch (InterruptedException interruptedException) {}
    }
}

