/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.utils.generator;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jubula.tools.internal.exception.ConfigXmlException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.utils.ClassPathHacker;
import org.eclipse.jubula.tools.internal.utils.generator.ToolkitConfig;
import org.eclipse.jubula.tools.internal.utils.generator.ToolkitPluginParser;
import org.eclipse.jubula.tools.internal.utils.generator.XStreamGenerator;
import org.eclipse.jubula.tools.internal.xml.businessmodell.AbstractComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractComponentBuilder {
    private static Logger log = LoggerFactory.getLogger(AbstractComponentBuilder.class);
    private CompSystem m_compSystem;
    private XStream m_xStream = XStreamGenerator.createXStream();

    public AbstractComponentBuilder() {
    }

    public AbstractComponentBuilder(ToolkitConfig config) {
        this.initCompSystem(config);
    }

    protected CompSystem createCompSystem(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String string = "";
        String line = null;
        try {
            do {
                if ((line = reader.readLine()) == null) continue;
                string = String.valueOf(string) + line;
            } while (line != null);
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        string = string.replaceAll("[\r\n]+", " ");
        string = string.replace("\t", " ");
        string = string.replaceAll("[^\\S\\r\\n]+", " ");
        string = string.replaceAll(">\\s", ">");
        string = string.replaceAll("\\s<", "<");
        CompSystem compSystem = (CompSystem)this.m_xStream.fromXML(string);
        return compSystem;
    }

    protected void addToolkitToCompSystem(CompSystem compSystem) {
        if (this.m_compSystem == null) {
            this.m_compSystem = compSystem;
        } else {
            this.m_compSystem.merge(compSystem);
        }
    }

    protected void postProcess() throws ConfigXmlException {
        this.m_compSystem.postProcess();
    }

    private void initCompSystem(ToolkitConfig config) {
        List<String> names = config.getToolkitNames();
        for (String configName : names) {
            try {
                String xmlPath = config.getXMLPath(configName);
                URL xmlURL = new File(xmlPath).toURI().toURL();
                InputStream inputStream = this.getInputStream(xmlURL);
                CompSystem compSystem = this.createCompSystem(inputStream);
                String xmlPluginPath = config.getPluginXMLPath(configName);
                ToolkitPluginParser parser = new ToolkitPluginParser(xmlPluginPath, compSystem);
                ToolkitDescriptor descr = parser.getToolkitDescriptor();
                compSystem.addToolkitPluginDescriptor(descr.getToolkitID(), descr);
                this.setToolkitDescriptorToComponents(compSystem, descr);
                this.addToolkitToCompSystem(compSystem);
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
            String resourceBundlePath = config.getResourceBundlePath(configName);
            try {
                ClassPathHacker.addFile(new File(resourceBundlePath).getCanonicalFile());
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                e.printStackTrace();
            }
            String resourceBundleFQN = config.getResourceBundleFQN(configName);
            ResourceBundle bundle = ResourceBundle.getBundle(resourceBundleFQN);
            CompSystemI18n.addResourceBundle(bundle);
        }
        this.postProcess();
    }

    protected InputStream getInputStream(URL absoluteFileURL) throws IOException {
        return new BufferedInputStream(absoluteFileURL.openStream());
    }

    protected CompSystem getCompSystem() {
        return this.m_compSystem;
    }

    protected void setToolkitDescriptorToComponents(CompSystem compSystem, ToolkitDescriptor pluginDescr) {
        ArrayList<AbstractComponent> components = new ArrayList<AbstractComponent>();
        List<Component> tmpComponents = compSystem.getAbstractComponents();
        if (tmpComponents != null) {
            components.addAll(tmpComponents);
        }
        if ((tmpComponents = compSystem.getConcreteComponents()) != null) {
            components.addAll(tmpComponents);
        }
        for (Component component : components) {
            component.setToolkitDesriptor(pluginDescr);
        }
    }
}

