/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.jonas;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.libra.framework.jonas.IJonasVersionHandler;
import org.eclipse.libra.framework.jonas.Messages;
import org.eclipse.libra.framework.jonas.internal.util.ZipUtil;
import org.eclipse.wst.server.core.IModule;

public class JonasHandler
implements IJonasVersionHandler {
    final int BUFFER = 2048;

    public IStatus verifyInstallPath(IPath location) {
        File f = location.append("conf/jonas.properties").toFile();
        if (f == null || !f.exists()) {
            return new Status(4, "org.eclipse.libra.framework.jonas", 0, Messages.warningCantReadConfig, null);
        }
        File[] conf = f.listFiles();
        if (conf != null) {
            int size = conf.length;
            int i = 0;
            while (i < size) {
                if (!f.canRead()) {
                    return new Status(2, "org.eclipse.libra.framework.jonas", 0, Messages.warningCantReadConfig, null);
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    public String getFrameworkClass() {
        return "org.ow2.jonas.commands.admin.ClientAdmin";
    }

    public List getFrameworkClasspath(IPath installPath, IPath configPath) {
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        IPath binPath = installPath.append("/lib/bootstrap");
        if (binPath.toFile().exists()) {
            IPath path = binPath.append("/felix-launcher.jar");
            cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
            IPath path2 = binPath.append("/jonas-commands.jar");
            cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path2));
            IPath path3 = binPath.append("/jonas-version.jar");
            cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path3));
        }
        return cp;
    }

    public String[] getFrameworkProgramArguments(IPath configPath, boolean debug, boolean starting) {
        return new String[]{"-start"};
    }

    public String[] getExcludedFrameworkProgramArguments(boolean debug, boolean starting) {
        return null;
    }

    public String[] getFrameworkVMArguments(IPath installPath, IPath configPath, IPath deployPath, boolean isTestEnv) {
        String configPathStr = deployPath.makeAbsolute().toOSString();
        String cfr_ignored_0 = "-Dfelix.config.properties=file:" + configPathStr + "/config.properties";
        String jonasRoot = installPath.toOSString();
        String jonasBase = deployPath.append("/jonasbase").toOSString();
        return new String[]{"-Djonas.root=" + jonasRoot, "-Djonas.base=" + jonasBase, "-Dipojo.log.level=ERROR", "-Djava.security.policy=" + jonasBase + "/conf/java.policy", "-Djava.security.auth.login.config=" + jonasBase + "/conf/jaas.config", "-Djava.endorsed.dirs=" + jonasRoot + "/lib/endorsed", "-Dorg.omg.CORBA.ORBClass=org.jacorb.orb.ORB", "-Dorg.omg.CORBA.ORBSingletonClass=org.jacorb.orb.ORBSingleton", "-Dorg.omg.PortableInterceptor.ORBInitializerClass.standard_init=org.jacorb.orb.standardInterceptors.IORInterceptorInitializer", "-Dcom.sun.CORBA.ORBDynamicStubFactoryFactoryClass=com.sun.corba.se.impl.presentation.rmi.StubFactoryFactoryStaticImpl", "-Djavax.xml.soap.SOAPConnectionFactory=com.sun.xml.messaging.saaj.client.p2p.HttpSOAPConnectionFactory", "-Djavax.xml.soap.SOAPFactory=com.sun.xml.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl", "-Djavax.xml.soap.MetaFactory=com.sun.xml.messaging.saaj.soap.SAAJMetaFactoryImpl", "-Djavax.xml.soap.MessageFactory=com.sun.xml.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl", "-Djonas.felix.tui.enabled=true", "-Djonas.cache.clean=true"};
    }

    public IStatus canAddModule(IModule module) {
        String id = module.getModuleType().getId();
        if ("osgi.bundle".equals(id)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.libra.framework.jonas", 0, Messages.errorNotBundle, null);
    }

    public IStatus prepareFrameworkInstanceDirectory(IPath baseDir) {
        return Status.OK_STATUS;
    }

    public IStatus prepareDeployDirectory(IPath deployPath) {
        return Status.OK_STATUS;
    }

    public boolean supportsServeModulesWithoutPublish() {
        return true;
    }

    public void prepareFrameworkConfigurationFile(IPath configPath, String workspaceBundles, String kernelBundles) {
    }

    public void createJonasBase(IPath location, String instanceDirectory) {
        try {
            ZipUtil.unzip(this.getClass().getResourceAsStream("/jonasbase.zip"), new File(instanceDirectory));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

