/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.libra.warproducts.core.IWARProduct;
import org.eclipse.libra.warproducts.ui.Messages;
import org.eclipse.libra.warproducts.ui.editor.GeneralInfoSection;
import org.eclipse.libra.warproducts.ui.editor.WARProductExportAction;
import org.eclipse.libra.warproducts.ui.validation.IValidationListener;
import org.eclipse.libra.warproducts.ui.validation.WARProductValidateAction;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.ILauncherFormPageHelper;
import org.eclipse.pde.internal.ui.editor.LaunchShortcutOverviewPage;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDELauncherFormEditor;
import org.eclipse.pde.internal.ui.editor.product.ProductLauncherFormPageHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class OverviewPage
extends LaunchShortcutOverviewPage {
    public static final String PAGE_ID = "overview";
    private ProductLauncherFormPageHelper launcherHelper;

    public OverviewPage(PDELauncherFormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.OverviewPage_title);
    }

    protected String getHelpResource() {
        return "org.eclipse.libra.warproducts.help.warproduct_editor_overview";
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(PDEUIMessages.OverviewPage_title);
        PDELabelProvider labelProvider = PDEPlugin.getDefault().getLabelProvider();
        ImageDescriptor description = PDEPluginImages.DESC_PRODUCT_DEFINITION;
        form.setImage(labelProvider.get(description));
        this.fillBody(managedForm, toolkit);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        String contextId = "org.eclipse.libra.warproducts.help.warproduct_editor_overview";
        helpSystem.setHelp((Control)form.getBody(), contextId);
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout((boolean)true, (int)2));
        GeneralInfoSection generalSection = new GeneralInfoSection((PDEFormPage)this, body);
        managedForm.addPart((IFormPart)generalSection);
        if (this.getModel().isEditable()) {
            this.createExportingSection(body, toolkit);
        }
    }

    private void createExportingSection(Composite parent, FormToolkit toolkit) {
        String title = PDEUIMessages.OverviewPage_exportingTitle;
        Section section = this.createStaticSection(toolkit, parent, title);
        String text = Messages.EditorExportSection;
        section.setClient((Control)this.createClient((Composite)section, text, toolkit));
    }

    public void linkActivated(HyperlinkEvent linkEvent) {
        String href = (String)linkEvent.getHref();
        if (href.equals("action.export")) {
            if (this.getPDEEditor().isDirty()) {
                this.getPDEEditor().doSave(null);
            }
            new WARProductExportAction(this.getPDEEditor()).run();
        } else if (href.equals("action.configuration")) {
            String pageId = "plugin-dependencies";
            this.getEditor().setActivePage(pageId);
        } else if (href.equals("action.validate")) {
            IProductModel model = (IProductModel)this.getPDEEditor().getAggregateModel();
            WARProductValidateAction validationAction = new WARProductValidateAction((IWARProduct)model.getProduct());
            IValidationListener listener = (IValidationListener)this.getPDEEditor();
            validationAction.addValidationListener(listener);
            validationAction.run();
        } else {
            super.linkActivated(linkEvent);
        }
    }

    protected ILauncherFormPageHelper getLauncherHelper() {
        if (this.launcherHelper == null) {
            this.launcherHelper = new ProductLauncherFormPageHelper(this.getPDELauncherEditor());
        }
        return this.launcherHelper;
    }

    protected short getIndent() {
        return 35;
    }
}

