/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerExit;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerContainerState;
import org.eclipse.linuxtools.docker.ui.launch.Messages;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;

public class ContainerCommandProcess
extends Process {
    private String containerId;
    private IDockerConnection connection;
    private String imageName;
    private PipedInputStream stdout;
    private PipedInputStream stderr;
    private OutputStream stdin;
    private PipedInputStream pipedStdinIn;
    private final Set<Closeable> toClose = new HashSet<Closeable>();
    private Map<String, String> remoteVolumes;
    private boolean keepContainer;
    private Thread thread;
    private Closeable token;
    private boolean containerRemoved;
    private int exitValue;
    private boolean done;
    private boolean threadDone;
    private boolean threadStarted;

    public ContainerCommandProcess(IDockerConnection connection, String imageName, String containerId, OutputStream outputStream, Map<String, String> remoteVolumes, boolean keepContainer) {
        this.connection = connection;
        this.imageName = imageName;
        this.containerId = containerId;
        this.remoteVolumes = remoteVolumes;
        this.stdout = new PipedInputStream();
        this.stderr = new PipedInputStream();
        this.keepContainer = keepContainer;
        IDockerContainerInfo info = connection.getContainerInfo(containerId);
        if (info.config().openStdin()) {
            try {
                final PipedOutputStream pipedStdinOut = new PipedOutputStream();
                this.toClose.add(pipedStdinOut);
                this.pipedStdinIn = new PipedInputStream(pipedStdinOut);
                this.toClose.add(this.pipedStdinIn);
                this.stdin = new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        pipedStdinOut.write(b);
                    }
                };
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            this.stdin = new ByteArrayOutputStream();
        }
        Runnable logContainer = () -> {
            PipedOutputStream pipedOut = null;
            PipedOutputStream pipedErr = null;
            try {
                try {
                    Throwable throwable = null;
                    Object var8_11 = null;
                    try {
                        PipedOutputStream pipedStdout = new PipedOutputStream(this.stdout);
                        try {
                            block41: {
                                PipedOutputStream pipedStderr = new PipedOutputStream(this.stderr);
                                try {
                                    block40: {
                                        Closeable inputToken = ((DockerConnection)connection).getOperationToken();
                                        try {
                                            try (Closeable token = ((DockerConnection)connection).getOperationToken();){
                                                this.token = token;
                                                pipedOut = pipedStdout;
                                                pipedErr = pipedStderr;
                                                connection.startContainer(containerId, outputStream);
                                                this.threadStarted = true;
                                                if (info.config().openStdin()) {
                                                    IDockerContainerState state = connection.getContainerInfo(containerId).state();
                                                    do {
                                                        if (state.running().booleanValue() || state.finishDate() != null && !state.finishDate().before(state.startDate())) continue;
                                                        Thread.sleep(50L);
                                                    } while (!(state = info.state()).running().booleanValue() && (state.finishDate() == null || state.finishDate().before(state.startDate())));
                                                    Thread.sleep(50L);
                                                    state = connection.getContainerInfo(containerId).state();
                                                    if (state.running().booleanValue()) {
                                                        ((DockerConnection)connection).attachCommand(inputToken, containerId, (InputStream)this.pipedStdinIn, null, false);
                                                        ((DockerConnection)connection).attachContainerOutput(token, containerId, (OutputStream)pipedStdout, (OutputStream)pipedStderr);
                                                    }
                                                } else {
                                                    ((DockerConnection)connection).attachLog(token, containerId, (OutputStream)pipedStdout, (OutputStream)pipedStderr);
                                                }
                                                pipedStdout.flush();
                                                pipedStderr.flush();
                                            }
                                            if (inputToken == null) break block40;
                                        }
                                        catch (Throwable throwable2) {
                                            if (throwable == null) {
                                                throwable = throwable2;
                                            } else if (throwable != throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            if (inputToken == null) throw throwable;
                                            inputToken.close();
                                            throw throwable;
                                        }
                                        inputToken.close();
                                    }
                                    if (pipedStderr == null) break block41;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    if (pipedStderr == null) throw throwable;
                                    pipedStderr.close();
                                    throw throwable;
                                }
                                pipedStderr.close();
                            }
                            if (pipedStdout == null) return;
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            if (pipedStdout == null) throw throwable;
                            pipedStdout.close();
                            throw throwable;
                        }
                        pipedStdout.close();
                        return;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                            throw throwable;
                        }
                        if (throwable == throwable5) throw throwable;
                        throwable.addSuppressed(throwable5);
                        throw throwable;
                    }
                }
                catch (IOException | InterruptedException | DockerException e) {
                    if (pipedOut != null) {
                        try {
                            pipedOut.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (pipedErr != null) {
                        try {
                            pipedErr.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.threadDone = true;
                    return;
                }
                catch (Exception exception) {
                    this.threadDone = true;
                    return;
                }
            }
            finally {
                this.threadDone = true;
            }
        };
        this.thread = new Thread(logContainer);
        this.thread.start();
        while (!this.threadStarted && !this.threadDone) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void destroy() {
        try {
            try {
                this.connection.killContainer(this.containerId);
                Thread.sleep(1000L);
            }
            catch (InterruptedException | DockerException throwable) {
                // empty catch block
            }
            int count = 0;
            while (this.thread.isAlive() && count++ < 10) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.stdout.close();
            this.stderr.close();
            this.stdin.close();
            this.token.close();
            for (Closeable close : this.toClose) {
                close.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int exitValue() {
        IDockerContainerState state;
        if (this.containerRemoved) {
            return this.exitValue;
        }
        IDockerContainerInfo info = this.connection.getContainerInfo(this.containerId);
        if (info != null && (state = info.state()) != null) {
            if (state.paused().booleanValue() || state.restarting().booleanValue() || state.running().booleanValue()) {
                throw new IllegalThreadStateException(LaunchMessages.getFormattedString("ContainerNotFinished.msg", this.containerId));
            }
            return state.exitCode();
        }
        if (this.containerRemoved) {
            return this.exitValue;
        }
        return -1;
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        if (this.done) {
            return 0;
        }
        try {
            if (!this.threadDone) {
                while (!this.threadStarted) {
                    Thread.sleep(200L);
                }
            }
            IDockerContainerExit exit = this.connection.waitForContainer(this.containerId);
            this.done = true;
            int i = 0;
            while (!this.threadDone && i++ < 10) {
                Thread.sleep(500L);
            }
            if (!this.threadDone) {
                try {
                    this.stdout.close();
                    this.stderr.close();
                    this.stdin.close();
                    this.token.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!this.containerRemoved) {
                this.connection.stopLoggingThread(this.containerId);
            }
            if (!((DockerConnection)this.connection).isLocal() && this.remoteVolumes != null && !this.remoteVolumes.isEmpty()) {
                CopyVolumesFromImageJob job = new CopyVolumesFromImageJob(this.connection, this.containerId, this.remoteVolumes);
                job.schedule();
                job.join();
                this.remoteVolumes.clear();
            }
            if (!this.containerRemoved && !this.keepContainer) {
                this.exitValue = this.exitValue();
                this.containerRemoved = true;
                this.connection.removeContainer(this.containerId);
            }
            return exit.statusCode();
        }
        catch (DockerException e) {
            return -1;
        }
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin;
    }

    private static Set<PosixFilePermission> toPerms(int mode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((mode & 0x100) != 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    public String getImage() {
        return this.imageName;
    }

    static /* synthetic */ String access$0(ContainerCommandProcess containerCommandProcess) {
        return containerCommandProcess.imageName;
    }

    static /* synthetic */ Set access$1(int n) {
        return ContainerCommandProcess.toPerms(n);
    }

    private class BlockingInputStream
    extends InputStream {
        private InputStream in;

        public BlockingInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }
    }

    private class CopyVolumesFromImageJob
    extends Job {
        private static final String COPY_VOLUMES_FROM_JOB_TITLE = "ContainerLaunch.copyVolumesFromJob.title";
        private static final String COPY_VOLUMES_FROM_DESC = "ContainerLaunch.copyVolumesFromJob.desc";
        private static final String COPY_VOLUMES_FROM_TASK = "ContainerLaunch.copyVolumesFromJob.task";
        private final Map<String, String> remoteVolumes;
        private final IDockerConnection connection;
        private final String containerId;

        public CopyVolumesFromImageJob(IDockerConnection connection, String containerId, Map<String, String> remoteVolumes) {
            super(Messages.getString(COPY_VOLUMES_FROM_JOB_TITLE));
            this.remoteVolumes = remoteVolumes;
            this.connection = connection;
            this.containerId = containerId;
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 31[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

