/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.structures;

import java.io.IOException;
import org.eclipse.linuxtools.internal.systemtap.ui.consolelog.structures.Messages;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.listeners.IGobblerListener;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class ConsoleStreamDaemon
implements IGobblerListener {
    protected String output;
    protected IOConsoleOutputStream ioConsole;
    private boolean disposed;

    public ConsoleStreamDaemon(ScriptConsole console) {
        if (console != null) {
            this.ioConsole = console.newOutputStream();
        }
        this.disposed = false;
    }

    protected void pushData() {
        if (this.ioConsole != null) {
            try {
                this.ioConsole.write(this.output);
            }
            catch (IOException e) {
                ExceptionErrorDialog.openError((String)Messages.ConsoleStreamDaemon_errorWritingToConsole, (Exception)e);
            }
        }
    }

    public void handleDataEvent(String line) {
        this.output = line;
        this.pushData();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.output = null;
            this.ioConsole = null;
        }
    }
}

