/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

public class TimingData {
    private static final double DIVISOR = 1.0E9;
    private final long start = System.nanoTime();
    private long finishedLoading;
    private long finishedMatch;
    private long finishedApply;
    private long finishedPostApply;
    private long finishedRecursive;
    private long finished;

    public long getFinishedLoading() {
        return this.finishedLoading - this.start;
    }

    public long getFinishedMatch() {
        return this.finishedMatch - this.start;
    }

    public long getFinishedApply() {
        return this.finishedApply - this.start;
    }

    public long getFinishedPostApply() {
        return this.finishedPostApply - this.start;
    }

    public long getFinishedRecursive() {
        return this.finishedRecursive - this.start;
    }

    public long getFinished() {
        return this.finished - this.start;
    }

    protected void setFinishedLoading(long finishedLoading) {
        this.finishedLoading = finishedLoading;
    }

    protected void setFinishedMatch(long finishedMatch) {
        this.finishedMatch = finishedMatch;
    }

    protected void setFinishedApply(long finishedApply) {
        this.finishedApply = finishedApply;
    }

    protected void setFinishedPostApply(long finishedPostApply) {
        this.finishedPostApply = finishedPostApply;
    }

    protected void setFinishedRecursive(long finishedRecursive) {
        this.finishedRecursive = finishedRecursive;
    }

    protected void setFinished(long finished) {
        this.finished = finished;
    }

    public void finishLoading() {
        this.finishedLoading = System.nanoTime();
    }

    public void finishMatch() {
        this.finishedMatch = System.nanoTime();
    }

    public void finishApply() {
        this.finishedApply = System.nanoTime();
    }

    public void finishPostApply() {
        this.finishedPostApply = System.nanoTime();
    }

    public void finishRecursive() {
        this.finishedRecursive = System.nanoTime();
    }

    public void finish() {
        this.finished = System.nanoTime();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Timing data:\n");
        sb.append(String.format("\tLoading finished at %f seconds (duration: %f seconds)\n", (double)this.getFinishedLoading() / 1.0E9, (double)this.getFinishedLoading() / 1.0E9));
        sb.append(String.format("\tMatching finished at %f seconds (duration: %f seconds)\n", (double)this.getFinishedMatch() / 1.0E9, (double)(this.getFinishedMatch() - this.getFinishedLoading()) / 1.0E9));
        sb.append(String.format("\tApplying finished at %f seconds (duration: %f seconds)\n", (double)this.getFinishedApply() / 1.0E9, (double)(this.getFinishedApply() - this.getFinishedMatch()) / 1.0E9));
        sb.append(String.format("\tPost-applying finished at %f seconds (duration: %f seconds)\n", (double)this.getFinishedPostApply() / 1.0E9, (double)(this.getFinishedPostApply() - this.getFinishedApply()) / 1.0E9));
        sb.append(String.format("\tRecursive stage finished at %f seconds (duration: %f seconds)\n", (double)this.getFinishedRecursive() / 1.0E9, (double)(this.getFinishedRecursive() - this.getFinishedPostApply()) / 1.0E9));
        sb.append(String.format("\tExecution finished at %f seconds (duration: %f seconds)\n", (double)this.getFinished() / 1.0E9, (double)(this.getFinished() - this.getFinishedPostApply()) / 1.0E9));
        return sb.toString();
    }
}

