/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof.acquire;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.acquire.JmapVmInfo;

public class LocalJavaProcessesUtils {
    static List<JmapVmInfo> getLocalVMsUsingJPS(File jdkHome) throws SnapshotException {
        String jps = "jps";
        if (jdkHome != null && jdkHome.exists()) {
            jps = String.valueOf(jdkHome.getAbsolutePath()) + File.separator + "bin" + File.separator + "jps";
        }
        StreamCollector error = null;
        StreamCollector output = null;
        Process p = null;
        try {
            String encoding = System.getProperty("file.encoding", "UTF-8");
            p = Runtime.getRuntime().exec(new String[]{jps, "-ml", "-J-Dfile.encoding=" + encoding});
            error = new StreamCollector(p.getErrorStream(), encoding);
            error.start();
            output = new StreamCollector(p.getInputStream(), encoding);
            output.start();
            int exitVal = p.waitFor();
            if (exitVal != 0) {
                return null;
            }
            ArrayList<JmapVmInfo> vms = new ArrayList<JmapVmInfo>();
            int jpsProcesses = 0;
            StringTokenizer tok = new StringTokenizer(output.buf.toString(), "\r\n");
            block7: while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                JmapVmInfo info = LocalJavaProcessesUtils.parseJPSLine(token);
                String jpssig = "Jps -ml";
                if (info != null) {
                    vms.add(info);
                    if (info.getDescription().contains(jpssig)) {
                        ++jpsProcesses;
                    }
                }
                if (jpsProcesses != true) continue;
                for (JmapVmInfo inf : vms) {
                    if (!info.getDescription().contains(jpssig)) continue;
                    info.setHeapDumpEnabled(false);
                    continue block7;
                }
            }
            ArrayList<JmapVmInfo> arrayList = vms;
            return arrayList;
        }
        catch (IOException ioe) {
            throw new SnapshotException(Messages.LocalJavaProcessesUtils_ErrorGettingProcessListJPS, (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new SnapshotException(Messages.LocalJavaProcessesUtils_ErrorGettingProcessListJPS, (Throwable)ie);
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    private static JmapVmInfo parseJPSLine(String line) {
        int firstSpaceIdx = line.indexOf(32);
        if (firstSpaceIdx == -1) {
            return null;
        }
        int pid = Integer.parseInt(line.substring(0, firstSpaceIdx));
        String description = line.substring(firstSpaceIdx + 1);
        return new JmapVmInfo(pid, description, true, null, null);
    }

    static class StreamCollector
    extends Thread {
        InputStream is;
        StringBuilder buf;
        String encoding;

        StreamCollector(InputStream is) {
            this(is, System.getProperty("file.encoding", "UTF-8"));
        }

        StreamCollector(InputStream is, String encoding) {
            this.is = is;
            this.buf = new StringBuilder();
            this.encoding = encoding;
        }

        @Override
        public void run() {
            block13: {
                InputStreamReader isr = null;
                try {
                    try {
                        isr = new InputStreamReader(this.is, this.encoding);
                        BufferedReader br = new BufferedReader(isr);
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            this.buf.append(line).append("\r\n");
                        }
                    }
                    catch (IOException ioe) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.LocalJavaProcessesUtils_ErrorGettingProcesses, ioe);
                        if (isr == null) break block13;
                        try {
                            isr.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }
}

