/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.emf.ui.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.facet.util.emf.ui.internal.Activator;
import org.eclipse.modisco.facet.util.emf.ui.internal.Messages;
import org.eclipse.modisco.facet.util.emf.ui.internal.dialogs.SaveAsDialog;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IOkDialog;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IOkDialogFactory;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IWithResultDialogCallback;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public final class ResourceUiUtils {
    private ResourceUiUtils() {
    }

    public static IOkDialog save(Resource resource, Shell shell) {
        IOkDialog dialog = null;
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (MalformedURLException malformedURLException) {
            ResourceUiUtils.openSaveAsDialog(resource, shell);
        }
        catch (IOException e) {
            IDialogCallback<Void> callBack = new IDialogCallback<Void>(){

                public void committed(Void result2) {
                }
            };
            dialog = ResourceUiUtils.savingFailed(e, shell, callBack);
        }
        return dialog;
    }

    private static IOkDialog savingFailed(IOException exception, Shell shell, IDialogCallback<Void> callBack) {
        Logger.logError((Throwable)exception, (Plugin)Activator.getDefault());
        String errorMessage = NLS.bind((String)Messages.ResourceUiUtils_TheResourceSavingFailed, (Object)exception.getMessage());
        return IOkDialogFactory.DEFAULT.openErrorDialog(shell, Messages.ResourceUiUtils_SavingFailed, errorMessage, callBack);
    }

    public static SaveAsDialog openSaveAsDialog(final Resource resource, final Shell shell) {
        IWithResultDialogCallback<String> callBack = new IWithResultDialogCallback<String>(){

            public void commited(String result) {
                ResourceUiUtils.saveAs(resource, result, shell);
            }

            public void canceled(String result) {
            }
        };
        SaveAsDialog dialog = new SaveAsDialog(shell, resource.getURI().toString(), callBack);
        dialog.open();
        return dialog;
    }

    protected static IOkDialog saveAs(final Resource resource, String result, final Shell shell) {
        IOkDialog dialog = null;
        try {
            resource.setURI(URI.createURI((String)result));
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            IDialogCallback<Void> callBack = new IDialogCallback<Void>(){

                public void committed(Void result2) {
                    ResourceUiUtils.openSaveAsDialog(resource, shell);
                }
            };
            dialog = ResourceUiUtils.savingFailed(e, shell, callBack);
        }
        return dialog;
    }
}

