/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.pr;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.NoSuchPageException;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.GitHubException;
import org.eclipse.mylyn.internal.github.core.issue.IssueConnector;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestConnector;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.github.ui.HttpRepositorySettingsPage;
import org.eclipse.mylyn.internal.github.ui.pr.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class PullRequestRepositorySettingsPage
extends HttpRepositorySettingsPage {
    private boolean syncLabel = true;
    private boolean editingUrl = false;

    public PullRequestRepositorySettingsPage(TaskRepository taskRepository) {
        super(Messages.PullRequestRepositorySettingsPage_Title, Messages.PullRequestRepositorySettingsPage_Description, taskRepository);
    }

    public String getConnectorKind() {
        return "githubPullRequests";
    }

    protected void syncRepositoryLabel() {
        String url;
        RepositoryId repo;
        if (this.syncLabel && (repo = GitHub.getRepository((String)(url = this.serverUrlCombo.getText()))) != null) {
            this.repositoryLabelEditor.setStringValue(PullRequestConnector.getRepositoryLabel((IRepositoryIdProvider)repo));
        }
    }

    protected void createAdditionalControls(Composite parent) {
        if (this.serverUrlCombo.getText().length() == 0) {
            String fullUrlText = "http://github.com/user/repository";
            this.serverUrlCombo.setText(fullUrlText);
            this.serverUrlCombo.setFocus();
            this.serverUrlCombo.setSelection(new Point("http://github.com".length() + 1, fullUrlText.length()));
            this.syncRepositoryLabel();
            this.serverUrlCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PullRequestRepositorySettingsPage.this.editingUrl = true;
                    try {
                        PullRequestRepositorySettingsPage.this.syncRepositoryLabel();
                    }
                    finally {
                        PullRequestRepositorySettingsPage.this.editingUrl = false;
                    }
                }
            });
            this.repositoryLabelEditor.getTextControl(this.compositeContainer).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!PullRequestRepositorySettingsPage.this.editingUrl) {
                        PullRequestRepositorySettingsPage.this.syncLabel = false;
                    }
                }
            });
        } else {
            this.serverUrlCombo.setText(PullRequestConnector.stripPulls((String)this.repository.getRepositoryUrl()));
        }
        if (this.getRepository() == null) {
            this.setAnonymous(false);
        }
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(final TaskRepository repository) {
        AbstractRepositorySettingsPage.Validator validator = new AbstractRepositorySettingsPage.Validator(this){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(Messages.PullRequestRepositorySettingsPage_TaskValidating, 100);
                monitor.subTask(Messages.PullRequestRepositorySettingsPage_TaskContacting);
                try {
                    try {
                        GitHubClient client = IssueConnector.createClient((TaskRepository)repository);
                        PullRequestService service = new PullRequestService(client);
                        RepositoryId repo = GitHub.getRepository((String)repository.getRepositoryUrl());
                        monitor.worked(50);
                        service.pagePullRequests((IRepositoryIdProvider)repo, "open", 1).next();
                    }
                    catch (NoSuchPageException e) {
                        String message = MessageFormat.format(Messages.PullRequestRepositorySettingsPage_ValidateError, GitHubException.wrap((IOException)e.getCause()).getLocalizedMessage());
                        this.setStatus(GitHubUi.createErrorStatus(message));
                        monitor.done();
                        return;
                    }
                }
                finally {
                    monitor.done();
                }
                this.setStatus((IStatus)new Status(0, "org.eclipse.mylyn.github.ui", Messages.PullRequestRepositorySettingsPage_ValidateSuccess));
            }
        };
        return validator;
    }

    public void applyTo(TaskRepository repository) {
        repository.setProperty("category", "org.eclipse.mylyn.category.review");
        super.applyTo(repository);
    }

    public String getRepositoryUrl() {
        return PullRequestConnector.appendPulls((String)super.getRepositoryUrl());
    }
}

