/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.delta.IDBSchemaDelta;
import org.eclipse.net4j.internal.db.DBConnection;
import org.eclipse.net4j.internal.db.DBPreparedStatement;
import org.eclipse.net4j.internal.db.DBResultSet;
import org.eclipse.net4j.internal.db.DBSchemaTransaction;
import org.eclipse.net4j.internal.db.ddl.delta.DBSchemaDelta;
import org.eclipse.net4j.spi.db.DBAdapter;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.SetContainer;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.security.IUserAware;

public final class DBDatabase
extends SetContainer<IDBConnection>
implements IDBDatabase {
    private static final long TIMEOUT_SCHEMA_ACCESS = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.internal.db.DBDatabase.TIMEOUT_SCHEMA_ACCESS", 15000L);
    private static final boolean DEBUG_SCHEMA_ACCESS = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.internal.db.DBDatabase.DEBUG_SCHEMA_ACCESS");
    private DBAdapter adapter;
    private IDBConnectionProvider connectionProvider;
    private int statementCacheCapacity = 200;
    private IDBSchema schema;
    private final LinkedList<SchemaAccess> schemaAccessQueue = new LinkedList();
    private int schemaWriters;

    public DBDatabase(final DBAdapter adapter, IDBConnectionProvider connectionProvider, final String schemaName, final boolean fixNullableIndexColumns) {
        super(IDBConnection.class);
        this.adapter = adapter;
        this.connectionProvider = connectionProvider;
        this.schema = DBUtil.execute(this, new DBUtil.RunnableWithConnection<IDBSchema>(){

            @Override
            public IDBSchema run(Connection connection) throws SQLException {
                return DBUtil.readSchema(adapter, connection, schemaName, fixNullableIndexColumns);
            }
        });
        ((InternalDBSchema)this.schema).lock();
        this.activate();
    }

    public String getUserID() {
        if (this.connectionProvider instanceof IUserAware) {
            return ((IUserAware)this.connectionProvider).getUserID();
        }
        return null;
    }

    @Override
    public DBAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public IDBSchema getSchema() {
        return this.schema;
    }

    @Override
    public DBSchemaTransaction openSchemaTransaction() {
        return this.openSchemaTransaction(null);
    }

    @Override
    public DBSchemaTransaction openSchemaTransaction(IDBConnection connection) {
        DBSchemaTransaction schemaTransaction = new DBSchemaTransaction(this);
        schemaTransaction.setConnection((DBConnection)connection);
        return schemaTransaction;
    }

    public void closeSchemaTransaction(DBSchemaDelta delta) {
        if (delta == null || delta.isEmpty()) {
            return;
        }
        try {
            this.beginSchemaAccess(true);
            IDBConnection[] iDBConnectionArray = this.getConnections();
            int n = iDBConnectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDBConnection transaction = iDBConnectionArray[n2];
                ((DBConnection)transaction).invalidateStatementCache();
                ++n2;
            }
            this.fireEvent(new SchemaChangedEventImpl(this, delta));
        }
        finally {
            this.endSchemaAccess();
        }
    }

    @Override
    @Deprecated
    public DBSchemaTransaction getSchemaTransaction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSchema(IDBDatabase.RunnableWithSchema runnable) {
        try (DBSchemaTransaction schemaTransaction = this.openSchemaTransaction();){
            IDBSchema workingCopy = schemaTransaction.getWorkingCopy();
            runnable.run(workingCopy);
            schemaTransaction.commit();
        }
    }

    @Override
    public DBConnection getConnection() {
        Connection delegate = this.connectionProvider.getConnection();
        if (delegate == null) {
            throw new DBException("No connection from connection provider: " + this.connectionProvider);
        }
        delegate = this.adapter.modifyConnection(delegate);
        DBConnection connection = new DBConnection(this, delegate);
        this.addElement(connection);
        return connection;
    }

    public void closeConnection(DBConnection connection) {
        this.removeElement(connection);
    }

    @Override
    public IDBConnection[] getConnections() {
        return (IDBConnection[])this.getElements();
    }

    @Override
    public int getStatementCacheCapacity() {
        return this.statementCacheCapacity;
    }

    @Override
    public void setStatementCacheCapacity(int statementCacheCapacity) {
        this.statementCacheCapacity = statementCacheCapacity;
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    public void close() {
        this.deactivate();
    }

    protected void doDeactivate() throws Exception {
        IDBConnection[] iDBConnectionArray = this.getConnections();
        int n = iDBConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDBConnection connection = iDBConnectionArray[n2];
            connection.close();
            ++n2;
        }
        super.doDeactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginSchemaAccess(boolean write) {
        if (DEBUG_SCHEMA_ACCESS) {
            try {
                throw new Exception("Begin " + (write ? "write" : "read") + " schema access: " + this.schema.getName());
            }
            catch (Exception ex) {
                ex.printStackTrace(IOUtil.OUT());
            }
        }
        SchemaAccess schemaAccess = null;
        LinkedList<SchemaAccess> linkedList = this.schemaAccessQueue;
        synchronized (linkedList) {
            if (write) {
                schemaAccess = new WriteSchemaAccess();
                this.schemaAccessQueue.addLast(schemaAccess);
                ++this.schemaWriters;
            } else {
                if (this.schemaWriters == 0 && !this.schemaAccessQueue.isEmpty()) {
                    schemaAccess = this.schemaAccessQueue.getFirst();
                    if (schemaAccess instanceof ReadSchemaAccess) {
                        ReadSchemaAccess readSchemaAccess = (ReadSchemaAccess)schemaAccess;
                        readSchemaAccess.incrementReaders();
                    } else {
                        schemaAccess = null;
                    }
                }
                if (schemaAccess == null) {
                    schemaAccess = new ReadSchemaAccess();
                    this.schemaAccessQueue.addLast(schemaAccess);
                }
            }
        }
        long end = System.currentTimeMillis() + TIMEOUT_SCHEMA_ACCESS;
        do {
            LinkedList<SchemaAccess> linkedList2 = this.schemaAccessQueue;
            synchronized (linkedList2) {
                if (this.schemaAccessQueue.getFirst() == schemaAccess) {
                    if (write) {
                        --this.schemaWriters;
                    }
                    return;
                }
                try {
                    this.schemaAccessQueue.wait(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        } while (System.currentTimeMillis() < end);
        throw new TimeoutRuntimeException("Schema " + this.schema.getName() + " could not be locked for " + (write ? "write" : "read") + " access within " + TIMEOUT_SCHEMA_ACCESS + " milliseconds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSchemaAccess() {
        if (DEBUG_SCHEMA_ACCESS) {
            try {
                throw new Exception("End schema access: " + this.schema.getName());
            }
            catch (Exception ex) {
                ex.printStackTrace(IOUtil.OUT());
            }
        }
        LinkedList<SchemaAccess> linkedList = this.schemaAccessQueue;
        synchronized (linkedList) {
            ReadSchemaAccess readSchemaAccess;
            SchemaAccess schemaAccess = this.schemaAccessQueue.getFirst();
            if (schemaAccess instanceof ReadSchemaAccess && (readSchemaAccess = (ReadSchemaAccess)schemaAccess).decrementReaders()) {
                return;
            }
            this.schemaAccessQueue.removeFirst();
            this.schemaAccessQueue.notifyAll();
        }
    }

    public String convertString(DBPreparedStatement preparedStatement, int parameterIndex, String value) {
        return this.adapter.convertString(preparedStatement, parameterIndex, value);
    }

    public String convertString(DBResultSet resultSet, int columnIndex, String value) {
        return this.adapter.convertString((ResultSet)resultSet, columnIndex, value);
    }

    public String convertString(DBResultSet resultSet, String columnLabel, String value) {
        return this.adapter.convertString((ResultSet)resultSet, columnLabel, value);
    }

    private static final class ReadSchemaAccess
    implements SchemaAccess {
        private int readers = 1;

        private ReadSchemaAccess() {
        }

        public void incrementReaders() {
            ++this.readers;
        }

        public boolean decrementReaders() {
            return --this.readers > 0;
        }

        public String toString() {
            return "READERS[" + this.readers + "]";
        }
    }

    private static interface SchemaAccess {
    }

    private static final class SchemaChangedEventImpl
    extends Event
    implements IDBDatabase.SchemaChangedEvent {
        private static final long serialVersionUID = 1L;
        private final IDBSchemaDelta schemaDelta;

        public SchemaChangedEventImpl(DBDatabase database, IDBSchemaDelta schemaDelta) {
            super((INotifier)database);
            this.schemaDelta = schemaDelta;
        }

        @Override
        public IDBDatabase getSource() {
            return (IDBDatabase)super.getSource();
        }

        @Override
        public IDBSchemaDelta getSchemaDelta() {
            return this.schemaDelta;
        }
    }

    private static final class WriteSchemaAccess
    implements SchemaAccess {
        private WriteSchemaAccess() {
        }

        public String toString() {
            return "WRITER";
        }
    }
}

