/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.edit.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.NullElementType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.edit.internal.ElementEditService;
import org.eclipse.papyrus.infra.services.edit.messages.Messages;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditServiceProvider;

public class ElementEditServiceProvider
implements IElementEditServiceProvider {
    protected IClientContext sharedClientContext;

    public ElementEditServiceProvider(IClientContext clientContext) {
        this.sharedClientContext = clientContext;
    }

    @Override
    public IElementEditService getEditService(Object objectToEdit) throws ServiceException {
        if (!(objectToEdit instanceof EObject || objectToEdit instanceof EClass || objectToEdit instanceof IElementType)) {
            throw new ServiceException(Messages.ElementEditServiceProvider_UnexpectedParameterType);
        }
        Object elementType = null;
        if (objectToEdit instanceof EClass) {
            elementType = ElementTypeRegistry.getInstance().getElementType((EClass)objectToEdit, this.sharedClientContext);
        } else if (objectToEdit instanceof EObject) {
            EObject eObject = (EObject)objectToEdit;
            elementType = this.isReadOnly(eObject) ? NullElementType.getInstance() : ElementTypeRegistry.getInstance().getElementType(eObject, this.sharedClientContext);
        } else if (objectToEdit instanceof IElementType && this.sharedClientContext.includes((IElementType)objectToEdit)) {
            elementType = (IElementType)objectToEdit;
        }
        if (elementType == null) {
            throw new ServiceException(NLS.bind((String)Messages.ElementEditServiceProvider_NoIElementTypeFound, (Object)objectToEdit));
        }
        return new ElementEditService((IElementType)elementType, this.sharedClientContext);
    }

    private boolean isReadOnly(EObject object) {
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)object);
        return EMFHelper.isReadOnly((EObject)object, (EditingDomain)domain) && !EMFHelper.canMakeWritable((EObject)object, (EditingDomain)domain);
    }

    @Override
    public List<IElementEditService> getContainedTypeEditServices(EObject eContainer, EReference reference) throws ServiceException {
        ArrayList<IElementEditService> services = new ArrayList<IElementEditService>();
        IElementType[] iElementTypeArray = ElementTypeRegistry.getInstance().getContainedTypes(eContainer, reference, this.sharedClientContext);
        int n = iElementTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElementType type = iElementTypeArray[n2];
            services.add(new ElementEditService(type, this.sharedClientContext));
            ++n2;
        }
        return services;
    }

    @Override
    public boolean isKnownElementType(String id) {
        boolean isKnown = false;
        if (ElementTypeRegistry.getInstance().getType(id) != null) {
            isKnown = this.sharedClientContext.includes(ElementTypeRegistry.getInstance().getType(id));
        }
        return isKnown;
    }
}

