/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.figures;

import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineShape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.BehaviorPropertyNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.figures.WrappedLabel;
import org.eclipse.papyrus.uml.diagram.activity.locator.LinkedBehaviorLocator;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CornerBentFigure;
import org.eclipse.swt.graphics.Color;

public class LinkAndCornerBentWithTextFigure
extends CornerBentFigure {
    private static final Color THIS_BACK = new Color(null, 248, 249, 214);
    private WrappedLabel fCornerBentContent;
    private PolylineShape fLinkToBehaviorProperty;

    public LinkAndCornerBentWithTextFigure() {
        this.setBackgroundColor(THIS_BACK);
        this.createContents();
    }

    private void createContents() {
        this.fCornerBentContent = new WrappedLabel();
        this.add((IFigure)this.fCornerBentContent);
        this.fLinkToBehaviorProperty = new PolylineShape();
        this.fLinkToBehaviorProperty.setLineWidth(1);
        this.fLinkToBehaviorProperty.setLineStyle(2);
        this.add((IFigure)this.fLinkToBehaviorProperty);
        this.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                LinkAndCornerBentWithTextFigure.this.refreshLinkToBehaviorProperty();
            }
        });
    }

    public IBorderItemLocator getBorderItemLocator() {
        IFigure parentFigure = this.getParent();
        if (parentFigure != null && parentFigure.getLayoutManager() != null) {
            Object constraint = parentFigure.getLayoutManager().getConstraint((IFigure)this);
            return (IBorderItemLocator)constraint;
        }
        return null;
    }

    private void refreshLinkToBehaviorProperty() {
        if (this.getLinkToBehaviorProperty().getParent() == null) {
            this.getParent().add((IFigure)this.getLinkToBehaviorProperty());
        }
        if (!(this.getBorderItemLocator() instanceof LinkedBehaviorLocator)) {
            return;
        }
        if (this.getParent() != null && this.getParent().getParent() instanceof BorderedNodeFigure) {
            BorderedNodeFigure gParent = (BorderedNodeFigure)this.getParent().getParent();
            Rectangle parentBounds = gParent.getHandleBounds().getCopy();
            Point parentCenter = parentBounds.getCenter();
            IFigure rect = gParent.getMainFigure();
            LinkedBehaviorLocator linkedBehaviorLocator = (LinkedBehaviorLocator)this.getBorderItemLocator();
            Rectangle currentBounds = linkedBehaviorLocator.getCorrectItemLocation((IFigure)this);
            Point end = BehaviorPropertyNodeEditPolicy.getAppropriateBorderPoint(parentCenter, currentBounds);
            PointList polygonalBounds = new PointList(4);
            polygonalBounds.addPoint(rect.getBounds().getTopLeft());
            polygonalBounds.addPoint(rect.getBounds().getTopRight());
            polygonalBounds.addPoint(rect.getBounds().getBottomRight());
            polygonalBounds.addPoint(rect.getBounds().getBottomLeft());
            Point start = BehaviorPropertyNodeEditPolicy.getIntersectionPoint(polygonalBounds, parentCenter, end);
            if (start == null) {
                start = parentCenter;
            }
            Rectangle linkBounds = new Rectangle(start, end);
            this.getLinkToBehaviorProperty().setStart(start.translate(linkBounds.getLocation().getNegated()));
            this.getLinkToBehaviorProperty().setEnd(end.translate(linkBounds.getLocation().getNegated()));
            this.getLinkToBehaviorProperty().setBounds(linkBounds);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getLinkToBehaviorProperty().setVisible(visible);
    }

    public WrappedLabel getCornerBentContent() {
        return this.fCornerBentContent;
    }

    public PolylineShape getLinkToBehaviorProperty() {
        return this.fLinkToBehaviorProperty;
    }
}

