/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;

public class SwimlanesCompartmentLayout
extends ConstrainedToolbarLayout {
    private Map<IFigure, Integer> constraints;

    public void layout(IFigure parent) {
        IFigure child;
        if (!parent.isVisible()) {
            return;
        }
        List<IFigure> children = this.getChildren(parent);
        int numChildren = children.size();
        Rectangle clientArea = this.transposer.t(parent.getClientArea());
        int x = clientArea.x;
        int y = clientArea.y;
        int availableHeight = clientArea.height;
        Dimension[] prefSizes = new Dimension[numChildren];
        Dimension[] minSizes = new Dimension[numChildren];
        Dimension[] maxSizes = new Dimension[numChildren];
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            hHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).height;
        } else {
            wHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).width;
        }
        int totalHeight = 0;
        int totalMinHeight = 0;
        double totalMaxHeight = 0.0;
        int prefMinSumHeight = 0;
        double prefMaxSumHeight = 0.0;
        int i = 0;
        while (i < numChildren) {
            child = children.get(i);
            prefSizes[i] = this.transposer.t(child.getPreferredSize(wHint, hHint));
            minSizes[i] = this.transposer.t(new Dimension(0, 0));
            maxSizes[i] = this.transposer.t(child.getMaximumSize());
            if (this.getConstraint(child) != null) {
                int prefHeight = this.getConstraint(child);
                prefHeight = Math.max(prefHeight, minSizes[i].height);
                prefSizes[i].height = prefHeight = Math.min(prefHeight, maxSizes[i].height);
            }
            totalHeight += prefSizes[i].height;
            totalMinHeight += minSizes[i].height;
            totalMaxHeight += (double)maxSizes[i].height;
            ++i;
        }
        int spacing = this.getSpacing();
        prefMinSumHeight = (totalHeight += (numChildren - 1) * spacing) - (totalMinHeight += (numChildren - 1) * spacing);
        prefMaxSumHeight = (totalMaxHeight += (double)((numChildren - 1) * spacing)) - (double)totalHeight;
        int amntShrinkHeight = totalHeight - Math.max(availableHeight, totalMinHeight);
        int maxY = y + availableHeight;
        int i2 = 0;
        while (i2 < numChildren) {
            int amntShrinkCurrentHeight = 0;
            int prefHeight = prefSizes[i2].height;
            int minHeight = minSizes[i2].height;
            int maxHeight = maxSizes[i2].height;
            int prefWidth = prefSizes[i2].width;
            int minWidth = minSizes[i2].width;
            int maxWidth = maxSizes[i2].width;
            Rectangle newBounds = new Rectangle(x, y, prefWidth, prefHeight);
            child = children.get(i2);
            if (this.getStretchMajorAxis()) {
                if (amntShrinkHeight > 0 && prefMinSumHeight != 0) {
                    amntShrinkCurrentHeight = (int)((long)(prefHeight - minHeight) * (long)amntShrinkHeight / (long)prefMinSumHeight);
                } else if (amntShrinkHeight < 0 && totalHeight != 0) {
                    amntShrinkCurrentHeight = (int)((double)(maxHeight - prefHeight) / prefMaxSumHeight * (double)amntShrinkHeight);
                }
            }
            int width = Math.min(prefWidth, maxWidth);
            if (this.isStretchMinorAxis()) {
                width = maxWidth;
            }
            newBounds.width = width = Math.max(minWidth, Math.min(clientArea.width, width));
            int adjust = clientArea.width - width;
            switch (this.getMinorAlignment()) {
                case 1: {
                    adjust = 0;
                    break;
                }
                case 0: {
                    adjust /= 2;
                    break;
                }
            }
            newBounds.x += adjust;
            if (newBounds.height - amntShrinkCurrentHeight > maxHeight) {
                amntShrinkCurrentHeight = newBounds.height - maxHeight;
            }
            if (amntShrinkHeight < 0 && i2 == numChildren - 1) {
                amntShrinkCurrentHeight = amntShrinkHeight;
            } else if (amntShrinkHeight > 0 && y > maxY - newBounds.height) {
                amntShrinkCurrentHeight = newBounds.height - (maxY - y);
            }
            newBounds.height -= amntShrinkCurrentHeight;
            child.setBounds(this.transposer.t(newBounds));
            amntShrinkHeight -= amntShrinkCurrentHeight;
            prefMinSumHeight -= prefHeight - minHeight;
            prefMaxSumHeight -= (double)(maxHeight - prefHeight);
            totalHeight -= prefHeight;
            y += newBounds.height + spacing;
            ++i2;
        }
    }

    protected Dimension getChildPreferredSize(IFigure child, int wHint, int hHint) {
        return super.getChildPreferredSize(child, wHint, hHint);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        return new Dimension(1, 1);
    }

    public void setConstraint(IFigure child, Object constraint) {
        Integer height;
        if (constraint instanceof Integer) {
            height = (Integer)constraint;
        } else if (constraint instanceof Rectangle) {
            height = ((Rectangle)constraint).getSize().height;
        } else if (constraint == null) {
            height = null;
        } else {
            return;
        }
        if (this.constraints == null) {
            this.constraints = new HashMap<IFigure, Integer>();
        }
        if (height == null || height < 0) {
            this.constraints.remove(child);
        } else {
            this.constraints.put(child, height);
        }
        this.invalidate();
    }

    public Integer getConstraint(IFigure child) {
        return this.constraints.containsKey(child) ? this.constraints.get(child) : 0;
    }

    protected List<IFigure> getChildren(IFigure parent) {
        ArrayList<IFigure> children = new ArrayList<IFigure>(parent.getChildren());
        if (this.getIgnoreInvisibleChildren()) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                IFigure f = (IFigure)iter.next();
                if (f.isVisible()) continue;
                iter.remove();
            }
        }
        if (this.isReversed()) {
            Collections.reverse(children);
        }
        return children;
    }

    public void setHorizontal(boolean flag) {
        if (flag) {
            throw new UnsupportedOperationException("Horizontal layout is not supported");
        }
        super.setHorizontal(flag);
    }
}

